/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.MultiChangeSignaller;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.refactoring.BaseDeleteFieldChange;

public class BaseDeleteTypeChange
extends CompositeChange {
    private IType fType;

    public BaseDeleteTypeChange(IType type) {
        super("TCBaseDeleteTypeConfigUpdate");
        this.fType = type;
        TcPlugin plugin = TcPlugin.getDefault();
        IProject project = type.getJavaProject().getProject();
        ConfigurationHelper configHelper = plugin.getConfigurationHelper(project);
        try {
            IField[] fields = type.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!configHelper.isRoot(fields[i])) continue;
                this.add(new BaseDeleteFieldChange(fields[i]));
            }
        }
        catch (JavaModelException jme) {
            // empty catch block
        }
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return "TCBaseDeleteTypeConfigUpdate";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        TcPlugin plugin = TcPlugin.getDefault();
        IProject project = this.fType.getJavaProject().getProject();
        ConfigurationHelper configHelper = plugin.getConfigurationHelper(project);
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        Change undoChange = super.perform(pm);
        configHelper.baseEnsureNotAdaptable(this.fType, signaller);
        configHelper.baseEnsureNotExcluded(this.fType, signaller);
        return undoChange;
    }
}

