/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.properties;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.chooser.ConfigFileBehavior;
import org.terracotta.dso.editors.chooser.PackageNavigator;
import org.terracotta.ui.util.SWTUtil;

public final class DSOPropertyPage
extends PropertyPage {
    private static final String TERRACOTTA_CONFIG = "Terracotta Configuration";
    private static final String BROWSE = "Browse...";
    private static final String RESET = "Reset";
    private static final String SERVER_OPTIONS = "Server Options";
    private Text m_configPathField;
    private Button m_configFileButton;
    private Text m_serverOptionsField;
    private Button m_autoStartServerButton;
    private Button m_warnConfigProblemsButton;
    private Button m_queryRestartButton;
    private Button m_resetOptionsButton;
    private static final String DEFAULT_CONFIG_FILENAME = "tc-config.xml";
    private static final String DEFAULT_SERVER_OPTIONS = "-Xms256m -Xmx256m";
    private static final boolean DEFAULT_AUTO_START_SERVER_OPTION = false;
    private static final boolean DEFAULT_WARN_CONFIG_PROBLEMS_OPTION = true;
    private static final boolean DEFAULT_QUERY_RESTART_OPTION = true;
    private static final String AUTO_RESTART_SERVER_MSG = "Automatically start the Terracotta Server instance when necessary";
    private static final String WARN_CONFIG_PROBLEMS_MSG = "Warn about config problems before launching a Terracotta process";
    private static final String QUERY_RESTART_MSG = "When the config changes, offer to restart running Terracotta processes";

    private void fillControls() {
        TcPlugin plugin = TcPlugin.getDefault();
        IProject project = this.getProject();
        IFile configFile = plugin.getConfigurationFile(project);
        this.validateConfigFile(configFile);
        this.m_configPathField.setText(configFile != null ? configFile.getProjectRelativePath().toString() : "");
        this.m_serverOptionsField.setText(plugin.getServerOptions(project));
        this.m_autoStartServerButton.setSelection(plugin.getAutoStartServerOption(project));
        this.m_warnConfigProblemsButton.setSelection(plugin.getWarnConfigProblemsOption(project));
        this.m_queryRestartButton.setSelection(plugin.getQueryRestartOption(project));
    }

    protected Control createContents(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        topComp.setLayout((Layout)gridLayout);
        topComp.setLayoutData((Object)new GridData(768));
        Group domainConfig = new Group(topComp, 0);
        domainConfig.setText(TERRACOTTA_CONFIG);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        domainConfig.setLayout((Layout)gridLayout);
        domainConfig.setLayoutData((Object)new GridData(768));
        this.m_configPathField = new Text((Composite)domainConfig, 2052);
        this.m_configPathField.setLayoutData((Object)new GridData(768));
        this.m_configFileButton = new Button((Composite)domainConfig, 8);
        this.m_configFileButton.setText(BROWSE);
        this.m_configFileButton.setLayoutData((Object)new GridData(128));
        SWTUtil.applyDefaultButtonSize(this.m_configFileButton);
        this.m_configFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFileBehavior behavior = new ConfigFileBehavior();
                PackageNavigator dialog = new PackageNavigator(DSOPropertyPage.this.getShell(), behavior.getTitle(), DSOPropertyPage.this.getProject(), behavior);
                dialog.addValueListener(new UpdateEventListener(){

                    public void handleUpdate(UpdateEvent event) {
                        DSOPropertyPage.this.m_configPathField.setText((String)event.data);
                        DSOPropertyPage.this.validateConfigFile();
                    }
                });
                dialog.open();
            }
        });
        Group serverOptions = new Group(topComp, 0);
        serverOptions.setText(SERVER_OPTIONS);
        serverOptions.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 60;
        serverOptions.setLayoutData((Object)gridData);
        this.m_serverOptionsField = new Text((Composite)serverOptions, 2562);
        GridData gd = new GridData(1808);
        this.m_serverOptionsField.setLayoutData((Object)gd);
        this.m_resetOptionsButton = new Button((Composite)serverOptions, 8);
        this.m_resetOptionsButton.setText(RESET);
        SWTUtil.applyDefaultButtonSize(this.m_resetOptionsButton);
        gd = (GridData)this.m_resetOptionsButton.getLayoutData();
        gd.verticalAlignment = 1;
        this.m_resetOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSOPropertyPage.this.m_serverOptionsField.setText(DSOPropertyPage.DEFAULT_SERVER_OPTIONS);
            }
        });
        this.m_autoStartServerButton = new Button(topComp, 32);
        this.m_autoStartServerButton.setText(AUTO_RESTART_SERVER_MSG);
        this.m_autoStartServerButton.setLayoutData((Object)new GridData());
        this.m_warnConfigProblemsButton = new Button(topComp, 32);
        this.m_warnConfigProblemsButton.setText(WARN_CONFIG_PROBLEMS_MSG);
        this.m_warnConfigProblemsButton.setLayoutData((Object)new GridData());
        this.m_queryRestartButton = new Button(topComp, 32);
        this.m_queryRestartButton.setText(QUERY_RESTART_MSG);
        this.m_queryRestartButton.setLayoutData((Object)new GridData());
        Composite composite = new Composite(topComp, 0x1000000);
        composite.setLayoutData((Object)new GridData(1040));
        this.fillControls();
        return topComp;
    }

    protected void performDefaults() {
        this.m_configPathField.setText(DEFAULT_CONFIG_FILENAME);
        this.m_serverOptionsField.setText(DEFAULT_SERVER_OPTIONS);
        this.m_autoStartServerButton.setSelection(false);
        this.m_warnConfigProblemsButton.setSelection(true);
        this.m_queryRestartButton.setSelection(true);
    }

    private IProject getProject() {
        return ((IJavaProject)this.getElement()).getProject();
    }

    private void updateProject() {
        TcPlugin plugin = TcPlugin.getDefault();
        IProject project = this.getProject();
        plugin.setup(project, this.m_configPathField.getText(), this.m_serverOptionsField.getText());
        plugin.setAutoStartServerOption(project, this.m_autoStartServerButton.getSelection());
        plugin.setWarnConfigProblemsOption(project, this.m_warnConfigProblemsButton.getSelection());
        plugin.setQueryRestartOption(project, this.m_queryRestartButton.getSelection());
    }

    public boolean performOk() {
        if (this.validateConfigFile()) {
            this.updateProject();
            return true;
        }
        this.getControl().getDisplay().beep();
        this.m_configPathField.forceFocus();
        return false;
    }

    private boolean validateConfigFile() {
        IProject project = this.getProject();
        IFile configFile = project.getFile(this.m_configPathField.getText());
        return this.validateConfigFile(configFile);
    }

    private boolean validateConfigFile(IFile configFile) {
        if (configFile == null || !configFile.exists()) {
            this.setErrorMessage("Config file not found");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

