/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xmlbeans;

import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolder;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolderHelper;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class XmlStringField
implements XmlObjectHolder {
    private final XmlObjectHolderHelper m_helper = new XmlObjectHolderHelper();
    private final Text m_text;
    private final FocusListener m_focusListener;
    private final KeyListener m_keyListener;
    private boolean m_listening;

    public static XmlStringField newInstance(Text text) {
        XmlStringField field = new XmlStringField(text);
        field.addListeners();
        return field;
    }

    protected XmlStringField(Text text) {
        this.m_text = text;
        this.m_focusListener = new TextFocusAdapter();
        this.m_keyListener = new TextKeyAdapter();
    }

    protected void addListeners() {
        this.m_text.addFocusListener(this.m_focusListener);
        this.m_text.addKeyListener(this.m_keyListener);
        this.m_listening = true;
    }

    protected void ensureXmlObject() {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)this.m_text);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    public void init(Class parentType, String elementName) {
        this.m_helper.init(parentType, elementName);
    }

    public void setup(XmlObject parent) {
        this.setListening(false);
        this.m_helper.setup(parent);
        this.setText(this.stringValue());
        this.setListening(true);
    }

    public void tearDown() {
        this.m_helper.tearDown();
        this.setListening(false);
        this.setText("");
    }

    public String stringValue() {
        return this.isSet() ? this.m_helper.getStringValue() : this.m_helper.defaultStringValue();
    }

    public boolean isRequired() {
        return this.m_helper.isRequired();
    }

    public boolean isSet() {
        return this.m_helper.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set() {
        this.setListening(false);
        try {
            String s = this.getText();
            if (this.m_helper.hasDefault() && this.m_helper.defaultStringValue().equals(s)) {
                this.unset();
            } else if (!s.equals(this.m_helper.getStringValue())) {
                this.ensureXmlObject();
                this.m_helper.set(s);
                this.m_text.setText(s);
            }
        }
        finally {
            this.setListening(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset() {
        if (!this.isRequired()) {
            this.setListening(false);
            try {
                this.m_helper.unset();
                this.setText(this.m_helper.defaultStringValue());
            }
            finally {
                this.setListening(true);
            }
        }
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.addXmlObjectStructureListener(listener);
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.removeXmlObjectStructureListener(listener);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setText(String text) {
        this.m_text.setText(text != null ? text : "");
    }

    private void setListening(boolean listening) {
        if (this.m_listening != listening) {
            this.m_listening = listening;
        }
    }

    private class TextKeyAdapter
    extends KeyAdapter {
        private TextKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (!XmlStringField.this.m_listening) {
                return;
            }
            switch (e.keyCode) {
                case 13: {
                    XmlStringField.this.set();
                    break;
                }
                case 0x100000E: {
                    XmlStringField.this.unset();
                }
            }
        }
    }

    private class TextFocusAdapter
    extends FocusAdapter {
        private TextFocusAdapter() {
        }

        public void focusLost(FocusEvent e) {
            if (XmlStringField.this.m_listening) {
                XmlStringField.this.set();
            }
        }
    }
}

