/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xmlbeans;

import org.apache.xmlbeans.StringEnumAbstractBase;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolder;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolderHelper;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class XmlStringEnumCombo
implements XmlObjectHolder {
    private final XmlObjectHolderHelper m_helper = new XmlObjectHolderHelper();
    private final Combo m_combo;
    private final ModifyListener m_modifyListener;
    private final KeyListener m_keyListener;
    private boolean m_listening;
    private StringEnumAbstractBase[] m_enumValues;

    public static XmlStringEnumCombo newInstance(Combo combo) {
        XmlStringEnumCombo result = new XmlStringEnumCombo(combo);
        result.addListeners();
        return result;
    }

    protected void addListeners() {
        this.m_combo.addModifyListener(this.m_modifyListener);
        this.m_combo.addKeyListener(this.m_keyListener);
        this.m_listening = true;
    }

    protected XmlStringEnumCombo(Combo combo) {
        this.m_combo = combo;
        this.m_modifyListener = new ComboModifyListener();
        this.m_keyListener = new ComboKeyAdapter();
    }

    protected void ensureXmlObject() {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)this.m_combo);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    public void init(Class parentType, String elementName) {
        this.m_helper.init(parentType, elementName);
        this.m_enumValues = this.m_helper.getEnumValues();
        for (int i = 0; i < this.m_enumValues.length; ++i) {
            this.m_combo.add(this.m_enumValues[i].toString());
        }
    }

    private int valueIndex(StringEnumAbstractBase enumValue) {
        for (int i = 0; i < this.m_enumValues.length; ++i) {
            if (!enumValue.equals(this.m_enumValues[i])) continue;
            return i;
        }
        return -1;
    }

    public void setup(XmlObject parent) {
        this.m_listening = false;
        this.m_helper.setup(parent);
        this.m_combo.select(this.valueIndex(this.enumValue()));
        this.m_listening = true;
    }

    public void tearDown() {
        this.m_helper.tearDown();
        this.m_listening = false;
    }

    public String getSelectedEnumString() {
        return this.m_enumValues[this.m_combo.getSelectionIndex()].toString();
    }

    public int getSelectedEnumInt() {
        return this.m_enumValues[this.m_combo.getSelectionIndex()].intValue();
    }

    public StringEnumAbstractBase enumValue() {
        return this.isSet() ? this.m_helper.getEnumValue() : this.m_helper.defaultEnumValue();
    }

    public boolean isRequired() {
        return this.m_helper.isRequired();
    }

    public boolean isSet() {
        return this.m_helper.isSet();
    }

    public void set() {
        String s = this.getSelectedEnumString();
        this.ensureXmlObject();
        this.m_helper.set(s);
    }

    public void unset() {
        if (!this.isRequired()) {
            this.m_listening = false;
            this.m_helper.unset();
            this.m_combo.select(this.valueIndex(this.m_helper.defaultEnumValue()));
            this.m_listening = true;
        }
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.addXmlObjectStructureListener(listener);
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.removeXmlObjectStructureListener(listener);
    }

    private class ComboKeyAdapter
    extends KeyAdapter {
        private ComboKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (!XmlStringEnumCombo.this.m_listening) {
                return;
            }
            switch (e.keyCode) {
                case 13: {
                    XmlStringEnumCombo.this.set();
                    break;
                }
                case 0x100000E: {
                    XmlStringEnumCombo.this.unset();
                }
            }
        }
    }

    private class ComboModifyListener
    implements ModifyListener {
        private ComboModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (XmlStringEnumCombo.this.m_listening) {
                XmlStringEnumCombo.this.set();
            }
        }
    }
}

