/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xmlbeans;

import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaStringEnumEntry;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;

public class XmlObjectHolderHelper {
    private XmlObject m_parent;
    private Class m_parentType;
    private SchemaType m_parentSchemaType;
    private String m_elementName;
    private String m_fieldName;
    private SchemaProperty m_schemaProperty;
    private SchemaType m_propertySchemaType;
    private String m_defaultStringValue;
    private transient ArrayList<XmlObjectStructureListener> m_listenerList;
    private transient XmlObjectStructureChangeEvent m_changeEvent;
    private static final Class[] NO_PARAMS = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public XmlObject getParent() {
        return this.m_parent;
    }

    public Class getParentType() {
        return this.m_parentType;
    }

    public String getElementName() {
        return this.m_elementName;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public void init(Class parentType, String elementName) {
        this.m_parentType = parentType;
        this.m_elementName = elementName;
        this.m_fieldName = XmlObjectHolderHelper.convertElementName(elementName);
        if (Character.isDigit(elementName.charAt(elementName.length() - 1))) {
            this.m_elementName = elementName.substring(0, elementName.length() - 1);
        }
        this.m_parentSchemaType = null;
        this.m_schemaProperty = null;
        this.m_propertySchemaType = null;
        this.m_defaultStringValue = null;
    }

    public void setup(XmlObject parent) {
        this.m_parent = parent;
        if (this.m_changeEvent != null) {
            this.m_changeEvent.setXmlObject(parent);
        }
    }

    public void tearDown() {
        this.m_parent = null;
        if (this.m_changeEvent != null) {
            this.m_changeEvent.setXmlObject(null);
        }
    }

    private static String convertElementName(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "-");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            sb.append(Character.toUpperCase(tok.charAt(0)));
            sb.append(tok.substring(1));
        }
        return sb.toString();
    }

    public XmlObject getXmlObject() {
        if (this.m_parent != null) {
            try {
                return (XmlObject)this.invokePrefixedParentNoParams("xget");
            }
            catch (Exception e) {
                try {
                    return (XmlObject)this.invokePrefixedParentNoParams("get");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        return null;
    }

    public XmlObject ensureXmlObject() {
        XmlObject xmlObject = null;
        if (this.m_parent != null && (xmlObject = this.getXmlObject()) == null) {
            try {
                Method method;
                Class[] params = new Class[]{this.getPropertySchemaType().getJavaClass()};
                Object[] args = new Object[]{this.getSchemaProperty().getDefaultValue()};
                String methodName = "xset" + this.m_fieldName;
                try {
                    method = this.m_parentType.getMethod(methodName, params);
                }
                catch (NoSuchMethodException nsme) {
                    methodName = "set" + this.m_fieldName;
                    method = this.m_parentType.getMethod(methodName, params);
                }
                method.invoke((Object)this.m_parent, args);
                xmlObject = this.getXmlObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xmlObject;
    }

    private SchemaType getParentSchemaType() {
        if (this.m_parentSchemaType == null) {
            try {
                this.m_parentSchemaType = (SchemaType)this.m_parentType.getField("type").get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_parentSchemaType;
    }

    private SchemaProperty getSchemaProperty() {
        if (this.m_schemaProperty == null) {
            QName qname = QName.valueOf(this.m_elementName);
            SchemaType type = this.getParentSchemaType();
            this.m_schemaProperty = type.getElementProperty(qname);
            if (this.m_schemaProperty == null) {
                this.m_schemaProperty = type.getAttributeProperty(qname);
            }
        }
        return this.m_schemaProperty;
    }

    private SchemaType getPropertySchemaType() {
        if (this.m_propertySchemaType == null) {
            this.m_propertySchemaType = this.getSchemaProperty().getType();
        }
        return this.m_propertySchemaType;
    }

    public boolean hasStringEnumValues() {
        return this.getPropertySchemaType().hasStringEnumValues();
    }

    public StringEnumAbstractBase[] getEnumValues() {
        SchemaStringEnumEntry[] enumEntries = this.getPropertySchemaType().getStringEnumEntries();
        int size = enumEntries.length;
        StringEnumAbstractBase[] entries = new StringEnumAbstractBase[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = this.enumForInt(enumEntries[i].getIntValue());
        }
        return entries;
    }

    public StringEnumAbstractBase defaultEnumValue() {
        return this.enumForString(this.defaultStringValue());
    }

    public boolean isRequired() {
        return this.getSchemaProperty().getMinOccurs().intValue() > 0;
    }

    public boolean hasDefault() {
        return this.getSchemaProperty().hasDefault() > 0;
    }

    public boolean isSet() {
        if (this.m_parent == null) {
            return false;
        }
        if (this.isRequired()) {
            return true;
        }
        try {
            return (Boolean)this.invokePrefixedParentNoParams("isSet");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public StringEnumAbstractBase getEnumValue() {
        try {
            return this.enumForString(((XmlToken)this.getXmlObject()).getStringValue());
        }
        catch (Exception e) {
            return this.defaultEnumValue();
        }
    }

    public StringEnumAbstractBase enumForInt(int i) {
        return this.getPropertySchemaType().enumForInt(i);
    }

    public StringEnumAbstractBase enumForString(String s) {
        return this.getPropertySchemaType().enumForString(s);
    }

    private XmlAnySimpleType getPropertyFacet(int facet) {
        return this.getPropertySchemaType().getFacet(facet);
    }

    public Integer minInclusive() {
        XmlInteger min = (XmlInteger)this.getPropertyFacet(4);
        return min.getBigIntegerValue().intValue();
    }

    public Integer maxInclusive() {
        XmlInteger min = (XmlInteger)this.getPropertyFacet(5);
        return min.getBigIntegerValue().intValue();
    }

    public int defaultInteger() {
        return XmlObjectHolderHelper.parseInt(this.defaultStringValue());
    }

    public Integer defaultIntegerValue() {
        return this.defaultInteger();
    }

    public int getInteger() {
        return XmlObjectHolderHelper.parseInt(this.getStringValue(), this.defaultInteger());
    }

    public Integer getIntegerValue() {
        return this.getInteger();
    }

    public boolean defaultBoolean() {
        return this.defaultBooleanValue();
    }

    public Boolean defaultBooleanValue() {
        return Boolean.valueOf(this.defaultStringValue());
    }

    public boolean getBoolean() {
        return this.getBooleanValue();
    }

    public Boolean getBooleanValue() {
        return Boolean.valueOf(this.getStringValue());
    }

    public String defaultStringValue() {
        if (this.m_defaultStringValue == null) {
            this.m_defaultStringValue = this.getSchemaProperty().getDefaultText();
        }
        return this.m_defaultStringValue;
    }

    public String getStringValue() {
        XmlAnySimpleType o = (XmlAnySimpleType)this.getXmlObject();
        return o != null ? o.getStringValue() : null;
    }

    public void set(String text) {
        if (this.m_parent == null) {
            return;
        }
        try {
            XmlObject xmlObject = this.ensureXmlObject();
            Class[] params = new Class[]{String.class};
            Object[] args = new Object[]{text};
            String methodName = "setStringValue";
            Class<?> objClass = xmlObject.getClass();
            Method method = objClass.getMethod(methodName, params);
            method.invoke((Object)xmlObject, args);
            this.fireXmlObjectStructureChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unset() {
        if (this.m_parent == null || this.isRequired() || !this.isSet()) {
            return;
        }
        try {
            this.invokePrefixedParentNoParams("unset");
            this.fireXmlObjectStructureChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object invokePrefixedParentNoParams(String prefix) throws Exception {
        Method method = this.m_parentType.getMethod(prefix + this.m_fieldName, NO_PARAMS);
        return method != null ? method.invoke((Object)this.m_parent, NO_ARGS) : null;
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        if (listener != null) {
            if (this.m_listenerList == null) {
                this.m_listenerList = new ArrayList();
            }
            this.m_listenerList.add(listener);
        }
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        if (listener != null && this.m_listenerList != null) {
            this.m_listenerList.remove(listener);
        }
    }

    private XmlObjectStructureChangeEvent getChangeEvent() {
        if (this.m_changeEvent == null) {
            this.m_changeEvent = new XmlObjectStructureChangeEvent();
            if (this.m_parent != null) {
                this.m_changeEvent.setXmlObject(this.m_parent);
            }
        }
        return this.m_changeEvent;
    }

    private XmlObjectStructureListener[] getListenerArray() {
        return this.m_listenerList.toArray(new XmlObjectStructureListener[0]);
    }

    protected synchronized void fireXmlObjectStructureChanged() {
        if (this.m_listenerList != null) {
            XmlObjectStructureListener[] listeners = this.getListenerArray();
            XmlObjectStructureChangeEvent event = this.getChangeEvent();
            for (XmlObjectStructureListener listener : listeners) {
                listener.structureChanged(event);
            }
        }
    }

    protected static int parseInt(String s) {
        return XmlObjectHolderHelper.parseInt(s, 42);
    }

    protected static int parseInt(String s, int defaultValue) {
        try {
            return NumberFormat.getIntegerInstance().parse(s).intValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

