/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xmlbeans;

import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolder;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolderHelper;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class XmlBooleanToggle
implements XmlObjectHolder {
    private final XmlObjectHolderHelper m_helper = new XmlObjectHolderHelper();
    private final Button m_button;
    private final SelectionListener m_selectionListener;
    private boolean m_listening;

    public static XmlBooleanToggle newInstance(Button button) {
        XmlBooleanToggle toggle = new XmlBooleanToggle(button);
        toggle.addListeners();
        return toggle;
    }

    protected XmlBooleanToggle(Button button) {
        this.m_button = button;
        this.m_selectionListener = new ButtonSelectionAdapter();
    }

    protected void addListeners() {
        this.m_button.addSelectionListener(this.m_selectionListener);
        this.m_listening = true;
    }

    protected void ensureXmlObject() {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)this.m_button);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    public void init(Class parentClass, String elementName) {
        this.m_helper.init(parentClass, elementName);
    }

    public void setup(XmlObject parent) {
        this.m_listening = false;
        this.m_helper.setup(parent);
        this.m_button.setSelection(this.booleanValue());
        this.m_listening = true;
    }

    public void tearDown() {
        this.m_helper.tearDown();
        this.m_listening = false;
        this.m_button.setSelection(false);
    }

    public boolean booleanValue() {
        return this.isSet() ? this.m_helper.getBoolean() : this.m_helper.defaultBoolean();
    }

    public boolean isRequired() {
        return this.m_helper.isRequired();
    }

    public boolean isSet() {
        return this.m_helper.isSet();
    }

    public void set() {
        this.m_listening = false;
        boolean isSelected = this.m_button.getSelection();
        if (isSelected == this.m_helper.defaultBoolean()) {
            this.unset();
        } else {
            String s = Boolean.toString(isSelected);
            this.ensureXmlObject();
            this.m_helper.set(s);
            this.m_button.setSelection(isSelected);
        }
        this.m_listening = true;
    }

    public void unset() {
        if (!this.isRequired()) {
            this.m_listening = false;
            this.m_helper.unset();
            this.m_button.setSelection(this.m_helper.defaultBoolean());
            this.m_listening = true;
        }
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.addXmlObjectStructureListener(listener);
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.removeXmlObjectStructureListener(listener);
    }

    public void setSelection(boolean value) {
        this.m_button.setSelection(value);
    }

    public boolean getSelection() {
        return this.m_button.getSelection();
    }

    public void setText(String text) {
        this.m_button.setText(text);
    }

    public String getText() {
        return this.m_button.getText();
    }

    public void setEnabled(boolean enabled) {
        this.m_button.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.m_button.isEnabled();
    }

    private class ButtonSelectionAdapter
    extends SelectionAdapter {
        private ButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (XmlBooleanToggle.this.m_listening) {
                XmlBooleanToggle.this.set();
            }
        }
    }
}

