/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import com.tc.util.event.EventMulticaster;
import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.terracotta.dso.editors.chooser.NavigatorBehavior;

public class PackageNavigator
extends ElementTreeSelectionDialog {
    private final IProject m_project;
    private final EventMulticaster m_valueListener;
    private final NavigatorBehavior m_behavior;

    public PackageNavigator(Shell shell, String title, IProject project, NavigatorBehavior behavior) {
        super(shell, behavior.getLabelProvider(), behavior.getContentProvider());
        this.m_project = project;
        this.m_valueListener = new EventMulticaster();
        this.m_behavior = behavior;
        this.setComparator((ViewerComparator)new JavaElementComparator());
        this.setTitle(behavior.getTitle());
        this.setMessage(behavior.getMessage());
        this.addFilter(behavior.getFilter(JavaCore.create((IProject)this.m_project)));
        this.setValidator(behavior.getValidator());
        this.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.setAllowMultiple(behavior.style() == 2);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.m_valueListener.fireUpdateEvent(new UpdateEvent(this.m_behavior.getValues()));
        }
        super.buttonPressed(buttonId);
    }

    public void addValueListener(UpdateEventListener listener) {
        this.m_valueListener.addListener(listener);
    }
}

