/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.chooser.AbstractNavigatorBehavior;

public final class MethodBehavior
extends AbstractNavigatorBehavior {
    public static final String ADD_MSG = "Enter Method Expression";
    private static final String SELECT_METHOD = "Select Method";
    private final List m_selectedValues = new ArrayList();

    public int style() {
        return 2;
    }

    public String getTitle() {
        return SELECT_METHOD;
    }

    public ViewerFilter getFilter(IJavaProject javaProject) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    return true;
                }
                if (parentElement instanceof IJavaProject) {
                    if (element instanceof IFile || element instanceof IFolder) {
                        return false;
                    }
                    if (element instanceof IPackageFragment) {
                        try {
                            return ((IPackageFragment)element).containsJavaResources();
                        }
                        catch (JavaModelException jme) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                if (element instanceof ICompilationUnit || element instanceof IType || element instanceof IClassFile || element instanceof IMethod) {
                    return true;
                }
                if (element instanceof IPackageFragment) {
                    try {
                        return ((IPackageFragment)element).containsJavaResources();
                    }
                    catch (JavaModelException jme) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
    }

    public ISelectionStatusValidator getValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                MethodBehavior.this.m_selectedValues.clear();
                for (Object element : selection) {
                    if (!(element instanceof IMethod)) continue;
                    IMethod method = (IMethod)element;
                    MethodBehavior.this.m_selectedValues.add(PatternHelper.getExecutionPattern(method));
                }
                String id = TcPlugin.getPluginId();
                if (MethodBehavior.this.m_selectedValues.size() == 0) {
                    return new Status(4, id, 4, "", null);
                }
                return new Status(0, id, 0, "", null);
            }
        };
    }

    public Object getValues() {
        return this.m_selectedValues.toArray(new String[0]);
    }

    public String getMessage() {
        return ADD_MSG;
    }
}

