/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.chooser.AbstractNavigatorBehavior;

public class FileBehavior
extends AbstractNavigatorBehavior {
    private static final String SELECT_FILE = "Select File";
    private static final String SELECT_FILE_MSG = "Select a file";
    protected String m_selectedValue;

    public int style() {
        return 4;
    }

    public String getTitle() {
        return SELECT_FILE;
    }

    public ViewerFilter getFilter(IJavaProject javaProject) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FileBehavior.this.filterSelect(viewer, parentElement, element);
            }
        };
    }

    protected boolean packageFragmentContainsJavaResources(IPackageFragment packageFragment) {
        try {
            return packageFragment.containsJavaResources();
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    protected boolean isPackageFragmentBinaryKind(IPackageFragment packageFragment) {
        try {
            return packageFragment.getKind() == 2;
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    protected boolean filterSelect(Viewer viewer, Object parentElement, Object element) {
        if (parentElement instanceof ICompilationUnit || parentElement instanceof IClassFile) {
            return false;
        }
        if (element instanceof IJavaModel) {
            return true;
        }
        if (element instanceof IJavaProject) {
            return true;
        }
        if (element instanceof IFolder) {
            return true;
        }
        if (element instanceof IFile) {
            return true;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)element;
            if (this.isPackageFragmentBinaryKind(packageFragment) || packageFragment.isDefaultPackage() && !this.packageFragmentContainsJavaResources(packageFragment)) {
                return false;
            }
            try {
                return ((IPackageFragment)element).containsJavaResources();
            }
            catch (JavaModelException jme) {
                return true;
            }
        }
        if (element instanceof IPackageFragmentRoot) {
            return true;
        }
        return element instanceof ICompilationUnit;
    }

    public ISelectionStatusValidator getValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                FileBehavior.this.m_selectedValue = null;
                for (Object element : selection) {
                    if (!(element instanceof IFile)) continue;
                    IFile file = (IFile)element;
                    FileBehavior.this.m_selectedValue = file.getProjectRelativePath().toString();
                }
                String id = TcPlugin.getPluginId();
                if (FileBehavior.this.m_selectedValue == null) {
                    return new Status(4, id, 4, "", null);
                }
                return new Status(0, id, 0, "", null);
            }
        };
    }

    public Object getValues() {
        return this.m_selectedValue;
    }

    public String getMessage() {
        return SELECT_FILE_MSG;
    }
}

