/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.chooser.AbstractNavigatorBehavior;

public final class FieldBehavior
extends AbstractNavigatorBehavior {
    public static final String ADD_MSG = "Enter Fully Qualified Field Name";
    private static final String SELECT_FIELD = "Select Member Field";
    private final List m_selectedValues = new ArrayList();

    public int style() {
        return 2;
    }

    public String getTitle() {
        return SELECT_FIELD;
    }

    public ViewerFilter getFilter(IJavaProject javaProject) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    return true;
                }
                if (parentElement instanceof IJavaProject) {
                    if (element instanceof IFile || element instanceof IFolder) {
                        return false;
                    }
                    if (element instanceof IPackageFragment) {
                        try {
                            return ((IPackageFragment)element).containsJavaResources();
                        }
                        catch (JavaModelException jme) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                if (element instanceof ICompilationUnit || element instanceof IType || element instanceof IClassFile || element instanceof IField) {
                    return true;
                }
                if (element instanceof IPackageFragment) {
                    try {
                        return ((IPackageFragment)element).containsJavaResources();
                    }
                    catch (JavaModelException jme) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
    }

    public ISelectionStatusValidator getValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                FieldBehavior.this.m_selectedValues.clear();
                for (Object element : selection) {
                    if (!(element instanceof IField)) continue;
                    IField field = (IField)element;
                    FieldBehavior.this.m_selectedValues.add(FieldBehavior.this.resolveFullName((IJavaElement)field));
                }
                String id = TcPlugin.getPluginId();
                if (FieldBehavior.this.m_selectedValues.size() == 0) {
                    return new Status(4, id, 4, "", null);
                }
                return new Status(0, id, 0, "", null);
            }
        };
    }

    private String resolveFullName(IJavaElement field) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(field.getElementName());
        for (IJavaElement javaPart = field.getParent(); javaPart != null; javaPart = javaPart.getParent()) {
            if (javaPart.getElementType() != 7 && javaPart.getElementType() != 4 && javaPart.getElementType() != 11) continue;
            list.add(javaPart.getElementName());
        }
        String[] parts = list.toArray(new String[0]);
        StringBuffer name = new StringBuffer();
        for (int i = parts.length - 1; i >= 1; --i) {
            name.append(parts[i] + ".");
        }
        name.append(parts[0]);
        return name.toString();
    }

    public Object getValues() {
        return this.m_selectedValues.toArray(new String[0]);
    }

    public String getMessage() {
        return ADD_MSG;
    }
}

