/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import com.tc.util.event.EventMulticaster;
import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.editors.chooser.NavigatorBehavior;
import org.terracotta.dso.editors.chooser.PackageNavigator;
import org.terracotta.ui.util.SWTUtil;

public class ExpressionChooser
extends MessageDialog {
    private static final String EXPLORE = "Explore...";
    private static final String ADD = "Add";
    private final Shell m_parentShell;
    private final IProject m_project;
    private final EventMulticaster m_valueListener;
    private Shell m_shell;
    private boolean m_isAddButton;
    private SelectionListener m_exploreListener;
    private SelectionListener m_addListener;
    private Layout m_layout;
    private NavigatorBehavior m_behavior;

    public ExpressionChooser(Shell shell, String title, String message, IProject project, NavigatorBehavior behavior) {
        super(shell, title, null, message, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.m_parentShell = shell;
        this.m_project = project;
        this.m_valueListener = new EventMulticaster();
        this.m_behavior = behavior;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.m_shell = shell;
        this.m_shell.setSize(400, 250);
        SWTUtil.placeDialogInCenter(this.m_parentShell, this.m_shell);
    }

    protected Control createCustomArea(Composite parent) {
        this.m_layout = new Layout(parent);
        this.initLayout(this.m_layout);
        return parent;
    }

    private void initLayout(final Layout layout) {
        this.m_exploreListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageNavigator dialog = new PackageNavigator(ExpressionChooser.this.getShell(), ExpressionChooser.this.m_behavior.getTitle(), ExpressionChooser.this.m_project, ExpressionChooser.this.m_behavior);
                dialog.addValueListener(new UpdateEventListener(){

                    public void handleUpdate(UpdateEvent arg) {
                        String[] values = (String[])arg.data;
                        for (int i = 0; i < values.length; ++i) {
                            layout.m_list.add(values[i]);
                            layout.m_list.forceFocus();
                        }
                    }
                });
                dialog.open();
            }
        };
        layout.m_exploreButton.addSelectionListener(this.m_exploreListener);
        this.m_addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                layout.m_list.add(layout.m_selectField.getText());
                layout.m_selectField.setText("");
            }
        };
        layout.m_selectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Text)e.widget).getText().trim().equals("")) {
                    layout.m_exploreButton.removeSelectionListener(ExpressionChooser.this.m_addListener);
                    layout.m_exploreButton.addSelectionListener(ExpressionChooser.this.m_exploreListener);
                    layout.m_exploreButton.setText(ExpressionChooser.EXPLORE);
                    SWTUtil.applyDefaultButtonSize(layout.m_exploreButton);
                    ExpressionChooser.this.m_shell.setDefaultButton(ExpressionChooser.this.getButton(0));
                    ExpressionChooser.this.m_isAddButton = false;
                } else if (!ExpressionChooser.this.m_isAddButton) {
                    layout.m_exploreButton.removeSelectionListener(ExpressionChooser.this.m_exploreListener);
                    layout.m_exploreButton.addSelectionListener(ExpressionChooser.this.m_addListener);
                    layout.m_exploreButton.setText(ExpressionChooser.ADD);
                    SWTUtil.applyDefaultButtonSize(layout.m_exploreButton);
                    ExpressionChooser.this.m_shell.setDefaultButton(layout.m_exploreButton);
                    ExpressionChooser.this.m_isAddButton = true;
                }
            }
        });
        layout.m_list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    int[] selected = ((List)e.getSource()).getSelectionIndices();
                    layout.m_list.remove(selected);
                    layout.m_selectField.forceFocus();
                }
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.m_valueListener.fireUpdateEvent(new UpdateEvent((Object)this.m_layout.m_list.getItems()));
        }
        super.buttonPressed(buttonId);
    }

    public void addValueListener(UpdateEventListener listener) {
        this.m_valueListener.addListener(listener);
    }

    private class Layout {
        final Text m_selectField;
        final Button m_exploreButton;
        final List m_list;
        GridData m_gridData;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(1808));
            this.m_selectField = new Text(comp, 2052);
            this.m_selectField.setLayoutData((Object)new GridData(768));
            this.m_exploreButton = new Button(comp, 8);
            this.m_exploreButton.setText(ExpressionChooser.EXPLORE);
            SWTUtil.applyDefaultButtonSize(this.m_exploreButton);
            this.m_list = new List(comp, 2562);
            this.m_gridData = new GridData(1808);
            this.m_gridData.horizontalSpan = 2;
            this.m_list.setLayoutData((Object)this.m_gridData);
        }
    }
}

