/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.QualifiedFieldName;
import com.terracottatech.config.TransientFields;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.chooser.ExpressionChooser;
import org.terracotta.dso.editors.chooser.FieldBehavior;
import org.terracotta.ui.util.SWTUtil;

public class TransientFieldsPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private TransientFields m_transientFields;
    private final Layout m_layout = new Layout(this);
    private final AddHandler m_addHandler = new AddHandler();
    private final RemoveHandler m_removeHandler = new RemoveHandler();
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();

    public TransientFieldsPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_transientFields != null && this.m_transientFields.sizeOfFieldNameArray() > 0;
    }

    private TransientFields ensureTransientFields() {
        if (this.m_transientFields == null) {
            this.ensureXmlObject();
        }
        return this.m_transientFields;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_transientFields == null) {
            this.removeListeners();
            this.m_transientFields = this.m_dsoApp.addNewTransientFields();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testRemoveTransientFields() {
        if (!this.hasAnySet() && this.m_dsoApp.getTransientFields() != null) {
            this.m_dsoApp.unsetTransientFields();
            this.m_transientFields = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.fireTransientFieldsChanged();
        this.testDisableRemoveButton();
    }

    private void addListeners() {
        this.m_layout.m_addButton.addSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.addSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.addListener(36, (Listener)this.m_tableDataListener);
    }

    private void removeListeners() {
        this.m_layout.m_addButton.removeSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.removeSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.removeListener(36, (Listener)this.m_tableDataListener);
    }

    public void updateChildren() {
        this.initTableItems();
        this.testDisableRemoveButton();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_transientFields = this.m_dsoApp != null ? this.m_dsoApp.getTransientFields() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoApp = null;
        this.m_transientFields = null;
        this.setEnabled(false);
    }

    private void initTableItems() {
        this.m_layout.m_table.removeAll();
        if (this.m_transientFields == null) {
            return;
        }
        XmlObject[] fields = this.m_transientFields.selectPath("*");
        for (int i = 0; i < fields.length; ++i) {
            this.createTableItem((QualifiedFieldName)fields[i]);
        }
        if (fields.length > 0) {
            this.m_layout.m_table.setSelection(0);
        }
    }

    private void initTableItem(TableItem item, QualifiedFieldName qfn) {
        item.setText(qfn.getStringValue());
    }

    private void updateTableItem(int index) {
        TableItem item = this.m_layout.m_table.getItem(index);
        this.initTableItem(item, (QualifiedFieldName)item.getData());
    }

    private void createTableItem(QualifiedFieldName qfn) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        this.initTableItem(item, qfn);
        item.setData((Object)qfn);
    }

    private void internalAddTransient(String fieldName) {
        TransientFields transientFields = this.ensureTransientFields();
        transientFields.addFieldName(fieldName);
        this.createTableItem(transientFields.xgetFieldNameArray(transientFields.sizeOfFieldNameArray() - 1));
        int row = this.m_layout.m_table.getItemCount() - 1;
        this.m_layout.m_table.setSelection(row);
    }

    public boolean isTransient(String fieldName) {
        return TcPlugin.getDefault().getConfigurationHelper(this.m_project).isTransient(fieldName);
    }

    private void testDisableRemoveButton() {
        this.m_layout.m_removeButton.setEnabled(this.m_layout.m_table.getSelectionCount() > 0);
    }

    private void handleTableSelection() {
        this.m_layout.m_removeButton.setEnabled(true);
    }

    public void transientFieldChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            int selIndex = this.m_layout.m_table.getSelectionIndex();
            this.updateTableItem(index);
            if (selIndex != -1) {
                this.m_layout.m_table.setSelection(selIndex);
            }
        }
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            int index = TransientFieldsPanel.this.m_layout.m_table.getSelectionIndex();
            QualifiedFieldName qfn = (QualifiedFieldName)item.getData();
            qfn.setStringValue(item.getText(e.index));
            TransientFieldsPanel.this.fireTransientFieldChanged(index);
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TransientFieldsPanel.this.handleTableSelection();
        }
    }

    class RemoveHandler
    extends SelectionAdapter {
        RemoveHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void widgetSelected(SelectionEvent e) {
            TransientFieldsPanel.this.m_layout.m_table.setRedraw(false);
            try {
                TransientFieldsPanel.this.m_layout.m_table.forceFocus();
                int[] selection = TransientFieldsPanel.this.m_layout.m_table.getSelectionIndices();
                for (int i = selection.length - 1; i >= 0; --i) {
                    TransientFieldsPanel.this.ensureTransientFields().removeFieldName(selection[i]);
                }
                TransientFieldsPanel.this.m_layout.m_table.remove(selection);
                TransientFieldsPanel.this.testRemoveTransientFields();
                TransientFieldsPanel.this.handleTableSelection();
            }
            finally {
                TransientFieldsPanel.this.m_layout.m_table.setRedraw(true);
            }
        }
    }

    class AddHandler
    extends SelectionAdapter {
        AddHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            TransientFieldsPanel.this.m_layout.m_table.forceFocus();
            FieldBehavior behavior = new FieldBehavior();
            ExpressionChooser chooser = new ExpressionChooser(TransientFieldsPanel.this.getShell(), behavior.getTitle(), "Enter Fully Qualified Field Name", TransientFieldsPanel.this.m_project, behavior);
            chooser.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent updateEvent) {
                    String[] items = (String[])updateEvent.data;
                    for (int i = 0; i < items.length; ++i) {
                        TransientFieldsPanel.this.internalAddTransient(items[i]);
                    }
                    TransientFieldsPanel.this.fireTransientFieldsChanged();
                }
            });
            chooser.open();
        }
    }

    private static class Layout {
        private static final String TRANSIENT_FIELDS = "Transient Fields";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private final Button m_addButton;
        private final Button m_removeButton;
        private final Table m_table;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(TRANSIENT_FIELDS);
            label.setLayoutData((Object)new GridData(2));
            this.m_table = new Table(sidePanel, 68098);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_table, new int[]{3, 1});
            SWTUtil.makeTableColumnsEditable(this.m_table, new int[]{0});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_table, 3);
            this.m_table.setLayoutData((Object)gridData);
            TableColumn column = new TableColumn(this.m_table, 0);
            column.setText(TRANSIENT_FIELDS);
            column.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addButton = new Button(buttonPanel, 8);
            this.m_addButton.setText(ADD);
            this.m_addButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addButton);
            this.m_removeButton = new Button(buttonPanel, 8);
            this.m_removeButton.setText(REMOVE);
            this.m_removeButton.setEnabled(false);
            this.m_removeButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeButton);
        }
    }
}

