/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.BindPort;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import com.terracottatech.config.TcConfigDocument;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.ConfigurationEditorRoot;
import org.terracotta.dso.editors.ServerPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolderHelper;
import org.terracotta.ui.util.SWTLayout;
import org.terracotta.ui.util.SWTUtil;

public class ServersPanel
extends ConfigurationEditorPanel
implements ConfigurationEditorRoot {
    private IProject m_project;
    private TcConfigDocument.TcConfig m_config;
    private Servers m_servers;
    private Layout m_layout = new Layout(this);
    private TableSelectionHandler m_tableSelectionHandler = new TableSelectionHandler();
    private AddServerHandler m_addServerHandler = new AddServerHandler();
    private RemoveServerHandler m_removeServerHandler = new RemoveServerHandler();
    private static final int NAME_INDEX = 0;
    private static final int HOST_INDEX = 1;
    private static final int DSO_PORT_INDEX = 2;
    private static final int JMX_PORT_INDEX = 3;
    private static int DEFAULT_JMX_PORT;
    private static int DEFAULT_DSO_PORT;

    public ServersPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    private void addListeners() {
        this.m_layout.m_serverTable.addSelectionListener((SelectionListener)this.m_tableSelectionHandler);
        this.m_layout.m_addServerButton.addSelectionListener((SelectionListener)this.m_addServerHandler);
        this.m_layout.m_removeServerButton.addSelectionListener((SelectionListener)this.m_removeServerHandler);
    }

    private void removeListeners() {
        this.m_layout.m_serverTable.removeSelectionListener((SelectionListener)this.m_tableSelectionHandler);
        this.m_layout.m_addServerButton.removeSelectionListener((SelectionListener)this.m_addServerHandler);
        this.m_layout.m_removeServerButton.removeSelectionListener((SelectionListener)this.m_removeServerHandler);
    }

    private void updateChildren() {
        this.m_layout.m_serverTable.removeAll();
        this.initTableItems();
        this.testDisableRemoveButton();
        this.m_layout.m_serverPanel.setVisible(this.haveAnyServers());
    }

    public void setup(IProject project) {
        TcPlugin plugin = TcPlugin.getDefault();
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_config = plugin.getConfiguration(this.m_project);
        this.m_servers = this.m_config != null ? this.m_config.getServers() : null;
        this.updateChildren();
        this.addListeners();
        this.handleTableSelection();
    }

    public IProject getProject() {
        return this.m_project;
    }

    private Server getSelectedServer() {
        int index = this.m_layout.m_serverTable.getSelectionIndex();
        if (index != -1) {
            TableItem item = this.m_layout.m_serverTable.getItem(index);
            return (Server)item.getData();
        }
        return null;
    }

    boolean haveAnyServers() {
        return this.m_servers != null && this.m_servers.sizeOfServerArray() > 0;
    }

    void testRemoveServers() {
        if (this.m_servers != null && this.m_servers.sizeOfServerArray() == 0) {
            this.m_config.unsetServers();
            this.m_servers = null;
        }
        this.m_layout.m_serverPanel.setVisible(this.haveAnyServers());
        this.fireServersChanged();
        this.testDisableRemoveButton();
    }

    private void testDisableRemoveButton() {
        this.m_layout.m_removeServerButton.setEnabled(this.m_layout.m_serverTable.getSelectionCount() > 0);
    }

    public void tearDown() {
        this.removeListeners();
    }

    private void initTableItems() {
        this.m_layout.m_serverTable.removeAll();
        if (this.m_servers == null) {
            return;
        }
        Server[] servers = this.m_servers.getServerArray();
        for (int i = 0; i < servers.length; ++i) {
            this.createTableItem(servers[i]);
        }
        if (servers.length > 0) {
            this.m_layout.m_serverTable.setSelection(0);
        }
    }

    private void initTableItem(TableItem item, Server server) {
        item.setText(new String[]{server.getName(), server.getHost(), Integer.toString(server.isSetDsoPort() ? server.getDsoPort().getIntValue() : DEFAULT_DSO_PORT), Integer.toString(server.isSetJmxPort() ? server.getJmxPort().getIntValue() : DEFAULT_JMX_PORT)});
    }

    private void updateTableItem(int index) {
        TableItem item = this.m_layout.m_serverTable.getItem(index);
        this.initTableItem(item, (Server)item.getData());
    }

    private TableItem createTableItem(Server server) {
        TableItem item = new TableItem(this.m_layout.m_serverTable, 0);
        this.initTableItem(item, server);
        item.setData((Object)server);
        return item;
    }

    private void handleTableSelection() {
        Server server = this.getSelectedServer();
        this.m_layout.m_removeServerButton.setEnabled(server != null);
        this.m_layout.setServer(server);
    }

    int indexOf(Server server) {
        TableItem[] items = this.m_layout.m_serverTable.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (server != items[i].getData()) continue;
            return i;
        }
        return -1;
    }

    void fireServerChanged(Server server) {
        this.fireServerChanged(this.indexOf(server));
    }

    public void serverChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            this.updateTableItem(index);
            this.handleTableSelection();
        }
    }

    public void serversChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.initTableItems();
        }
    }

    static {
        XmlObjectHolderHelper xmlHelper = new XmlObjectHolderHelper();
        xmlHelper.init(Server.class, "dso-port");
        DEFAULT_DSO_PORT = xmlHelper.defaultInteger();
        xmlHelper.init(Server.class, "jmx-port");
        DEFAULT_JMX_PORT = xmlHelper.defaultInteger();
    }

    class RemoveServerHandler
    extends SelectionAdapter {
        RemoveServerHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ServersPanel.this.m_layout.m_serverTable.setRedraw(false);
            ServersPanel.this.m_layout.m_serverTable.forceFocus();
            int index = ServersPanel.this.m_layout.m_serverTable.getSelectionIndex();
            if (index != -1) {
                ServersPanel.this.m_servers.removeServer(index);
                ServersPanel.this.testRemoveServers();
                int count = ServersPanel.this.m_layout.m_serverTable.getItemCount();
                if (count > 0) {
                    if (index >= count) {
                        index = count - 1;
                    }
                    ServersPanel.this.m_layout.m_serverTable.setSelection(index);
                }
                ServersPanel.this.m_layout.m_serverTable.forceFocus();
                ServersPanel.this.handleTableSelection();
                ServersPanel.this.m_layout.m_serverTable.setRedraw(true);
            }
        }
    }

    class AddServerHandler
    extends SelectionAdapter {
        AddServerHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ServersPanel.this.m_layout.m_serverTable.setRedraw(false);
            if (ServersPanel.this.m_servers == null) {
                ServersPanel.this.m_servers = ServersPanel.this.m_config.addNewServers();
            }
            Server server = ServersPanel.this.m_servers.addNewServer();
            server.setName("localhost");
            server.setHost("localhost");
            BindPort dsoPort = BindPort.Factory.newInstance();
            dsoPort.setBind("0.0.0.0");
            dsoPort.setIntValue(9510);
            server.addNewDsoPort();
            server.setDsoPort(dsoPort);
            BindPort jmxPort = BindPort.Factory.newInstance();
            jmxPort.setBind("0.0.0.0");
            jmxPort.setIntValue(9520);
            server.addNewJmxPort();
            server.getJmxPort().setIntValue(9520);
            ServersPanel.this.createTableItem(server);
            ServersPanel.this.fireServersChanged();
            ServersPanel.this.m_layout.m_serverTable.setSelection(ServersPanel.this.m_servers.sizeOfServerArray() - 1);
            ServersPanel.this.m_layout.m_serverTable.forceFocus();
            ServersPanel.this.handleTableSelection();
            ServersPanel.this.m_layout.m_serverTable.setRedraw(true);
        }
    }

    class TableSelectionHandler
    extends SelectionAdapter {
        TableSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ServersPanel.this.handleTableSelection();
        }
    }

    private static class Layout
    implements SWTLayout {
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private static final String SERVERS = "Servers";
        private static final String NAME = "Name";
        private static final String HOST = "Host";
        private static final String DSO_PORT = "DSO Port";
        private static final String JMX_PORT = "JMX Port";
        private Table m_serverTable;
        private Button m_addServerButton;
        private Button m_removeServerButton;
        private ServerPanel m_serverPanel;

        public void reset() {
            this.m_serverTable.removeAll();
            this.setServer(null);
        }

        private void setServer(Server server) {
            this.m_serverPanel.setVisible(server != null);
            if (server != null) {
                this.m_serverPanel.setup(server);
            } else {
                this.m_serverPanel.tearDown();
            }
        }

        private Layout(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            this.createServersGroup(parent);
            this.createServerGroup(parent);
        }

        private void createServersGroup(Composite parent) {
            Group serversGroup = new Group(parent, 0);
            serversGroup.setText(SERVERS);
            GridLayout gridLayout = new GridLayout(2, false);
            serversGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            serversGroup.setLayoutData((Object)gridData);
            this.m_serverTable = new Table((Composite)serversGroup, 68100);
            this.m_serverTable.setHeaderVisible(true);
            this.m_serverTable.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeEqualWidth((Composite)serversGroup, this.m_serverTable);
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_serverTable, 3);
            this.m_serverTable.setLayoutData((Object)gridData);
            TableColumn nameCol = new TableColumn(this.m_serverTable, 0, 0);
            nameCol.setResizable(true);
            nameCol.setText(NAME);
            nameCol.pack();
            TableColumn hostCol = new TableColumn(this.m_serverTable, 0, 1);
            hostCol.setResizable(true);
            hostCol.setText(HOST);
            hostCol.pack();
            TableColumn dsoPortCol = new TableColumn(this.m_serverTable, 0, 2);
            dsoPortCol.setResizable(true);
            dsoPortCol.setText(DSO_PORT);
            dsoPortCol.pack();
            TableColumn jmxPortCol = new TableColumn(this.m_serverTable, 0, 3);
            jmxPortCol.setResizable(true);
            jmxPortCol.setText(JMX_PORT);
            jmxPortCol.pack();
            Composite buttonPanel = new Composite((Composite)serversGroup, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            this.m_addServerButton = new Button(buttonPanel, 8);
            this.m_addServerButton.setText(ADD);
            this.m_addServerButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addServerButton);
            this.m_removeServerButton = new Button(buttonPanel, 8);
            this.m_removeServerButton.setText(REMOVE);
            this.m_removeServerButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeServerButton);
        }

        private void createServerGroup(Composite parent) {
            this.m_serverPanel = new ServerPanel(parent, 0);
            GridData gridData = new GridData(768);
            this.m_serverPanel.setLayoutData(gridData);
        }
    }
}

