/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.Server;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.DsoServerDataPanel;
import org.terracotta.dso.editors.ServersPanel;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerField;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.dso.editors.xmlbeans.XmlStringField;
import org.terracotta.ui.util.SWTLayout;
import org.terracotta.ui.util.SWTUtil;

public class ServerPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private Server m_server;
    private Layout m_layout = new Layout(this);
    private LogsBrowseSelectionHandler m_logsBrowseSelectionHandler = new LogsBrowseSelectionHandler();
    private DataBrowseSelectionHandler m_dataBrowseSelectionHandler = new DataBrowseSelectionHandler();
    private StatisticsBrowseSelectionHandler m_statisticsBrowseSelectionHandler = new StatisticsBrowseSelectionHandler();

    public ServerPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.fireChanged();
    }

    void fireChanged() {
        ServersPanel serversPanel = (ServersPanel)SWTUtil.getAncestorOfClass(ServersPanel.class, (Control)this);
        serversPanel.fireServerChanged(this.m_server);
    }

    public boolean hasAnySet() {
        return this.m_server != null && (this.m_server.isSetData() || this.m_server.isSetLogs() || this.m_server.isSetStatistics() || this.m_server.isSetDsoPort() || this.m_server.isSetDso() || this.m_server.isSetJmxPort() || this.m_server.isSetAuthentication() || this.m_server.isSetName() || this.m_server.isSetHost() || this.m_server.isSetL2GroupPort());
    }

    private void addListeners() {
        ((XmlStringField)this.m_layout.m_nameField.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_hostField.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_dsoPortField.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_jmxPortField.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_dataLocation.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_logsLocation.getData()).addXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_statisticsLocation.getData()).addXmlObjectStructureListener(this);
        this.m_layout.m_dataBrowse.addSelectionListener((SelectionListener)this.m_dataBrowseSelectionHandler);
        this.m_layout.m_logsBrowse.addSelectionListener((SelectionListener)this.m_logsBrowseSelectionHandler);
        this.m_layout.m_statisticsBrowse.addSelectionListener((SelectionListener)this.m_statisticsBrowseSelectionHandler);
        this.m_layout.m_dsoServerDataPanel.addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlStringField)this.m_layout.m_nameField.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_hostField.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_dsoPortField.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_jmxPortField.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_dataLocation.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_logsLocation.getData()).removeXmlObjectStructureListener(this);
        ((XmlStringField)this.m_layout.m_statisticsLocation.getData()).removeXmlObjectStructureListener(this);
        this.m_layout.m_dataBrowse.removeSelectionListener((SelectionListener)this.m_dataBrowseSelectionHandler);
        this.m_layout.m_logsBrowse.removeSelectionListener((SelectionListener)this.m_logsBrowseSelectionHandler);
        this.m_layout.m_statisticsBrowse.removeSelectionListener((SelectionListener)this.m_statisticsBrowseSelectionHandler);
        this.m_layout.m_dsoServerDataPanel.removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setServer(this.m_server);
    }

    public void setup(Server server) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_server = server;
        if (this.m_server != null) {
            this.updateChildren();
            this.addListeners();
        } else {
            this.setEnabled(false);
        }
    }

    public void tearDown() {
        this.removeListeners();
        this.m_server = null;
        this.m_layout.tearDown();
        this.setEnabled(false);
    }

    private class StatisticsBrowseSelectionHandler
    extends SelectionAdapter {
        private StatisticsBrowseSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            IFolder folder = SWTUtil.openSelectFolderDialog(ServerPanel.this.getProject(), "Select statistics folder", "Choose a folder for the server statistics database area");
            if (folder != null) {
                ServerPanel.this.setStringField(ServerPanel.this.m_layout.m_statisticsLocation, folder.getProjectRelativePath().toString());
            }
        }
    }

    private class DataBrowseSelectionHandler
    extends SelectionAdapter {
        private DataBrowseSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            IFolder folder = SWTUtil.openSelectFolderDialog(ServerPanel.this.getProject(), "Select data folder", "Choose a folder for the server database area");
            if (folder != null) {
                ServerPanel.this.setStringField(ServerPanel.this.m_layout.m_dataLocation, folder.getProjectRelativePath().toString());
            }
        }
    }

    private class LogsBrowseSelectionHandler
    extends SelectionAdapter {
        private LogsBrowseSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            IFolder folder = SWTUtil.openSelectFolderDialog(ServerPanel.this.getProject(), "Select logs folder", "Choose a folder for the server log area");
            if (folder != null) {
                ServerPanel.this.setStringField(ServerPanel.this.m_layout.m_logsLocation, folder.getProjectRelativePath().toString());
            }
        }
    }

    private class Layout
    implements SWTLayout {
        private static final String BROWSE = "Browse...";
        private static final String NAME = "Name";
        private static final String HOST = "Host";
        private static final String DSO_PORT = "DSO Port";
        private static final String JMX_PORT = "JMX Port";
        private static final String SERVER = "Server";
        private static final String DATA = "Data";
        private static final String LOGS = "Logs";
        private static final String STATISTICS = "Statistics";
        private Text m_nameField;
        private Text m_hostField;
        private Text m_dsoPortField;
        private Text m_jmxPortField;
        private Text m_dataLocation;
        private Text m_logsLocation;
        private Text m_statisticsLocation;
        private Button m_logsBrowse;
        private Button m_dataBrowse;
        private Button m_statisticsBrowse;
        private Group m_serverGroup;
        private DsoServerDataPanel m_dsoServerDataPanel;

        public void reset() {
            this.resetServerFields(false);
        }

        void tearDown() {
            ((XmlStringField)this.m_nameField.getData()).tearDown();
            ((XmlStringField)this.m_hostField.getData()).tearDown();
            ((XmlIntegerField)this.m_dsoPortField.getData()).tearDown();
            ((XmlIntegerField)this.m_jmxPortField.getData()).tearDown();
            ((XmlStringField)this.m_dataLocation.getData()).tearDown();
            ((XmlStringField)this.m_logsLocation.getData()).tearDown();
            ((XmlStringField)this.m_statisticsLocation.getData()).tearDown();
            this.m_dsoServerDataPanel.tearDown();
        }

        private void setServer(Server server) {
            ((XmlStringField)this.m_nameField.getData()).setup((XmlObject)server);
            ((XmlStringField)this.m_hostField.getData()).setup((XmlObject)server);
            ((XmlIntegerField)this.m_dsoPortField.getData()).setup((XmlObject)server);
            ((XmlIntegerField)this.m_jmxPortField.getData()).setup((XmlObject)server);
            ((XmlStringField)this.m_dataLocation.getData()).setup((XmlObject)server);
            ((XmlStringField)this.m_logsLocation.getData()).setup((XmlObject)server);
            ((XmlStringField)this.m_statisticsLocation.getData()).setup((XmlObject)server);
            this.m_dsoServerDataPanel.setup(server);
        }

        private void resetServerFields(boolean enabled) {
            this.m_nameField.setText("");
            this.m_nameField.setEnabled(enabled);
            this.m_hostField.setText("");
            this.m_hostField.setEnabled(enabled);
            this.m_dsoPortField.setText("");
            this.m_dsoPortField.setEnabled(enabled);
            this.m_jmxPortField.setText("");
            this.m_jmxPortField.setEnabled(enabled);
            this.m_dataLocation.setText("");
            this.m_dataLocation.setEnabled(enabled);
            this.m_dataBrowse.setEnabled(enabled);
            this.m_logsLocation.setText("");
            this.m_logsLocation.setEnabled(enabled);
            this.m_logsBrowse.setEnabled(enabled);
            this.m_statisticsLocation.setText("");
            this.m_statisticsLocation.setEnabled(enabled);
            this.m_statisticsBrowse.setEnabled(enabled);
        }

        private Layout(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            this.m_serverGroup = new Group(parent, 32);
            this.m_serverGroup.setText(SERVER);
            this.m_serverGroup.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout(2, true));
            this.m_serverGroup.setLayoutData((Object)new GridData(1808));
            Composite fieldGroup = new Composite((Composite)this.m_serverGroup, 0);
            gridLayout = new GridLayout(5, false);
            fieldGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            fieldGroup.setLayoutData((Object)new GridData(4, 1, true, true));
            Label nameLabel = new Label(fieldGroup, 0);
            nameLabel.setText(NAME);
            this.m_nameField = new Text(fieldGroup, 2048);
            GridData gridData = new GridData(768);
            gridData.minimumWidth = SWTUtil.textColumnsToPixels((Control)this.m_nameField, 10);
            this.m_nameField.setLayoutData((Object)gridData);
            ServerPanel.this.initStringField(this.m_nameField, Server.class, "name");
            new Label(fieldGroup, 0);
            Label dsoPortLabel = new Label(fieldGroup, 0);
            dsoPortLabel.setText(DSO_PORT);
            this.m_dsoPortField = new Text(fieldGroup, 2048);
            SWTUtil.makeIntField(this.m_dsoPortField);
            gridData = new GridData(512);
            gridData.minimumWidth = SWTUtil.textColumnsToPixels((Control)this.m_dsoPortField, 6);
            this.m_dsoPortField.setLayoutData((Object)gridData);
            ServerPanel.this.initIntegerField(this.m_dsoPortField, Server.class, "dso-port");
            Label hostLabel = new Label(fieldGroup, 0);
            hostLabel.setText(HOST);
            this.m_hostField = new Text(fieldGroup, 2048);
            this.m_hostField.setLayoutData((Object)new GridData(768));
            ServerPanel.this.initStringField(this.m_hostField, Server.class, "host");
            new Label(fieldGroup, 0);
            Label jmxPortLabel = new Label(fieldGroup, 0);
            jmxPortLabel.setText(JMX_PORT);
            this.m_jmxPortField = new Text(fieldGroup, 2048);
            SWTUtil.makeIntField(this.m_jmxPortField);
            gridData = new GridData(512);
            gridData.minimumWidth = SWTUtil.textColumnsToPixels((Control)this.m_jmxPortField, 6);
            this.m_jmxPortField.setLayoutData((Object)gridData);
            ServerPanel.this.initIntegerField(this.m_jmxPortField, Server.class, "jmx-port");
            Label dataLabel = new Label(fieldGroup, 0);
            dataLabel.setText(DATA);
            Composite dataPanel = new Composite(fieldGroup, 0);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            dataPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            dataPanel.setLayoutData((Object)gridData);
            this.m_dataLocation = new Text(dataPanel, 2048);
            gridData = new GridData(768);
            this.m_dataLocation.setLayoutData((Object)gridData);
            ServerPanel.this.initStringField(this.m_dataLocation, Server.class, "data");
            this.m_dataBrowse = new Button(dataPanel, 8);
            this.m_dataBrowse.setText(BROWSE);
            SWTUtil.applyDefaultButtonSize(this.m_dataBrowse);
            Label logsLabel = new Label(fieldGroup, 0);
            logsLabel.setText(LOGS);
            Composite logsPanel = new Composite(fieldGroup, 0);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            logsPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            logsPanel.setLayoutData((Object)gridData);
            this.m_logsLocation = new Text(logsPanel, 2048);
            this.m_logsLocation.setLayoutData((Object)new GridData(768));
            ServerPanel.this.initStringField(this.m_logsLocation, Server.class, "logs");
            this.m_logsBrowse = new Button(logsPanel, 8);
            this.m_logsBrowse.setText(BROWSE);
            SWTUtil.applyDefaultButtonSize(this.m_logsBrowse);
            Label statisticsLabel = new Label(fieldGroup, 0);
            statisticsLabel.setText(STATISTICS);
            Composite statisticsPanel = new Composite(fieldGroup, 0);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            statisticsPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            statisticsPanel.setLayoutData((Object)gridData);
            this.m_statisticsLocation = new Text(statisticsPanel, 2048);
            this.m_statisticsLocation.setLayoutData((Object)new GridData(768));
            ServerPanel.this.initStringField(this.m_statisticsLocation, Server.class, "statistics");
            this.m_statisticsBrowse = new Button(statisticsPanel, 8);
            this.m_statisticsBrowse.setText(BROWSE);
            SWTUtil.applyDefaultButtonSize(this.m_statisticsBrowse);
            this.m_dsoServerDataPanel = new DsoServerDataPanel((Composite)this.m_serverGroup, 0);
            this.m_dsoServerDataPanel.setLayoutData(new GridData(4, 1, true, true));
        }
    }
}

