/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoClientDebugging;
import com.terracottatech.config.RuntimeLogging;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class RuntimeLoggingPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoClientDebugging m_dsoClientDebugging;
    private RuntimeLogging m_runtimeLogging;
    private final Layout m_layout = new Layout(this);

    public RuntimeLoggingPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_runtimeLogging == null) {
            this.removeListeners();
            this.m_runtimeLogging = this.m_dsoClientDebugging.addNewRuntimeLogging();
            this.updateChildren();
            this.addListeners();
        }
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testRemoveRuntimeLogging();
    }

    public boolean hasAnySet() {
        return this.m_runtimeLogging != null && (this.m_runtimeLogging.isSetLockDebug() || this.m_runtimeLogging.isSetDistributedMethodDebug() || this.m_runtimeLogging.isSetFieldChangeDebug() || this.m_runtimeLogging.isSetWaitNotifyDebug() || this.m_runtimeLogging.isSetNewObjectDebug() || this.m_runtimeLogging.isSetNonPortableDump() || this.m_runtimeLogging.isSetNamedLoaderDebug());
    }

    private void testRemoveRuntimeLogging() {
        if (!this.hasAnySet() && this.m_dsoClientDebugging.getRuntimeLogging() != null) {
            this.m_dsoClientDebugging.unsetRuntimeLogging();
            this.m_runtimeLogging = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        }
        this.fireClientChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoClientDebugging);
    }

    private void addListeners() {
        ((XmlBooleanToggle)this.m_layout.m_lockDebugCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodDebugCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_fieldChangeDebugCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_nonPortableDumpCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_waitNotifyDebugCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_newObjectDebugCheck.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlBooleanToggle)this.m_layout.m_lockDebugCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodDebugCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_fieldChangeDebugCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_nonPortableDumpCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_waitNotifyDebugCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_newObjectDebugCheck.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setRuntimeLogging(this.m_runtimeLogging);
    }

    public void setup(DsoClientDebugging dsoClientDebugging) {
        this.removeListeners();
        this.setEnabled(true);
        this.m_dsoClientDebugging = dsoClientDebugging;
        this.m_runtimeLogging = this.m_dsoClientDebugging != null ? this.m_dsoClientDebugging.getRuntimeLogging() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoClientDebugging = null;
        this.m_runtimeLogging = null;
        ((XmlBooleanToggle)this.m_layout.m_lockDebugCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodDebugCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_fieldChangeDebugCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_nonPortableDumpCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_waitNotifyDebugCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_newObjectDebugCheck.getData()).tearDown();
        this.setEnabled(false);
    }

    private class Layout {
        private static final String RUNTIME_LOGGING = "Runtime Logging";
        private static final String LOCK_DEBUG = "Lock Debug";
        private static final String DISTRIBUTED_METHOD_DEBUG = "Distributed Method Debug";
        private static final String FIELD_CHANGE_DEBUG = "Field Change Debug";
        private static final String NON_PORTABLE_DUMP = "Non-portable Dump";
        private static final String WAIT_NOTIFY_DEBUG = "Wait Notify Debug";
        private static final String NEW_OBJECT_DEBUG = "New Object Debug";
        private static final String NAMED_LOADER_DEBUG = "Named Loader Debug";
        private final Button m_lockDebugCheck;
        private final Button m_distributedMethodDebugCheck;
        private final Button m_fieldChangeDebugCheck;
        private final Button m_nonPortableDumpCheck;
        private final Button m_waitNotifyDebugCheck;
        private final Button m_newObjectDebugCheck;
        private final Button m_namedLoaderDebugCheck;

        void setRuntimeLogging(RuntimeLogging runtimeLogging) {
            ((XmlBooleanToggle)this.m_lockDebugCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_distributedMethodDebugCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_fieldChangeDebugCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_nonPortableDumpCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_waitNotifyDebugCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_newObjectDebugCheck.getData()).setup((XmlObject)runtimeLogging);
            ((XmlBooleanToggle)this.m_namedLoaderDebugCheck.getData()).setup((XmlObject)runtimeLogging);
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Group runtimeLoggingGroup = new Group(parent, 32);
            runtimeLoggingGroup.setText(RUNTIME_LOGGING);
            GridLayout gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 3;
            runtimeLoggingGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(770);
            runtimeLoggingGroup.setLayoutData((Object)gridData);
            this.m_lockDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_lockDebugCheck.setText(LOCK_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_lockDebugCheck, RuntimeLogging.class, "lock-debug");
            this.m_distributedMethodDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_distributedMethodDebugCheck.setText(DISTRIBUTED_METHOD_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_distributedMethodDebugCheck, RuntimeLogging.class, "distributed-method-debug");
            this.m_fieldChangeDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_fieldChangeDebugCheck.setText(FIELD_CHANGE_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_fieldChangeDebugCheck, RuntimeLogging.class, "field-change-debug");
            this.m_nonPortableDumpCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_nonPortableDumpCheck.setText(NON_PORTABLE_DUMP);
            RuntimeLoggingPanel.this.initBooleanField(this.m_nonPortableDumpCheck, RuntimeLogging.class, "non-portable-dump");
            this.m_waitNotifyDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_waitNotifyDebugCheck.setText(WAIT_NOTIFY_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_waitNotifyDebugCheck, RuntimeLogging.class, "wait-notify-debug");
            this.m_newObjectDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_newObjectDebugCheck.setText(NEW_OBJECT_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_newObjectDebugCheck, RuntimeLogging.class, "new-object-debug");
            this.m_namedLoaderDebugCheck = new Button((Composite)runtimeLoggingGroup, 32);
            this.m_namedLoaderDebugCheck.setText(NAMED_LOADER_DEBUG);
            RuntimeLoggingPanel.this.initBooleanField(this.m_namedLoaderDebugCheck, RuntimeLogging.class, "named-loader-debug");
        }
    }
}

