/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Root;
import com.terracottatech.config.Roots;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.chooser.ExpressionChooser;
import org.terracotta.dso.editors.chooser.FieldBehavior;
import org.terracotta.ui.util.SWTUtil;

public class RootsPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private Roots m_roots;
    private final Layout m_layout = new Layout(this);
    private final AddRootHandler m_addRootHandler = new AddRootHandler();
    private final RemoveRootHandler m_removeRootHandler = new RemoveRootHandler();
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();
    private static final int FIELD_COLUMN = 0;
    private static final int NAME_COLUMN = 1;

    public RootsPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_roots != null && this.m_roots.sizeOfRootArray() > 0;
    }

    private Roots ensureRoots() {
        if (this.m_roots == null) {
            this.ensureXmlObject();
        }
        return this.m_roots;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_roots == null) {
            this.removeListeners();
            this.m_roots = this.m_dsoApp.addNewRoots();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void syncModel() {
        if (!this.hasAnySet() && this.m_dsoApp.getRoots() != null) {
            this.m_dsoApp.unsetRoots();
            this.m_roots = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.fireRootsChanged();
        this.testDisableRemoveButton();
    }

    private void testDisableRemoveButton() {
        this.m_layout.m_removeButton.setEnabled(this.m_layout.m_table.getSelectionCount() > 0);
    }

    private void addListeners() {
        this.m_layout.m_addButton.addSelectionListener((SelectionListener)this.m_addRootHandler);
        this.m_layout.m_removeButton.addSelectionListener((SelectionListener)this.m_removeRootHandler);
        this.m_layout.m_table.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.addListener(36, (Listener)this.m_tableDataListener);
    }

    private void removeListeners() {
        this.m_layout.m_addButton.removeSelectionListener((SelectionListener)this.m_addRootHandler);
        this.m_layout.m_removeButton.removeSelectionListener((SelectionListener)this.m_removeRootHandler);
        this.m_layout.m_table.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.removeListener(36, (Listener)this.m_tableDataListener);
    }

    public void updateChildren() {
        this.initTableItems();
        this.testDisableRemoveButton();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_roots = this.m_dsoApp != null ? this.m_dsoApp.getRoots() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.clearTableItems();
        this.m_project = null;
        this.m_dsoApp = null;
        this.m_roots = null;
        this.setEnabled(false);
    }

    private void clearTableItems() {
        this.m_layout.m_table.removeAll();
    }

    private void initTableItems() {
        this.clearTableItems();
        if (this.m_roots == null) {
            return;
        }
        Root[] roots = this.m_roots.getRootArray();
        for (int i = 0; i < roots.length; ++i) {
            this.createTableItem(roots[i]);
        }
        if (roots.length > 0) {
            this.m_layout.m_table.setSelection(0);
        }
    }

    private void initTableItem(TableItem item, Root root) {
        String fieldNameOrExpression = root.isSetFieldName() ? root.getFieldName() : root.getFieldExpression();
        item.setText(new String[]{fieldNameOrExpression, root.getRootName()});
    }

    private void updateTableItem(int index) {
        TableItem item = this.m_layout.m_table.getItem(index);
        this.initTableItem(item, (Root)item.getData());
    }

    private void createTableItem(Root root) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        this.initTableItem(item, root);
        item.setData((Object)root);
    }

    private void internalSetRoot(Root root, String fieldNameOrExpression) {
        fieldNameOrExpression = fieldNameOrExpression.trim();
        String sansWhitespace = StringUtils.deleteWhitespace((String)fieldNameOrExpression);
        if (fieldNameOrExpression.length() != sansWhitespace.length()) {
            root.setFieldExpression(fieldNameOrExpression);
            if (root.isSetFieldName()) {
                root.unsetFieldName();
            }
        } else {
            root.setFieldName(fieldNameOrExpression);
            if (root.isSetFieldExpression()) {
                root.unsetFieldExpression();
            }
        }
    }

    private void internalAddRoot(String fieldNameOrExpression) {
        Root root = this.ensureRoots().addNewRoot();
        this.internalSetRoot(root, fieldNameOrExpression);
        this.createTableItem(root);
        int row = this.m_layout.m_table.getItemCount() - 1;
        this.m_layout.m_table.setSelection(row);
    }

    public void rootChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            this.updateTableItem(index);
        }
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            String fieldNameOrExpression = item.getText(e.index);
            Root root = (Root)item.getData();
            if (e.index == 0) {
                if (fieldNameOrExpression.length() == 0) {
                    int index = RootsPanel.this.m_layout.m_table.indexOf(item);
                    RootsPanel.this.ensureRoots().removeRoot(index);
                    RootsPanel.this.m_layout.m_table.remove(index);
                    RootsPanel.this.syncModel();
                    return;
                }
                RootsPanel.this.internalSetRoot(root, fieldNameOrExpression);
            } else if (e.index == 1) {
                root.setRootName(fieldNameOrExpression);
            }
            RootsPanel.this.fireRootChanged(RootsPanel.this.m_layout.m_table.indexOf(item));
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RootsPanel.this.m_layout.m_removeButton.setEnabled(true);
        }
    }

    class RemoveRootHandler
    extends SelectionAdapter {
        RemoveRootHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            RootsPanel.this.m_layout.m_table.forceFocus();
            int[] selection = RootsPanel.this.m_layout.m_table.getSelectionIndices();
            for (int i = selection.length - 1; i >= 0; --i) {
                RootsPanel.this.ensureRoots().removeRoot(selection[i]);
            }
            RootsPanel.this.m_layout.m_table.remove(selection);
            RootsPanel.this.syncModel();
        }
    }

    class AddRootHandler
    extends SelectionAdapter {
        AddRootHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            RootsPanel.this.m_layout.m_table.forceFocus();
            FieldBehavior behavior = new FieldBehavior();
            ExpressionChooser chooser = new ExpressionChooser(RootsPanel.this.getShell(), behavior.getTitle(), "Enter Fully Qualified Field Name", RootsPanel.this.m_project, behavior);
            chooser.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent updateEvent) {
                    String[] items = (String[])updateEvent.data;
                    for (int i = 0; i < items.length; ++i) {
                        RootsPanel.this.internalAddRoot(items[i]);
                    }
                    RootsPanel.this.fireRootsChanged();
                }
            });
            chooser.open();
        }
    }

    private static class Layout {
        private static final String ROOTS = "Roots";
        private static final String FIELD = "Field/Expression";
        private static final String NAME = "Name";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private final Table m_table;
        private final Button m_addButton;
        private final Button m_removeButton;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(ROOTS);
            label.setLayoutData((Object)new GridData(2));
            this.m_table = new Table(sidePanel, 68098);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_table, new int[]{2, 1});
            SWTUtil.makeTableColumnsEditable(this.m_table, new int[]{0, 1});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_table, 3);
            this.m_table.setLayoutData((Object)gridData);
            TableColumn fieldCol = new TableColumn(this.m_table, 0);
            fieldCol.setResizable(true);
            fieldCol.setText(FIELD);
            fieldCol.pack();
            TableColumn nameCol = new TableColumn(this.m_table, 0);
            nameCol.setResizable(true);
            nameCol.setText(NAME);
            nameCol.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addButton = new Button(buttonPanel, 8);
            this.m_addButton.setText(ADD);
            this.m_addButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addButton);
            this.m_removeButton = new Button(buttonPanel, 8);
            this.m_removeButton.setText(REMOVE);
            this.m_removeButton.setEnabled(false);
            this.m_removeButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeButton);
        }
    }
}

