/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoServerData;
import com.terracottatech.config.Persistence;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.dso.editors.xmlbeans.XmlStringEnumCombo;
import org.terracotta.ui.util.SWTLayout;
import org.terracotta.ui.util.SWTUtil;

public class PersistencePanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoServerData m_dsoServerData;
    private Persistence m_persistence;
    private Layout m_layout = new Layout(this);

    public PersistencePanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_persistence == null) {
            this.removeListeners();
            this.m_persistence = this.m_dsoServerData.addNewPersistence();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_persistence != null && this.m_persistence.isSetMode();
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.syncModel();
    }

    private void syncModel() {
        if (!this.hasAnySet() && this.m_dsoServerData.getPersistence() != null) {
            this.m_dsoServerData.unsetPersistence();
            this.m_persistence = null;
        }
        this.fireXmlObjectStructureChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoServerData);
    }

    private void addListeners() {
        ((XmlStringEnumCombo)this.m_layout.m_persistenceModeCombo.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlStringEnumCombo)this.m_layout.m_persistenceModeCombo.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setPersistence(this.m_persistence);
    }

    public void setup(DsoServerData dsoServerData) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_dsoServerData = dsoServerData;
        this.m_persistence = this.m_dsoServerData != null ? this.m_dsoServerData.getPersistence() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoServerData = null;
        this.m_persistence = null;
        ((XmlStringEnumCombo)this.m_layout.m_persistenceModeCombo.getData()).tearDown();
        this.setEnabled(false);
    }

    private class Layout
    implements SWTLayout {
        private static final String PERSISTENCE_MODE = "Mode";
        private Combo m_persistenceModeCombo;

        public void reset() {
            this.resetServerFields(false);
        }

        private void setPersistence(Persistence persistence) {
            ((XmlStringEnumCombo)this.m_persistenceModeCombo.getData()).setup((XmlObject)persistence);
        }

        private void resetServerFields(boolean enabled) {
            this.m_persistenceModeCombo.deselectAll();
            this.m_persistenceModeCombo.setEnabled(enabled);
        }

        private Layout(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Group panel = new Group(parent, 0);
            panel.setText("Persistence");
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            panel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            panel.setLayoutData((Object)gridData);
            Label persistenceModeLabel = new Label((Composite)panel, 0);
            persistenceModeLabel.setText(PERSISTENCE_MODE);
            this.m_persistenceModeCombo = new Combo((Composite)panel, 2056);
            gridData = new GridData(512);
            this.m_persistenceModeCombo.setLayoutData((Object)gridData);
            PersistencePanel.this.initStringEnumCombo(this.m_persistenceModeCombo, Persistence.class, "mode");
        }
    }
}

