/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.Client;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import java.net.URL;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleException;
import org.terracotta.dso.ModuleInfo;
import org.terracotta.dso.ModulesConfiguration;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.dialogs.NewAddModuleDialog;
import org.terracotta.dso.dialogs.RepoLocationDialog;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class ModulesPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private Client m_dsoClient;
    private Modules m_modules;
    private final Layout m_layout = new Layout(this);
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();
    private final MouseMoveListener m_moduleMouseMoveListener = new ModuleMouseMoveListener();
    private final AddModuleHandler m_addModuleHandler = new AddModuleHandler();
    private final RemoveModuleHandler m_removeModuleHandler = new RemoveModuleHandler();
    private final AddRepoHandler m_addRepoHandler = new AddRepoHandler();
    private final RemoveRepoHandler m_removeRepoHandler = new RemoveRepoHandler();
    private static final String MODULE_DECLARATION = "Module Declaration";
    private static final String MODULE_REPO_LOCATION = "Repository Location";
    private static final String REPO_DECLARATION = "Repository Declaration";
    private static final int MODULE_NAME_INDEX = 0;
    private static final int MODULE_GROUP_ID_INDEX = 0;

    public ModulesPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    private Modules ensureModules() {
        if (this.m_modules == null) {
            this.ensureXmlObject();
        }
        return this.m_modules;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_modules == null) {
            this.removeListeners();
            this.m_modules = this.m_dsoClient.addNewModules();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void updateChildren() {
        this.initModuleRepositories();
        this.initModules();
    }

    public void setup(Client dsoClient) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_dsoClient = dsoClient;
        this.m_modules = this.m_dsoClient != null ? this.m_dsoClient.getModules() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoClient = null;
        this.setEnabled(false);
    }

    private void addListeners() {
        this.m_layout.m_moduleRepoTable.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_moduleRepoTable.addListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_moduleTable.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_moduleTable.addListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_moduleTable.addMouseMoveListener(this.m_moduleMouseMoveListener);
        this.m_layout.m_addModule.addSelectionListener((SelectionListener)this.m_addModuleHandler);
        this.m_layout.m_removeModule.addSelectionListener((SelectionListener)this.m_removeModuleHandler);
        this.m_layout.m_addModuleRepo.addSelectionListener((SelectionListener)this.m_addRepoHandler);
        this.m_layout.m_removeModuleRepo.addSelectionListener((SelectionListener)this.m_removeRepoHandler);
    }

    private void removeListeners() {
        this.m_layout.m_moduleRepoTable.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_moduleRepoTable.removeListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_moduleTable.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_moduleTable.removeListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_moduleTable.removeMouseMoveListener(this.m_moduleMouseMoveListener);
        this.m_layout.m_addModule.removeSelectionListener((SelectionListener)this.m_addModuleHandler);
        this.m_layout.m_removeModule.removeSelectionListener((SelectionListener)this.m_removeModuleHandler);
        this.m_layout.m_addModuleRepo.removeSelectionListener((SelectionListener)this.m_addRepoHandler);
        this.m_layout.m_removeModuleRepo.removeSelectionListener((SelectionListener)this.m_removeRepoHandler);
    }

    private void testRemoveModules() {
        if (!this.hasAnySet() && this.m_dsoClient.getModules() != null) {
            this.m_dsoClient.unsetModules();
            this.m_modules = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        }
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoClient);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testRemoveModules();
    }

    public boolean hasAnySet() {
        return this.m_modules != null && (this.m_modules.sizeOfRepositoryArray() > 0 || this.m_modules.sizeOfModuleArray() > 0);
    }

    private void createModuleTableItem(Module module) {
        TableItem item = new TableItem(this.m_layout.m_moduleTable, 0);
        String groupId = module.isSetGroupId() ? module.getGroupId() : "org.terracotta.modules";
        item.setText(new String[]{module.getName(), groupId, module.getVersion()});
        item.setData((Object)module);
    }

    private void initModules() {
        Module[] modules;
        this.m_layout.m_moduleTable.removeAll();
        if (this.m_modules == null) {
            return;
        }
        for (Module module : modules = this.m_modules.getModuleArray()) {
            this.createModuleTableItem(module);
        }
        if (modules.length > 0) {
            this.m_layout.m_moduleTable.setSelection(0);
        }
    }

    private void internalAddModuleRepo(String location) {
        this.ensureModules().addRepository(location);
        this.createModuleRepoTableItem(location);
    }

    private void createModuleRepoTableItem(String repo) {
        TableItem item = new TableItem(this.m_layout.m_moduleRepoTable, 0);
        item.setText(repo);
    }

    private void initModuleRepositories() {
        String[] repos;
        this.m_layout.m_moduleRepoTable.removeAll();
        if (this.m_modules == null) {
            return;
        }
        for (String repo : repos = this.m_modules.getRepositoryArray()) {
            this.createModuleRepoTableItem(repo);
        }
        if (repos.length > 0) {
            this.m_layout.m_moduleRepoTable.setSelection(0);
        }
    }

    private void testEnableRemove() {
        this.m_layout.m_removeModuleRepo.setEnabled(this.m_layout.m_moduleRepoTable.getSelectionCount() > 0);
        this.m_layout.m_removeModule.setEnabled(this.m_layout.m_moduleTable.getSelectionCount() > 0);
    }

    class RemoveRepoHandler
    extends SelectionAdapter {
        RemoveRepoHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ModulesPanel.this.m_layout.m_moduleRepoTable.forceFocus();
            int[] selection = ModulesPanel.this.m_layout.m_moduleRepoTable.getSelectionIndices();
            Modules modules = ModulesPanel.this.ensureModules();
            for (int i = selection.length - 1; i >= 0; --i) {
                modules.removeRepository(selection[i]);
            }
            ModulesPanel.this.m_layout.m_moduleRepoTable.remove(selection);
            ModulesPanel.this.testEnableRemove();
            ModulesPanel.this.testRemoveModules();
            ModulesPanel.this.fireModuleReposChanged();
        }
    }

    class AddRepoHandler
    extends SelectionAdapter {
        AddRepoHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ModulesPanel.this.m_layout.m_moduleRepoTable.forceFocus();
            RepoLocationDialog dialog = new RepoLocationDialog(ModulesPanel.this.getShell(), ModulesPanel.REPO_DECLARATION, ModulesPanel.MODULE_REPO_LOCATION);
            dialog.addValueListener(new RepoLocationDialog.ValueListener(){

                public void setValues(String repoLocation) {
                    if (repoLocation != null && !(repoLocation = repoLocation.trim()).equals("")) {
                        ModulesPanel.this.internalAddModuleRepo(repoLocation);
                        ModulesPanel.this.testRemoveModules();
                        ModulesPanel.this.fireModuleReposChanged();
                    }
                }
            });
            dialog.open();
        }
    }

    class RemoveModuleHandler
    extends SelectionAdapter {
        RemoveModuleHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ModulesPanel.this.m_layout.m_moduleTable.forceFocus();
            int[] selection = ModulesPanel.this.m_layout.m_moduleTable.getSelectionIndices();
            Modules modules = ModulesPanel.this.ensureModules();
            for (int i = selection.length - 1; i >= 0; --i) {
                modules.removeModule(selection[i]);
            }
            ModulesPanel.this.m_layout.m_moduleTable.remove(selection);
            ModulesPanel.this.testEnableRemove();
            ModulesPanel.this.testRemoveModules();
            ModulesPanel.this.fireModulesChanged();
        }
    }

    class AddModuleHandler
    extends SelectionAdapter {
        AddModuleHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            ModulesPanel.this.m_layout.m_moduleTable.forceFocus();
            NewAddModuleDialog dialog = new NewAddModuleDialog(ModulesPanel.this.getShell(), ModulesPanel.MODULE_DECLARATION, ModulesPanel.MODULE_DECLARATION, ModulesPanel.this.m_modules);
            dialog.addValueListener(new NewAddModuleDialog.ValueListener(){

                public void setValue(Modules modules) {
                    ModulesPanel.this.m_dsoClient.setModules(modules);
                    ModulesPanel.this.fireModulesChanged();
                    ModulesPanel.this.fireModuleReposChanged();
                }
            });
            dialog.open();
        }
    }

    class ModuleMouseMoveListener
    implements MouseMoveListener {
        ModuleMouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            IWorkbenchWindow window;
            String tip = null;
            TableItem item = ModulesPanel.this.m_layout.m_moduleTable.getItem(new Point(e.x, e.y));
            if (item != null) {
                ModuleInfo moduleInfo;
                Module module = (Module)item.getData();
                TcPlugin plugin = TcPlugin.getDefault();
                ModulesConfiguration modulesConfig = plugin.getModulesConfiguration(ModulesPanel.this.getProject());
                if (modulesConfig != null && (moduleInfo = modulesConfig.getModuleInfo(module)) != null) {
                    BundleException error = moduleInfo.getError();
                    if (error != null) {
                        tip = error.getMessage();
                    } else {
                        URL loc = moduleInfo.getLocation();
                        if (loc != null) {
                            tip = loc.toExternalForm();
                        }
                    }
                }
            }
            if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) instanceof ApplicationWindow) {
                ((ApplicationWindow)window).setStatus(tip);
            }
        }
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event event) {
            TableItem item = (TableItem)event.item;
            String text = item.getText(event.index);
            Table table = (Table)event.widget;
            int index = table.getSelectionIndex();
            if (event.widget == ModulesPanel.this.m_layout.m_moduleRepoTable) {
                ModulesPanel.this.m_modules.setRepositoryArray(index, text);
                ModulesPanel.this.fireModuleRepoChanged(index);
            } else {
                Module module = (Module)item.getData();
                if (event.index == 0) {
                    module.setName(text);
                } else if (event.index == 0) {
                    module.setGroupId(text);
                } else {
                    module.setVersion(text);
                }
                ModulesPanel.this.fireModuleChanged(index);
            }
            table.setSelection(index);
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = (Table)e.widget;
            boolean removeEnabled = table.getItemCount() > 0;
            Button button = table == ModulesPanel.this.m_layout.m_moduleRepoTable ? ModulesPanel.this.m_layout.m_removeModuleRepo : ModulesPanel.this.m_layout.m_removeModule;
            button.setEnabled(removeEnabled);
        }
    }

    private static class Layout {
        private static final String MODULE_REPOSITORIES = "Module Repositories";
        private static final String MODULES = "Modules";
        private static final String LOCATION = "Location";
        private static final String NAME = "Name";
        private static final String GROUP_ID = "Group Identifier";
        private static final String VERSION = "Version";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private Table m_moduleRepoTable;
        private Button m_addModuleRepo;
        private Button m_removeModuleRepo;
        private Table m_moduleTable;
        private Button m_addModule;
        private Button m_removeModule;

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            this.createModuleRepositoriesPanel(parent);
            this.createModulesPanel(parent);
        }

        private void createModuleRepositoriesPanel(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            comp.setLayoutData((Object)gridData);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(MODULE_REPOSITORIES);
            label.setLayoutData((Object)new GridData(2));
            this.m_moduleRepoTable = new Table(sidePanel, 68098);
            this.m_moduleRepoTable.setHeaderVisible(true);
            this.m_moduleRepoTable.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeEqualWidth(sidePanel, this.m_moduleRepoTable);
            SWTUtil.makeTableColumnsEditable(this.m_moduleRepoTable, new int[]{0});
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_moduleRepoTable, 0);
            this.m_moduleRepoTable.setLayoutData((Object)gridData);
            TableColumn column0 = new TableColumn(this.m_moduleRepoTable, 0);
            column0.setResizable(true);
            column0.setText(LOCATION);
            column0.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addModuleRepo = new Button(buttonPanel, 8);
            this.m_addModuleRepo.setText(ADD);
            this.m_addModuleRepo.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addModuleRepo);
            this.m_removeModuleRepo = new Button(buttonPanel, 8);
            this.m_removeModuleRepo.setText(REMOVE);
            this.m_removeModuleRepo.setEnabled(false);
            this.m_removeModuleRepo.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeModuleRepo);
        }

        private void createModulesPanel(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            comp.setLayoutData((Object)gridData);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(MODULES);
            label.setLayoutData((Object)new GridData(2));
            this.m_moduleTable = new Table(sidePanel, 68098);
            this.m_moduleTable.setHeaderVisible(true);
            this.m_moduleTable.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeEqualWidth(sidePanel, this.m_moduleTable);
            SWTUtil.makeTableColumnsEditable(this.m_moduleTable, new int[]{0, 1, 2});
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_moduleTable, 0);
            this.m_moduleTable.setLayoutData((Object)gridData);
            TableColumn column0 = new TableColumn(this.m_moduleTable, 0);
            column0.setResizable(true);
            column0.setText(NAME);
            column0.pack();
            TableColumn column1 = new TableColumn(this.m_moduleTable, 0);
            column1.setResizable(true);
            column1.setText(GROUP_ID);
            column1.pack();
            TableColumn column2 = new TableColumn(this.m_moduleTable, 0);
            column2.setResizable(true);
            column2.setText(VERSION);
            column2.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addModule = new Button(buttonPanel, 8);
            this.m_addModule.setText(ADD);
            this.m_addModule.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addModule);
            this.m_removeModule = new Button(buttonPanel, 8);
            this.m_removeModule.setText(REMOVE);
            this.m_removeModule.setEnabled(false);
            this.m_removeModule.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeModule);
        }
    }
}

