/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.LockLevel;
import com.terracottatech.config.Locks;
import com.terracottatech.config.NamedLock;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.chooser.ExpressionChooser;
import org.terracotta.dso.editors.chooser.MethodBehavior;
import org.terracotta.ui.util.SWTUtil;

public class LocksPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private Locks m_locks;
    private final Layout m_layout = new Layout(this);
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();
    private final AddLockHandler m_addLockHandler = new AddLockHandler();
    private final RemoveLockHandler m_removeLockHandler = new RemoveLockHandler();

    public LocksPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_locks != null && (this.m_locks.sizeOfAutolockArray() > 0 || this.m_locks.sizeOfNamedLockArray() > 0);
    }

    private Locks ensureLocks() {
        if (this.m_locks == null) {
            this.ensureXmlObject();
        }
        return this.m_locks;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_locks == null) {
            this.removeListeners();
            this.m_locks = this.m_dsoApp.addNewLocks();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testRemoveLocks() {
        if (!this.hasAnySet() && this.m_dsoApp.getLocks() != null) {
            this.m_dsoApp.unsetLocks();
            this.m_locks = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.testDisableRemoveButtons();
    }

    private void testDisableRemoveButtons() {
        this.m_layout.m_removeAutoLockButton.setEnabled(this.m_layout.m_autoLocksTable.getSelectionCount() > 0);
        this.m_layout.m_removeNamedLockButton.setEnabled(this.m_layout.m_namedLocksTable.getSelectionCount() > 0);
    }

    private void addListeners() {
        this.m_layout.m_addAutoLockButton.addSelectionListener((SelectionListener)this.m_addLockHandler);
        this.m_layout.m_removeAutoLockButton.addSelectionListener((SelectionListener)this.m_removeLockHandler);
        this.m_layout.m_autoLocksTable.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_autoLocksTable.addListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_addNamedLockButton.addSelectionListener((SelectionListener)this.m_addLockHandler);
        this.m_layout.m_removeNamedLockButton.addSelectionListener((SelectionListener)this.m_removeLockHandler);
        this.m_layout.m_namedLocksTable.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_namedLocksTable.addListener(36, (Listener)this.m_tableDataListener);
    }

    private void removeListeners() {
        this.m_layout.m_addAutoLockButton.removeSelectionListener((SelectionListener)this.m_addLockHandler);
        this.m_layout.m_removeAutoLockButton.removeSelectionListener((SelectionListener)this.m_removeLockHandler);
        this.m_layout.m_autoLocksTable.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_autoLocksTable.removeListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_addNamedLockButton.removeSelectionListener((SelectionListener)this.m_addLockHandler);
        this.m_layout.m_removeNamedLockButton.removeSelectionListener((SelectionListener)this.m_removeLockHandler);
        this.m_layout.m_namedLocksTable.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_namedLocksTable.removeListener(36, (Listener)this.m_tableDataListener);
    }

    public void updateChildren() {
        this.initTableItems();
        this.testDisableRemoveButtons();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_locks = this.m_dsoApp != null ? this.m_dsoApp.getLocks() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_project = null;
        this.m_dsoApp = null;
        this.m_locks = null;
        this.setEnabled(false);
    }

    private void initTableItems() {
        this.initAutolockTableItems();
        this.initNamedLockTableItems();
    }

    private void initAutolockTableItems() {
        this.m_layout.m_autoLocksTable.removeAll();
        if (this.m_locks == null) {
            return;
        }
        String[] autolockLevels = LocksPanel.getListDefaults(Autolock.class, "lock-level");
        SWTUtil.makeTableComboItem(this.m_layout.m_autoLocksTable, 1, autolockLevels);
        SWTUtil.makeTableComboItem(this.m_layout.m_autoLocksTable, 2, new String[]{"true", "false"});
        Autolock[] autolocks = this.m_locks.getAutolockArray();
        for (int i = 0; i < autolocks.length; ++i) {
            this.createAutolockTableItem(autolocks[i]);
        }
        if (autolocks.length > 0) {
            this.m_layout.m_autoLocksTable.setSelection(0);
        }
    }

    private void initNamedLockTableItems() {
        this.m_layout.m_namedLocksTable.removeAll();
        if (this.m_locks == null) {
            return;
        }
        String[] namedLockLevels = LocksPanel.getListDefaults(NamedLock.class, "lock-level");
        SWTUtil.makeTableComboItem(this.m_layout.m_namedLocksTable, 2, namedLockLevels);
        NamedLock[] namedLocks = this.m_locks.getNamedLockArray();
        for (int i = 0; i < namedLocks.length; ++i) {
            this.createNamedLockTableItem(namedLocks[i]);
        }
        if (namedLocks.length > 0) {
            this.m_layout.m_namedLocksTable.setSelection(0);
        }
    }

    private void initAutolockTableItem(TableItem item, Autolock lock) {
        item.setText(0, lock.getMethodExpression());
        item.setText(1, lock.isSetLockLevel() ? lock.getLockLevel().toString() : "");
        item.setText(2, lock.isSetAutoSynchronized() ? Boolean.toString(lock.getAutoSynchronized()) : "false");
    }

    private void updateAutolockTableItem(int index) {
        TableItem item = this.m_layout.m_autoLocksTable.getItem(index);
        this.initAutolockTableItem(item, (Autolock)item.getData());
    }

    private void createAutolockTableItem(Autolock lock) {
        TableItem item = new TableItem(this.m_layout.m_autoLocksTable, 0);
        this.initAutolockTableItem(item, lock);
        item.setData((Object)lock);
    }

    private void initNamedLockTableItem(TableItem item, NamedLock lock) {
        item.setText(0, lock.getLockName());
        item.setText(1, lock.getMethodExpression());
        item.setText(2, lock.isSetLockLevel() ? lock.getLockLevel().toString() : "");
    }

    private void updateNamedLockTableItem(int index) {
        TableItem item = this.m_layout.m_namedLocksTable.getItem(index);
        this.initNamedLockTableItem(item, (NamedLock)item.getData());
    }

    private void createNamedLockTableItem(NamedLock lock) {
        TableItem item = new TableItem(this.m_layout.m_namedLocksTable, 0);
        this.initNamedLockTableItem(item, lock);
        item.setData((Object)lock);
    }

    private void internalAddAutolock(String expression) {
        this.internalAddAutolock(expression, LockLevel.WRITE);
    }

    private void internalAddAutolock(String expression, LockLevel.Enum level) {
        Locks locks = this.ensureLocks();
        Autolock lock = locks.addNewAutolock();
        lock.setMethodExpression(expression);
        lock.setLockLevel(level);
        this.createAutolockTableItem(lock);
        int row = this.m_layout.m_autoLocksTable.getItemCount() - 1;
        this.m_layout.m_autoLocksTable.select(row);
    }

    private void internalAddNamedLock(String expression) {
        this.internalAddNamedLock(expression, "NewLock", LockLevel.WRITE);
    }

    private void internalAddNamedLock(String expression, String name, LockLevel.Enum level) {
        Locks locks = this.ensureLocks();
        NamedLock lock = locks.addNewNamedLock();
        lock.setMethodExpression(expression);
        lock.setLockName(name);
        lock.setLockLevel(level);
        this.createNamedLockTableItem(lock);
        int row = this.m_layout.m_namedLocksTable.getItemCount() - 1;
        this.m_layout.m_namedLocksTable.select(row);
    }

    private void removeAutolockLater(final int index) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LocksPanel.this.m_locks.removeAutolock(index);
                LocksPanel.this.m_layout.m_autoLocksTable.remove(index);
                LocksPanel.this.fireAutolocksChanged();
                LocksPanel.this.testRemoveLocks();
            }
        });
    }

    private void removeNamedLockLater(final int index) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LocksPanel.this.m_locks.removeNamedLock(index);
                LocksPanel.this.m_layout.m_namedLocksTable.remove(index);
                LocksPanel.this.fireAutolocksChanged();
                LocksPanel.this.testRemoveLocks();
            }
        });
    }

    public void namedLockChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            this.updateNamedLockTableItem(index);
        }
    }

    public void autolockChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            this.updateAutolockTableItem(index);
        }
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            String text = item.getText(e.index).trim();
            int index = ((Table)e.widget).getSelectionIndex();
            if (e.widget == LocksPanel.this.m_layout.m_autoLocksTable) {
                Autolock lock = (Autolock)item.getData();
                if (e.index == 2) {
                    boolean autoSync = Boolean.parseBoolean(text);
                    if (autoSync) {
                        lock.setAutoSynchronized(true);
                    } else {
                        lock.unsetAutoSynchronized();
                    }
                } else if (e.index == 0) {
                    if (text.length() == 0) {
                        item.setText(lock.getMethodExpression());
                        LocksPanel.this.removeAutolockLater(index);
                        return;
                    }
                    lock.setMethodExpression(text);
                } else {
                    lock.xgetLockLevel().setStringValue(text);
                }
                LocksPanel.this.fireAutolockChanged(index);
            } else if (e.widget == LocksPanel.this.m_layout.m_namedLocksTable) {
                NamedLock lock = (NamedLock)item.getData();
                if (e.index == 0) {
                    if (text.length() == 0) {
                        item.setText(lock.getLockName());
                        LocksPanel.this.removeNamedLockLater(index);
                        return;
                    }
                    lock.setLockName(text);
                } else if (e.index == 1) {
                    if (text.length() == 0) {
                        item.setText(lock.getMethodExpression());
                        LocksPanel.this.removeNamedLockLater(index);
                        return;
                    }
                    lock.setMethodExpression(text);
                } else {
                    lock.xgetLockLevel().setStringValue(text);
                }
                LocksPanel.this.fireNamedLockChanged(index);
            }
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == LocksPanel.this.m_layout.m_autoLocksTable) {
                LocksPanel.this.m_layout.m_removeAutoLockButton.setEnabled(true);
            } else if (e.widget == LocksPanel.this.m_layout.m_namedLocksTable) {
                LocksPanel.this.m_layout.m_removeNamedLockButton.setEnabled(true);
            }
        }
    }

    class RemoveLockHandler
    extends SelectionAdapter {
        RemoveLockHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == LocksPanel.this.m_layout.m_removeAutoLockButton) {
                LocksPanel.this.m_layout.m_autoLocksTable.forceFocus();
                int[] selection = LocksPanel.this.m_layout.m_autoLocksTable.getSelectionIndices();
                for (int i = selection.length - 1; i >= 0; --i) {
                    LocksPanel.this.m_locks.removeAutolock(selection[i]);
                }
                LocksPanel.this.m_layout.m_autoLocksTable.remove(selection);
                LocksPanel.this.fireAutolocksChanged();
            } else if (e.widget == LocksPanel.this.m_layout.m_removeNamedLockButton) {
                LocksPanel.this.m_layout.m_namedLocksTable.forceFocus();
                int[] selection = LocksPanel.this.m_layout.m_namedLocksTable.getSelectionIndices();
                for (int i = selection.length - 1; i >= 0; --i) {
                    LocksPanel.this.m_locks.removeNamedLock(selection[i]);
                }
                LocksPanel.this.m_layout.m_namedLocksTable.remove(selection);
                LocksPanel.this.fireNamedLocksChanged();
            }
            LocksPanel.this.testRemoveLocks();
        }
    }

    class AddLockHandler
    extends SelectionAdapter {
        AddLockHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == LocksPanel.this.m_layout.m_addAutoLockButton) {
                LocksPanel.this.m_layout.m_autoLocksTable.forceFocus();
                MethodBehavior behavior = new MethodBehavior();
                ExpressionChooser chooser = new ExpressionChooser(LocksPanel.this.getShell(), behavior.getTitle(), "Enter Method Expression", LocksPanel.this.m_project, behavior);
                chooser.addValueListener(new UpdateEventListener(){

                    public void handleUpdate(UpdateEvent updateEvent) {
                        String[] items = (String[])updateEvent.data;
                        for (int i = 0; i < items.length; ++i) {
                            LocksPanel.this.internalAddAutolock(items[i]);
                        }
                        LocksPanel.this.fireAutolocksChanged();
                    }
                });
                chooser.open();
            } else if (e.widget == LocksPanel.this.m_layout.m_addNamedLockButton) {
                LocksPanel.this.m_layout.m_namedLocksTable.forceFocus();
                MethodBehavior behavior = new MethodBehavior();
                ExpressionChooser chooser = new ExpressionChooser(LocksPanel.this.getShell(), behavior.getTitle(), "Enter Method Expression", LocksPanel.this.m_project, behavior);
                chooser.addValueListener(new UpdateEventListener(){

                    public void handleUpdate(UpdateEvent updateEvent) {
                        String[] items = (String[])updateEvent.data;
                        for (int i = 0; i < items.length; ++i) {
                            LocksPanel.this.internalAddNamedLock(items[i]);
                        }
                        LocksPanel.this.fireNamedLocksChanged();
                    }
                });
                chooser.open();
            }
        }
    }

    private static class Layout {
        private static final String AUTO_LOCKS = "Auto Locks";
        private static final String NAMED_LOCKS = "Named Locks";
        private static final String LOCK_NAME = "Lock Name";
        private static final String METHOD_EXPRESSION = "Method Expression";
        private static final String LOCK_LEVEL = "Lock Level";
        private static final String AUTO_SYNCHRONIZED = "Auto Synchronized";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private static final int AUTO_METHOD_COLUMN = 0;
        private static final int AUTO_LOCK_COLUMN = 1;
        private static final int AUTO_SYNCHRONIZED_COLUMN = 2;
        private static final int NAMED_NAME_COLUMN = 0;
        private static final int NAMED_METHOD_COLUMN = 1;
        private static final int NAMED_LOCK_COLUMN = 2;
        private Table m_autoLocksTable;
        private Button m_addAutoLockButton;
        private Button m_removeAutoLockButton;
        private Table m_namedLocksTable;
        private Button m_addNamedLockButton;
        private Button m_removeNamedLockButton;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            this.createAutoLocksPanel(comp);
            this.createNamedLocksPanel(comp);
        }

        private void createAutoLocksPanel(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(1808));
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(AUTO_LOCKS);
            label.setLayoutData((Object)new GridData(2));
            this.m_autoLocksTable = new Table(sidePanel, 68098);
            this.m_autoLocksTable.setHeaderVisible(true);
            this.m_autoLocksTable.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_autoLocksTable, new int[]{3, 1, 1});
            SWTUtil.makeTableColumnsEditable(this.m_autoLocksTable, new int[]{0, 2});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_autoLocksTable, 3);
            this.m_autoLocksTable.setLayoutData((Object)gridData);
            TableColumn methodCol = new TableColumn(this.m_autoLocksTable, 0, 0);
            methodCol.setResizable(true);
            methodCol.setText(METHOD_EXPRESSION);
            methodCol.pack();
            TableColumn lockCol = new TableColumn(this.m_autoLocksTable, 0, 1);
            lockCol.setResizable(true);
            lockCol.setText(LOCK_LEVEL);
            lockCol.pack();
            TableColumn autoSyncCol = new TableColumn(this.m_autoLocksTable, 0, 2);
            autoSyncCol.setResizable(true);
            autoSyncCol.setText(AUTO_SYNCHRONIZED);
            autoSyncCol.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addAutoLockButton = new Button(buttonPanel, 8);
            this.m_addAutoLockButton.setText(ADD);
            this.m_addAutoLockButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addAutoLockButton);
            this.m_removeAutoLockButton = new Button(buttonPanel, 8);
            this.m_removeAutoLockButton.setText(REMOVE);
            this.m_removeAutoLockButton.setEnabled(false);
            this.m_removeAutoLockButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeAutoLockButton);
        }

        private void createNamedLocksPanel(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(1808));
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(NAMED_LOCKS);
            label.setLayoutData((Object)new GridData(2));
            this.m_namedLocksTable = new Table(sidePanel, 68098);
            this.m_namedLocksTable.setHeaderVisible(true);
            this.m_namedLocksTable.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_namedLocksTable, new int[]{1, 2, 1});
            SWTUtil.makeTableColumnsEditable(this.m_namedLocksTable, new int[]{0, 1});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_namedLocksTable, 3);
            this.m_namedLocksTable.setLayoutData((Object)gridData);
            TableColumn lockNameCol = new TableColumn(this.m_namedLocksTable, 0, 0);
            lockNameCol.setResizable(true);
            lockNameCol.setText(LOCK_NAME);
            lockNameCol.pack();
            TableColumn methodCol = new TableColumn(this.m_namedLocksTable, 0, 1);
            methodCol.setResizable(true);
            methodCol.setText(METHOD_EXPRESSION);
            methodCol.pack();
            TableColumn lockLevelCol = new TableColumn(this.m_namedLocksTable, 0, 2);
            lockLevelCol.setResizable(true);
            lockLevelCol.setText(LOCK_LEVEL);
            lockLevelCol.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addNamedLockButton = new Button(buttonPanel, 8);
            this.m_addNamedLockButton.setText(ADD);
            this.m_addNamedLockButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addNamedLockButton);
            this.m_removeNamedLockButton = new Button(buttonPanel, 8);
            this.m_removeNamedLockButton.setText(REMOVE);
            this.m_removeNamedLockButton.setEnabled(false);
            this.m_removeNamedLockButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeNamedLockButton);
        }
    }
}

