/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoServerData;
import com.terracottatech.config.GarbageCollection;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.DsoServerDataPanel;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerSpinner;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTLayout;
import org.terracotta.ui.util.SWTUtil;

public class GarbageCollectionPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoServerData m_dsoServerData;
    private GarbageCollection m_garbageCollection;
    private Layout m_layout = new Layout(this);

    public GarbageCollectionPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_garbageCollection == null) {
            this.removeListeners();
            this.m_garbageCollection = this.m_dsoServerData.addNewGarbageCollection();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_garbageCollection != null && (this.m_garbageCollection.isSetEnabled() || this.m_garbageCollection.isSetVerbose() || this.m_garbageCollection.isSetInterval());
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testUnsetGarbageCollection();
    }

    private void testUnsetGarbageCollection() {
        if (!this.hasAnySet() && this.m_dsoServerData.getGarbageCollection() != null) {
            this.m_dsoServerData.unsetGarbageCollection();
            this.m_garbageCollection = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        } else {
            this.fireServerChanged();
        }
    }

    void fireServerChanged() {
        DsoServerDataPanel panel = (DsoServerDataPanel)SWTUtil.getAncestorOfClass(DsoServerDataPanel.class, (Control)this);
        panel.fireServerChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoServerData);
    }

    private void addListeners() {
        ((XmlBooleanToggle)this.m_layout.m_gcCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlIntegerSpinner)this.m_layout.m_gcIntervalSpinner.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_verboseCheck.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlBooleanToggle)this.m_layout.m_gcCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlIntegerSpinner)this.m_layout.m_gcIntervalSpinner.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_verboseCheck.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setGarbageCollection(this.m_garbageCollection);
    }

    public void setup(DsoServerData dsoServerData) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_dsoServerData = dsoServerData;
        this.m_garbageCollection = this.m_dsoServerData != null ? this.m_dsoServerData.getGarbageCollection() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoServerData = null;
        this.m_garbageCollection = null;
        this.m_layout.tearDown();
        this.setEnabled(false);
    }

    private class Layout
    implements SWTLayout {
        private static final String GARBAGE_COLLECTION = "Garbage Collection";
        private static final String GC_ENABLED = "Enabled";
        private static final String VERBOSE = "Verbose";
        private static final String GC_INTERVAL = "GC Interval (seconds)";
        private Button m_gcCheck;
        private Spinner m_gcIntervalSpinner;
        private Button m_verboseCheck;

        public void reset() {
            this.setGarbageCollection(null);
        }

        private void setGarbageCollection(GarbageCollection gc) {
            ((XmlBooleanToggle)this.m_gcCheck.getData()).setup((XmlObject)gc);
            ((XmlIntegerSpinner)this.m_gcIntervalSpinner.getData()).setup((XmlObject)gc);
            ((XmlBooleanToggle)this.m_verboseCheck.getData()).setup((XmlObject)gc);
        }

        void tearDown() {
            ((XmlBooleanToggle)this.m_gcCheck.getData()).tearDown();
            ((XmlIntegerSpinner)this.m_gcIntervalSpinner.getData()).tearDown();
            ((XmlBooleanToggle)this.m_verboseCheck.getData()).tearDown();
        }

        private Layout(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Group panel = new Group(parent, 0);
            panel.setText(GARBAGE_COLLECTION);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            panel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            panel.setLayoutData((Object)gridData);
            this.m_gcCheck = new Button((Composite)panel, 32);
            this.m_gcCheck.setText(GC_ENABLED);
            GarbageCollectionPanel.this.initBooleanField(this.m_gcCheck, GarbageCollection.class, "enabled");
            Composite intervalPanel = new Composite((Composite)panel, 0);
            gridLayout = new GridLayout(2, false);
            intervalPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Label gcIntervalLabel = new Label(intervalPanel, 0);
            gcIntervalLabel.setText(GC_INTERVAL);
            this.m_gcIntervalSpinner = new Spinner(intervalPanel, 2048);
            gridData = new GridData();
            this.m_gcIntervalSpinner.setLayoutData((Object)gridData);
            GarbageCollectionPanel.this.initIntegerSpinnerField(this.m_gcIntervalSpinner, GarbageCollection.class, "interval");
            this.m_verboseCheck = new Button((Composite)panel, 32);
            this.m_verboseCheck.setText(VERBOSE);
            GarbageCollectionPanel.this.initBooleanField(this.m_verboseCheck, GarbageCollection.class, "verbose");
        }
    }
}

