/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoClientData;
import com.terracottatech.config.DsoClientDebugging;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.InstrumentationLoggingPanel;
import org.terracotta.dso.editors.RuntimeLoggingPanel;
import org.terracotta.dso.editors.RuntimeOutputOptionsPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class DsoClientDebuggingPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoClientData m_dsoClientData;
    private DsoClientDebugging m_dsoClientDebugging;
    private Layout m_layout = new Layout(this);

    public DsoClientDebuggingPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_dsoClientDebugging == null) {
            this.removeListeners();
            this.m_dsoClientDebugging = this.m_dsoClientData.addNewDebugging();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_dsoClientDebugging != null && (this.m_dsoClientDebugging.isSetInstrumentationLogging() || this.m_dsoClientDebugging.isSetRuntimeLogging() || this.m_dsoClientDebugging.isSetRuntimeOutputOptions());
    }

    private void addListeners() {
        this.m_layout.m_instrumentationLoggingPanel.addXmlObjectStructureListener(this);
        this.m_layout.m_runtimeLoggingPanel.addXmlObjectStructureListener(this);
        this.m_layout.m_runtimeOutputOptionsPanel.addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        this.m_layout.m_instrumentationLoggingPanel.removeXmlObjectStructureListener(this);
        this.m_layout.m_runtimeLoggingPanel.removeXmlObjectStructureListener(this);
        this.m_layout.m_runtimeOutputOptionsPanel.removeXmlObjectStructureListener(this);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        if (!this.hasAnySet() && this.m_dsoClientData.getDebugging() != null) {
            this.m_dsoClientData.unsetDebugging();
            this.m_dsoClientDebugging = null;
            this.fireXmlObjectStructureChanged();
        }
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoClientData);
    }

    private void updateChildren() {
        this.m_layout.setup(this.m_dsoClientDebugging);
    }

    public void setup(DsoClientData dsoClientData) {
        this.removeListeners();
        this.setEnabled(true);
        this.m_dsoClientData = dsoClientData;
        this.m_dsoClientDebugging = this.m_dsoClientData != null ? this.m_dsoClientData.getDebugging() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoClientData = null;
        this.m_dsoClientDebugging = null;
        this.m_layout.m_instrumentationLoggingPanel.tearDown();
        this.m_layout.m_runtimeLoggingPanel.tearDown();
        this.m_layout.m_runtimeOutputOptionsPanel.tearDown();
        this.setEnabled(false);
    }

    private class Layout {
        private InstrumentationLoggingPanel m_instrumentationLoggingPanel;
        private RuntimeLoggingPanel m_runtimeLoggingPanel;
        private RuntimeOutputOptionsPanel m_runtimeOutputOptionsPanel;

        void setup(DsoClientDebugging dsoClientDebugging) {
            this.m_instrumentationLoggingPanel.setup(DsoClientDebuggingPanel.this.m_dsoClientDebugging);
            this.m_runtimeLoggingPanel.setup(DsoClientDebuggingPanel.this.m_dsoClientDebugging);
            this.m_runtimeOutputOptionsPanel.setup(DsoClientDebuggingPanel.this.m_dsoClientDebugging);
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(1808));
            this.m_instrumentationLoggingPanel = new InstrumentationLoggingPanel(comp, 0);
            this.m_instrumentationLoggingPanel.setLayoutData(new GridData(0x1000008, 1, true, false));
            this.m_runtimeLoggingPanel = new RuntimeLoggingPanel(comp, 0);
            this.m_runtimeLoggingPanel.setLayoutData(new GridData(0x1000000, 1, false, false));
            this.m_runtimeOutputOptionsPanel = new RuntimeOutputOptionsPanel(comp, 0);
            this.m_runtimeOutputOptionsPanel.setLayoutData(new GridData(1, 1, true, false));
        }
    }
}

