/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.Client;
import com.terracottatech.config.DsoClientData;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.DsoClientDebuggingPanel;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerSpinner;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class DsoClientDataPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private Client m_client;
    private DsoClientData m_dsoClientData;
    private final Layout m_layout = new Layout(this);

    public DsoClientDataPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_dsoClientData == null) {
            this.removeListeners();
            this.m_dsoClientData = this.m_client.addNewDso();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_dsoClientData != null && this.m_dsoClientData.isSetDebugging() || ((XmlIntegerSpinner)this.m_layout.m_faultCountSpinner.getData()).isSet();
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testUnsetDsoClientData();
    }

    private void testUnsetDsoClientData() {
        if (!this.hasAnySet() && this.m_client.getDso() != null) {
            this.m_client.unsetDso();
            this.m_dsoClientData = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        } else {
            this.fireClientChanged();
        }
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_client);
    }

    private void addListeners() {
        this.m_layout.m_dsoClientDebugging.addXmlObjectStructureListener(this);
        ((XmlIntegerSpinner)this.m_layout.m_faultCountSpinner.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        this.m_layout.m_dsoClientDebugging.removeXmlObjectStructureListener(this);
        ((XmlIntegerSpinner)this.m_layout.m_faultCountSpinner.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setDsoClientData(this.m_dsoClientData);
    }

    public void setup(Client client) {
        this.removeListeners();
        this.setEnabled(true);
        this.m_client = client;
        this.m_dsoClientData = this.m_client != null ? this.m_client.getDso() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_layout.m_dsoClientDebugging.tearDown();
        ((XmlIntegerSpinner)this.m_layout.m_faultCountSpinner.getData()).tearDown();
        this.setEnabled(false);
    }

    private class Layout {
        private static final String DSO_CLIENT_DATA = "Dso Client Data";
        private static final String FAULT_COUNT = "Fault Count";
        private final DsoClientDebuggingPanel m_dsoClientDebugging;
        private Spinner m_faultCountSpinner;

        void setDsoClientData(DsoClientData dsoClientData) {
            this.m_dsoClientDebugging.setup(dsoClientData);
            ((XmlIntegerSpinner)this.m_faultCountSpinner.getData()).setup((XmlObject)dsoClientData);
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Group panel = new Group(parent, 32);
            panel.setText(DSO_CLIENT_DATA);
            GridLayout gridLayout = new GridLayout();
            panel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(1808);
            panel.setLayoutData((Object)gridData);
            this.m_dsoClientDebugging = new DsoClientDebuggingPanel((Composite)panel, 0);
            this.m_dsoClientDebugging.setLayoutData(new GridData(1808));
            this.createFaultCountPane((Composite)panel);
        }

        private void createFaultCountPane(Composite parent) {
            Composite faultCountPane = new Composite(parent, 0);
            faultCountPane.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout(2, false));
            faultCountPane.setLayoutData((Object)new GridData(770));
            Label faultCountLabel = new Label(faultCountPane, 0);
            faultCountLabel.setText(FAULT_COUNT);
            faultCountLabel.setLayoutData((Object)new GridData(4));
            this.m_faultCountSpinner = new Spinner(faultCountPane, 2048);
            this.m_faultCountSpinner.setLayoutData((Object)new GridData(768));
            DsoClientDataPanel.this.initIntegerSpinnerField(this.m_faultCountSpinner, DsoClientData.class, "fault-count");
        }
    }
}

