/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.DistributedMethods;
import com.terracottatech.config.DsoApplication;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.chooser.ExpressionChooser;
import org.terracotta.dso.editors.chooser.MethodBehavior;
import org.terracotta.ui.util.SWTUtil;

public class DistributedMethodsPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private DistributedMethods m_distributedMethods;
    private final Layout m_layout = new Layout(this);
    private final AddHandler m_addHandler = new AddHandler();
    private final RemoveHandler m_removeHandler = new RemoveHandler();
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();

    public DistributedMethodsPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_distributedMethods != null && this.m_distributedMethods.sizeOfMethodExpressionArray() > 0;
    }

    private DistributedMethods ensureDistributedMethods() {
        if (this.m_distributedMethods == null) {
            this.ensureXmlObject();
        }
        return this.m_distributedMethods;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_distributedMethods == null) {
            this.removeListeners();
            this.m_distributedMethods = this.m_dsoApp.addNewDistributedMethods();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testRemoveDistributedMethods() {
        if (!this.hasAnySet() && this.m_dsoApp.getDistributedMethods() != null) {
            this.m_dsoApp.unsetDistributedMethods();
            this.m_distributedMethods = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.fireDistributedMethodsChanged();
        this.testDisableRemoveButton();
    }

    private void testDisableRemoveButton() {
        this.m_layout.m_removeButton.setEnabled(this.m_layout.m_table.getSelectionCount() > 0);
    }

    private void addListeners() {
        this.m_layout.m_addButton.addSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.addSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.addListener(36, (Listener)this.m_tableDataListener);
    }

    private void removeListeners() {
        this.m_layout.m_addButton.removeSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.removeSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.removeListener(36, (Listener)this.m_tableDataListener);
    }

    public void updateChildren() {
        this.initTableItems();
        this.testDisableRemoveButton();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_distributedMethods = this.m_dsoApp != null ? this.m_dsoApp.getDistributedMethods() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoApp = null;
        this.m_distributedMethods = null;
        this.setEnabled(false);
    }

    private void initTableItems() {
        this.m_layout.m_table.removeAll();
        if (this.m_distributedMethods == null) {
            return;
        }
        DistributedMethods.MethodExpression[] methods = this.m_distributedMethods.getMethodExpressionArray();
        for (int i = 0; i < methods.length; ++i) {
            this.createTableItem(methods[i]);
        }
        if (methods.length > 0) {
            this.m_layout.m_table.setSelection(0);
        }
    }

    private void createTableItem(DistributedMethods.MethodExpression method) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        item.setText(method.getStringValue());
        item.setData((Object)method);
    }

    public boolean isDistributed(IMethod method) {
        return TcPlugin.getDefault().getConfigurationHelper(this.m_project).isDistributedMethod(method);
    }

    private void internalAddDistributed(String expr) {
        if (expr != null && expr.length() > 0) {
            DistributedMethods dms = this.ensureDistributedMethods();
            DistributedMethods.MethodExpression me = dms.addNewMethodExpression();
            me.setStringValue(expr);
            this.createTableItem(me);
        }
    }

    private class TableDataListener
    implements Listener {
        private TableDataListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            DistributedMethods.MethodExpression expr = (DistributedMethods.MethodExpression)item.getData();
            expr.setStringValue(item.getText(e.index));
            DistributedMethodsPanel.this.fireDistributedMethodsChanged();
        }
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DistributedMethodsPanel.this.m_layout.m_removeButton.setEnabled(true);
        }
    }

    private class RemoveHandler
    extends SelectionAdapter {
        private RemoveHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            DistributedMethodsPanel.this.m_layout.m_table.forceFocus();
            int[] selection = DistributedMethodsPanel.this.m_layout.m_table.getSelectionIndices();
            for (int i = selection.length - 1; i >= 0; --i) {
                DistributedMethodsPanel.this.ensureDistributedMethods().removeMethodExpression(selection[i]);
            }
            DistributedMethodsPanel.this.m_layout.m_table.remove(selection);
            DistributedMethodsPanel.this.testRemoveDistributedMethods();
        }
    }

    private class AddHandler
    extends SelectionAdapter {
        private AddHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            DistributedMethodsPanel.this.m_layout.m_table.forceFocus();
            MethodBehavior behavior = new MethodBehavior();
            ExpressionChooser chooser = new ExpressionChooser(DistributedMethodsPanel.this.getShell(), behavior.getTitle(), "Enter Method Expression", DistributedMethodsPanel.this.m_project, behavior);
            chooser.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent updateEvent) {
                    String[] items = (String[])updateEvent.data;
                    for (int i = 0; i < items.length; ++i) {
                        DistributedMethodsPanel.this.internalAddDistributed(items[i]);
                    }
                    DistributedMethodsPanel.this.fireDistributedMethodsChanged();
                }
            });
            chooser.open();
        }
    }

    private static class Layout {
        private static final String DISTRIBUTED_METHODS = "Distributed Methods";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private final Button m_addButton;
        private final Button m_removeButton;
        private final Table m_table;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(DISTRIBUTED_METHODS);
            label.setLayoutData((Object)new GridData(2));
            this.m_table = new Table(sidePanel, 68098);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_table, new int[]{3, 1});
            SWTUtil.makeTableColumnsEditable(this.m_table, new int[]{0});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_table, 3);
            this.m_table.setLayoutData((Object)gridData);
            TableColumn column = new TableColumn(this.m_table, 0);
            column.setText(DISTRIBUTED_METHODS);
            column.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addButton = new Button(buttonPanel, 8);
            this.m_addButton.setText(ADD);
            this.m_addButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addButton);
            this.m_removeButton = new Button(buttonPanel, 8);
            this.m_removeButton.setText(REMOVE);
            this.m_removeButton.setEnabled(false);
            this.m_removeButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeButton);
        }
    }
}

