/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaStringEnumEntry;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.IConfigurationListener;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditorRoot;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerField;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerSpinner;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.dso.editors.xmlbeans.XmlStringEnumCombo;
import org.terracotta.dso.editors.xmlbeans.XmlStringField;
import org.terracotta.ui.util.AbstractSWTPanel;
import org.terracotta.ui.util.SWTUtil;

public abstract class ConfigurationEditorPanel
extends AbstractSWTPanel
implements IConfigurationListener,
DisposeListener {
    private transient ArrayList<XmlObjectStructureListener> m_listenerList;
    private transient XmlObjectStructureChangeEvent m_changeEvent;

    public ConfigurationEditorPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(this);
        TcPlugin.getDefault().addConfigurationListener(this);
    }

    public static void ensureXmlObject(Composite comp) {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)comp);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    public void ensureXmlObject() {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)this);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    private ConfigurationEditorRoot getConfigurationEditorRoot() {
        if (this instanceof ConfigurationEditorRoot) {
            return (ConfigurationEditorRoot)((Object)this);
        }
        return (ConfigurationEditorRoot)SWTUtil.getAncestorOfClass(ConfigurationEditorRoot.class, (Control)this);
    }

    public IProject getProject() {
        return this.getConfigurationEditorRoot().getProject();
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        if (listener != null) {
            if (this.m_listenerList == null) {
                this.m_listenerList = new ArrayList();
            }
            this.m_listenerList.add(listener);
        }
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        if (listener != null && this.m_listenerList != null) {
            this.m_listenerList.remove(listener);
        }
    }

    private XmlObjectStructureChangeEvent getChangeEvent(XmlObject source) {
        if (this.m_changeEvent == null) {
            this.m_changeEvent = new XmlObjectStructureChangeEvent(source);
        } else {
            this.m_changeEvent.setXmlObject(source);
        }
        return this.m_changeEvent;
    }

    private XmlObjectStructureListener[] getListenerArray() {
        return this.m_listenerList.toArray(new XmlObjectStructureListener[0]);
    }

    protected void fireXmlObjectStructureChanged(XmlObjectStructureChangeEvent e) {
        if (this.m_listenerList != null) {
            XmlObjectStructureListener[] listeners = this.getListenerArray();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].structureChanged(e);
            }
        }
    }

    protected void fireXmlObjectStructureChanged(XmlObject source) {
        this.fireXmlObjectStructureChanged(this.getChangeEvent(source));
    }

    protected int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static SchemaType getParentSchemaType(Class parentType) throws Exception {
        return (SchemaType)parentType.getField("type").get(null);
    }

    private static SchemaProperty getSchemaProperty(Class parentType, String elementName) throws Exception {
        QName qname = QName.valueOf(elementName);
        SchemaType type = ConfigurationEditorPanel.getParentSchemaType(parentType);
        SchemaProperty property = type.getElementProperty(qname);
        if (property == null) {
            property = type.getAttributeProperty(qname);
        }
        return property;
    }

    private static SchemaType getPropertySchemaType(Class parentType, String elementName) throws Exception {
        return ConfigurationEditorPanel.getSchemaProperty(parentType, elementName).getType();
    }

    static String[] getListDefaults(Class parentType, String elementName) {
        try {
            SchemaStringEnumEntry[] enumEntries = ConfigurationEditorPanel.getPropertySchemaType(parentType, elementName).getStringEnumEntries();
            String[] values = new String[enumEntries.length];
            for (int i = 0; i < enumEntries.length; ++i) {
                values[i] = enumEntries[i].getString();
            }
            return values;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    void initStringField(Text field, Class parentType, String fieldName) {
        XmlStringField xmlField = XmlStringField.newInstance(field);
        field.setData((Object)xmlField);
        xmlField.init(parentType, fieldName);
    }

    void setStringField(Text text, String value) {
        assert (text != null);
        text.setText(value);
        text.selectAll();
        text.forceFocus();
        Object data = text.getData();
        if (data instanceof XmlStringField) {
            ((XmlStringField)data).set();
        }
    }

    void initIntegerField(Text field, Class parentType, String fieldName) {
        XmlIntegerField xmlField = XmlIntegerField.newInstance(field);
        field.setData((Object)xmlField);
        xmlField.init(parentType, fieldName);
    }

    void initBooleanField(Button field, Class parentType, String fieldName) {
        XmlBooleanToggle xmlField = XmlBooleanToggle.newInstance(field);
        field.setData((Object)xmlField);
        xmlField.init(parentType, fieldName);
    }

    void initIntegerSpinnerField(Spinner field, Class parentType, String fieldName) {
        XmlIntegerSpinner xmlField = XmlIntegerSpinner.newInstance(field);
        field.setData((Object)xmlField);
        xmlField.init(parentType, fieldName);
    }

    void initStringEnumCombo(Combo field, Class parentType, String fieldName) {
        XmlStringEnumCombo xmlField = XmlStringEnumCombo.newInstance(field);
        field.setData((Object)xmlField);
        xmlField.init(parentType, fieldName);
    }

    public void widgetDisposed(DisposeEvent e) {
        TcPlugin.getDefault().removeConfigurationListener(this);
    }

    void fireServerChanged(int index) {
        TcPlugin.getDefault().fireServerChanged(this.getProject(), index);
    }

    void fireServersChanged() {
        TcPlugin.getDefault().fireServersChanged(this.getProject());
    }

    void fireRootChanged(int index) {
        TcPlugin.getDefault().fireRootChanged(this.getProject(), index);
    }

    void fireRootsChanged() {
        TcPlugin.getDefault().fireRootsChanged(this.getProject());
    }

    void fireDistributedMethodsChanged() {
        TcPlugin.getDefault().fireDistributedMethodsChanged(this.getProject());
    }

    void fireDistributedMethodChanged(int index) {
        TcPlugin.getDefault().fireDistributedMethodChanged(this.getProject(), index);
    }

    void fireBootClassesChanged() {
        TcPlugin.getDefault().fireBootClassesChanged(this.getProject());
    }

    void fireBootClassChanged(int index) {
        TcPlugin.getDefault().fireBootClassChanged(this.getProject(), index);
    }

    void fireTransientFieldsChanged() {
        TcPlugin.getDefault().fireTransientFieldsChanged(this.getProject());
    }

    void fireTransientFieldChanged(int index) {
        TcPlugin.getDefault().fireTransientFieldChanged(this.getProject(), index);
    }

    void fireNamedLockChanged(int index) {
        TcPlugin.getDefault().fireNamedLockChanged(this.getProject(), index);
    }

    void fireNamedLocksChanged() {
        TcPlugin.getDefault().fireNamedLocksChanged(this.getProject());
    }

    void fireAutolockChanged(int index) {
        try {
            TcPlugin.getDefault().fireAutolockChanged(this.getProject(), index);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void fireAutolocksChanged() {
        TcPlugin.getDefault().fireAutolocksChanged(this.getProject());
    }

    void fireIncludeRuleChanged(int index) {
        TcPlugin.getDefault().fireIncludeRuleChanged(this.getProject(), index);
    }

    void fireIncludeRulesChanged() {
        TcPlugin.getDefault().fireIncludeRulesChanged(this.getProject());
    }

    void fireExcludeRuleChanged(int index) {
        TcPlugin.getDefault().fireExcludeRuleChanged(this.getProject(), index);
    }

    void fireExcludeRulesChanged() {
        TcPlugin.getDefault().fireExcludeRulesChanged(this.getProject());
    }

    void fireInstrumentationRulesChanged() {
        TcPlugin.getDefault().fireInstrumentationRulesChanged(this.getProject());
    }

    void fireClientChanged() {
        TcPlugin.getDefault().fireClientChanged(this.getProject());
    }

    void fireModuleRepoChanged(int index) {
        TcPlugin.getDefault().fireModuleRepoChanged(this.getProject(), index);
    }

    void fireModuleReposChanged() {
        TcPlugin.getDefault().fireModuleReposChanged(this.getProject());
    }

    void fireModuleChanged(int index) {
        TcPlugin.getDefault().fireModuleChanged(this.getProject(), index);
    }

    void fireModulesChanged() {
        TcPlugin.getDefault().fireModulesChanged(this.getProject());
    }

    public void configurationChanged(IProject project) {
    }

    public void serverChanged(IProject project, int index) {
    }

    public void serversChanged(IProject project) {
    }

    public void rootChanged(IProject project, int index) {
    }

    public void rootsChanged(IProject project) {
    }

    public void distributedMethodsChanged(IProject project) {
    }

    public void distributedMethodChanged(IProject project, int index) {
    }

    public void bootClassesChanged(IProject project) {
    }

    public void bootClassChanged(IProject project, int index) {
    }

    public void transientFieldsChanged(IProject project) {
    }

    public void transientFieldChanged(IProject project, int index) {
    }

    public void namedLockChanged(IProject project, int index) {
    }

    public void namedLocksChanged(IProject project) {
    }

    public void autolockChanged(IProject project, int index) {
    }

    public void autolocksChanged(IProject project) {
    }

    public void includeRuleChanged(IProject project, int index) {
    }

    public void includeRulesChanged(IProject project) {
    }

    public void excludeRuleChanged(IProject project, int index) {
    }

    public void excludeRulesChanged(IProject project) {
    }

    public void instrumentationRulesChanged(IProject project) {
    }

    public void clientChanged(IProject project) {
    }

    public void moduleReposChanged(IProject project) {
    }

    public void moduleRepoChanged(IProject project, int index) {
    }

    public void moduleChanged(IProject project, int index) {
    }

    public void modulesChanged(IProject project) {
    }
}

