/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.TcConfigDocument;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.IConfigurationListener;
import org.terracotta.dso.Messages;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ClientsPanel;
import org.terracotta.dso.editors.DsoApplicationPanel;
import org.terracotta.dso.editors.ServersPanel;
import org.terracotta.dso.editors.xml.XMLEditor;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;

public class ConfigurationEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IGotoMarker,
XmlObjectStructureListener {
    private static final int XML_EDITOR_PAGE_INDEX = 0;
    private static final int DSO_APPLICATION_PAGE_INDEX = 1;
    private static final int SERVERS_PAGE_INDEX = 2;
    private static final int CLIENT_PAGE_INDEX = 3;
    private IProject m_project;
    private DsoApplicationPanel m_dsoAppPanel;
    private ServersPanel m_serversPanel;
    private ClientsPanel m_clientsPanel;
    private XMLEditor m_xmlEditor;
    private int m_xmlEditorPageIndex;
    private boolean m_haveActiveConfig;
    private DocumentListener m_docListener = new DocumentListener();
    private ElementStateListener m_elementStateListener = new ElementStateListener();
    private TextInputListener m_textInputListener = new TextInputListener();
    private Runnable m_parseTimer = new ParseTimer();
    private boolean m_syncXmlText;
    private Display m_display = Display.getDefault();
    private IConfigurationListener m_configAdapter = new ConfigAdapter();

    protected void pageChange(final int newPageIndex) {
        TcPlugin plugin;
        TcConfigDocument.TcConfig config;
        if (newPageIndex != 0 && this.m_project != null && this.m_project.isOpen() && (config = (plugin = TcPlugin.getDefault()).getConfiguration(this.m_project)) == TcPlugin.BAD_CONFIG) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ConfigurationEditor.this.getControl(newPageIndex).setVisible(false);
                    Shell shell = Display.getDefault().getActiveShell();
                    String title = "Terracotta Config Editor";
                    String msg = "The source page has errors. The other pages cannot be\nused until these errors are resolved.";
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                }
            });
            this.setActivePage(0);
            return;
        }
        super.pageChange(newPageIndex);
    }

    private void setTimer(boolean start) {
        if (start) {
            this.m_display.timerExec(1000, this.m_parseTimer);
        } else {
            this.m_display.timerExec(-1, this.m_parseTimer);
        }
    }

    void createDsoApplicationPage(int pageIndex) {
        this.m_dsoAppPanel = new DsoApplicationPanel(this.getContainer(), 0);
        this.addPage(pageIndex, (Control)this.m_dsoAppPanel);
        this.setPageText(pageIndex, "DSO config");
        this.m_dsoAppPanel.addXmlObjectStructureListener(this);
    }

    public DsoApplicationPanel getDsoApplicationPanel() {
        return this.m_dsoAppPanel;
    }

    public void showDsoApplicationPanel() {
        this.setActivePage(0);
    }

    void createServersPage(int pageIndex) {
        ScrolledComposite scroll = new ScrolledComposite(this.getContainer(), 768);
        this.m_serversPanel = new ServersPanel((Composite)scroll, 0);
        scroll.setContent((Control)this.m_serversPanel);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(this.m_serversPanel.computeSize(-1, -1));
        this.addPage(pageIndex, (Control)scroll);
        this.setPageText(pageIndex, "Servers config");
        this.m_serversPanel.addXmlObjectStructureListener(this);
    }

    void createClientPage(int pageIndex) {
        ScrolledComposite scroll = new ScrolledComposite(this.getContainer(), 768);
        this.m_clientsPanel = new ClientsPanel((Composite)scroll, 0);
        scroll.setContent((Control)this.m_clientsPanel);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(this.m_clientsPanel.computeSize(-1, -1));
        this.addPage(pageIndex, (Control)scroll);
        this.setPageText(pageIndex, "Clients config");
        this.m_clientsPanel.addXmlObjectStructureListener(this);
    }

    void createXMLEditorPage(int pageIndex) {
        try {
            IEditorInput input = this.getEditorInput();
            this.m_xmlEditor = new XMLEditor(){

                public void doSave(IProgressMonitor progressMonitor) {
                    ConfigurationEditor.this.doSave(progressMonitor);
                }
            };
            this.m_xmlEditorPageIndex = pageIndex;
            this.addPage(this.m_xmlEditorPageIndex, (IEditorPart)this.m_xmlEditor, input);
            this.setPageText(this.m_xmlEditorPageIndex, this.m_xmlEditor.getTitle());
            this.m_xmlEditor.addTextInputListener(this.m_textInputListener);
            this.m_xmlEditor.getDocument().addDocumentListener((IDocumentListener)this.m_docListener);
            this.m_xmlEditor.getDocumentProvider().addElementStateListener((IElementStateListener)this.m_elementStateListener);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public boolean isActiveConfig() {
        TcPlugin plugin = TcPlugin.getDefault();
        IFile configFile = plugin.getConfigurationFile(this.m_project);
        FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
        IFile file = fileEditorInput.getFile();
        return file != null && file.equals(configFile) && plugin.hasTerracottaNature(this.m_project);
    }

    boolean haveActiveConfig() {
        return this.m_haveActiveConfig;
    }

    protected void createPages() {
        this.createXMLEditorPage(0);
        if (this.haveActiveConfig()) {
            this.createDsoApplicationPage(1);
            this.createServersPage(2);
            this.createClientPage(3);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.initPanels();
            TcPlugin.getDefault().addConfigurationListener(this.m_configAdapter);
        }
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
    }

    public void dispose() {
        if (this.haveActiveConfig()) {
            this.m_serversPanel.removeXmlObjectStructureListener(this);
            this.m_clientsPanel.removeXmlObjectStructureListener(this);
            this.m_dsoAppPanel.removeXmlObjectStructureListener(this);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            TcPlugin.getDefault().removeConfigurationListener(this.m_configAdapter);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.haveActiveConfig()) {
            this.setTimer(false);
        }
        TcPlugin.getDefault().ignoreNextConfigChange();
        this.m_xmlEditor.doSaveWork(monitor);
        this.m_syncXmlText = true;
        this.syncXmlModel();
        this.m_syncXmlText = false;
        this.clearDirty();
    }

    public void doSaveAs() {
        this.performSaveAs(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile original = null;
        if (input instanceof IFileEditorInput && (original = ((IFileEditorInput)input).getFile()) != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        IDocumentProvider provider = this.m_xmlEditor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input) && original != null) {
            String message = MessageFormat.format(Messages.Editor_warning_save_delete, original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        boolean success = false;
        try {
            provider.aboutToChange((Object)newInput);
            provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
            success = true;
            this.clearDirty();
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            if (status == null || status.getSeverity() != 8) {
                String title = Messages.Editor_error_save_title;
                String msg = MessageFormat.format(Messages.Editor_error_save_message, ce.getMessage());
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        finally {
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void newInputFile(final IFile file) {
        if (file != null && file.exists()) {
            this.syncExec(new Runnable(){

                public void run() {
                    FileEditorInput input = new FileEditorInput(file);
                    ConfigurationEditor.this.setInput((IEditorInput)input);
                    ConfigurationEditor.this.m_project = file.getProject();
                    if (ConfigurationEditor.this.haveActiveConfig()) {
                        if (ConfigurationEditor.this.getPageCount() == 1) {
                            ConfigurationEditor.this.createDsoApplicationPage(1);
                            ConfigurationEditor.this.createServersPage(2);
                            ConfigurationEditor.this.createClientPage(3);
                        }
                        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)ConfigurationEditor.this);
                        ConfigurationEditor.this.initPanels();
                    } else {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)ConfigurationEditor.this);
                        for (int i = ConfigurationEditor.this.getPageCount() - 1; i > 0; --i) {
                            ConfigurationEditor.this.removePage(i);
                        }
                    }
                    ConfigurationEditor.this.m_xmlEditor.setInput((IEditorInput)input);
                    String name = file.getName();
                    ConfigurationEditor.this.setPartName(name);
                    ConfigurationEditor.this.setPageText(ConfigurationEditor.this.m_xmlEditorPageIndex, name);
                }
            });
        }
    }

    private void syncExec(Runnable runner) {
        this.getSite().getShell().getDisplay().syncExec(runner);
    }

    private void asyncExec(Runnable runner) {
        this.getSite().getShell().getDisplay().asyncExec(runner);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        IProject project = file.getProject();
        if (!project.exists()) {
            String msg = "Project '" + project.getName() + "' does not exist";
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            throw new PartInitException(msg);
        }
        if (!project.isOpen()) {
            String msg = "Project '" + project.getName() + "' is not open";
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            throw new PartInitException(msg);
        }
        this.m_project = project;
        super.init(site, editorInput);
        this.setPartName(file.getName());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.m_haveActiveConfig = this.isActiveConfig();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void initPanels() {
        if (this.m_project != null && this.m_project.isOpen()) {
            this.m_dsoAppPanel.setup(this.m_project);
            this.m_serversPanel.setup(this.m_project);
            this.m_clientsPanel.setup(this.m_project);
            this.enablePanels();
        } else {
            this.disablePanels();
        }
    }

    private void disablePanels() {
        this.m_dsoAppPanel.setEnabled(false);
        this.m_serversPanel.setEnabled(false);
        this.m_clientsPanel.setEnabled(false);
    }

    private void enablePanels() {
        this.m_dsoAppPanel.setEnabled(true);
        this.m_serversPanel.setEnabled(true);
        this.m_clientsPanel.setEnabled(true);
    }

    public void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, true);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                if (!this.m_project.equals(event.getResource())) break;
                if (Display.getCurrent() != null) {
                    this.closeEditor();
                    return;
                }
                this.syncExec(new Runnable(){

                    public void run() {
                        ConfigurationEditor.this.closeEditor();
                    }
                });
            }
        }
    }

    public void syncXmlDocument() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        this.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ConfigurationEditor.this.m_xmlEditor.getTextWidget().setRedraw(false);
                try {
                    int topLine = ConfigurationEditor.this.m_xmlEditor.getTopIndex();
                    TcPlugin plugin = TcPlugin.getDefault();
                    IDocument doc = ConfigurationEditor.this.m_xmlEditor.getDocument();
                    TcConfigDocument.TcConfig config = plugin.getConfiguration(ConfigurationEditor.this.m_project);
                    if (config != null && config != TcPlugin.BAD_CONFIG) {
                        TcConfigDocument configDoc = TcConfigDocument.Factory.newInstance();
                        configDoc.setTcConfig(config);
                        doc.removeDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
                        doc.set(plugin.configDocumentAsString(configDoc));
                        doc.addDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
                    }
                    ConfigurationEditor.this.m_xmlEditor.setTopIndex(topLine);
                }
                finally {
                    ConfigurationEditor.this.m_xmlEditor.getTextWidget().setRedraw(true);
                }
            }
        });
    }

    public synchronized void syncXmlModel() {
        TcPlugin plugin = TcPlugin.getDefault();
        IDocument doc = this.m_xmlEditor.getDocument();
        String xmlText = doc.get();
        try {
            plugin.setConfigurationFromString(this.m_project, xmlText);
        }
        catch (Exception e) {
            this.disablePanels();
        }
    }

    private void clearDirty() {
        this.internalSetDirty(Boolean.FALSE);
    }

    private void internalSetDirty(Boolean isDirty) {
        TcPlugin.getDefault().setConfigurationFileDirty(this.m_project, isDirty);
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.m_project != null && this.haveActiveConfig()) {
            return this.m_project.isOpen() && TcPlugin.getDefault().isConfigurationFileDirty(this.m_project);
        }
        return super.isDirty();
    }

    public void modelChanged() {
        this.syncXmlDocument();
        this.internalSetDirty(Boolean.TRUE);
    }

    public IDocument getDocument() {
        return this.m_xmlEditor.getDocument();
    }

    public void applyProblemToText(String text, String msg, String markerType) {
        TcPlugin plugin = TcPlugin.getDefault();
        IDocument doc = this.m_xmlEditor.getDocument();
        ConfigurationHelper configHelper = plugin.getConfigurationHelper(this.m_project);
        configHelper.applyProblemToText(doc, text, msg, markerType);
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (ConfigurationEditor.this.haveActiveConfig()) {
                ConfigurationEditor.this.setTimer(false);
            }
            ConfigurationEditor.this.internalSetDirty(Boolean.TRUE);
            if (ConfigurationEditor.this.haveActiveConfig()) {
                ConfigurationEditor.this.setTimer(true);
            }
        }
    }

    class ElementStateListener
    implements IElementStateListener {
        ElementStateListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
            ConfigurationEditor.this.m_xmlEditor.getDocument().removeDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
        }

        public void elementContentReplaced(Object element) {
            ConfigurationEditor.this.m_xmlEditor.getDocument().addDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
            }
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)ConfigurationEditor.this.m_docListener);
            }
        }
    }

    private class ParseTimer
    implements Runnable {
        private ParseTimer() {
        }

        public void run() {
            ConfigurationEditor.this.m_syncXmlText = true;
            ConfigurationEditor.this.syncXmlModel();
            ConfigurationEditor.this.m_syncXmlText = false;
        }
    }

    class ConfigAdapter
    implements IConfigurationListener {
        ConfigAdapter() {
        }

        private void update(boolean initPanels) {
            if (!ConfigurationEditor.this.m_syncXmlText) {
                ConfigurationEditor.this.syncXmlDocument();
            }
            if (initPanels) {
                ConfigurationEditor.this.initPanels();
            }
            ConfigurationEditor.this.internalSetDirty(Boolean.TRUE);
        }

        private void handleUpdate(final boolean updatePanels) {
            if (Display.getCurrent() != null) {
                this.update(updatePanels);
                return;
            }
            ConfigurationEditor.this.asyncExec(new Runnable(){

                public void run() {
                    ConfigAdapter.this.update(updatePanels);
                }
            });
        }

        public void configurationChanged(IProject project) {
            if (TcPlugin.getDefault().hasTerracottaNature(project) && ConfigurationEditor.this.m_project != null && ConfigurationEditor.this.m_project.equals(project)) {
                this.handleUpdate(true);
            }
        }

        private void handleChange(IProject project, boolean updatePanels) {
            if (TcPlugin.getDefault().hasTerracottaNature(project) && ConfigurationEditor.this.m_project != null && ConfigurationEditor.this.m_project.equals(project)) {
                this.handleUpdate(updatePanels);
            }
        }

        public void serverChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void serversChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void rootChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void rootsChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void distributedMethodsChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void distributedMethodChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void bootClassesChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void bootClassChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void transientFieldsChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void transientFieldChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void autolockChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void autolocksChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void namedLockChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void namedLocksChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void includeRuleChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void includeRulesChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void excludeRuleChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void excludeRulesChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void instrumentationRulesChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void clientChanged(IProject project) {
            this.handleChange(project, false);
        }

        public void moduleReposChanged(IProject project) {
            this.handleChange(project, true);
        }

        public void moduleRepoChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void moduleChanged(IProject project, int index) {
            this.handleChange(project, false);
        }

        public void modulesChanged(IProject project) {
            this.handleChange(project, true);
        }
    }
}

