/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.AdditionalBootJarClasses;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.QualifiedClassName;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.ui.util.SWTUtil;

public class BootClassesPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private AdditionalBootJarClasses m_bootClasses;
    private final Layout m_layout = new Layout(this);
    private final AddHandler m_addHandler = new AddHandler();
    private final RemoveHandler m_removeHandler = new RemoveHandler();
    private final TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private final TableDataListener m_tableDataListener = new TableDataListener();
    private static final String CLASS_SELECT_TITLE = "DSO Application Configuration";
    private static final String CLASS_SELECT_MESSAGE = "Select system classes to add to DSO Boot Jar";

    public BootClassesPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_bootClasses != null && this.m_bootClasses.sizeOfIncludeArray() > 0;
    }

    private AdditionalBootJarClasses ensureAdditionalBootClasses() {
        if (this.m_bootClasses == null) {
            this.ensureXmlObject();
        }
        return this.m_bootClasses;
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_bootClasses == null) {
            this.removeListeners();
            this.m_bootClasses = this.m_dsoApp.addNewAdditionalBootJarClasses();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testRemoveBootClasses() {
        if (!this.hasAnySet() && this.m_dsoApp.getAdditionalBootJarClasses() != null) {
            this.m_dsoApp.unsetAdditionalBootJarClasses();
            this.m_bootClasses = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.fireBootClassesChanged();
        this.testDisableRemoveButton();
    }

    private void testDisableRemoveButton() {
        this.m_layout.m_removeButton.setEnabled(this.m_layout.m_table.getSelectionCount() > 0);
    }

    private void addListeners() {
        this.m_layout.m_addButton.addSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.addSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.addListener(36, (Listener)this.m_tableDataListener);
    }

    private void removeListeners() {
        this.m_layout.m_addButton.removeSelectionListener((SelectionListener)this.m_addHandler);
        this.m_layout.m_removeButton.removeSelectionListener((SelectionListener)this.m_removeHandler);
        this.m_layout.m_table.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.removeListener(36, (Listener)this.m_tableDataListener);
    }

    public void updateChildren() {
        this.initTableItems();
        this.testDisableRemoveButton();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_bootClasses = this.m_dsoApp != null ? this.m_dsoApp.getAdditionalBootJarClasses() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoApp = null;
        this.m_bootClasses = null;
        this.setEnabled(false);
    }

    private void initTableItems() {
        this.m_layout.m_table.removeAll();
        if (this.m_bootClasses == null) {
            return;
        }
        XmlObject[] includes = this.m_bootClasses.selectPath("*");
        for (int i = 0; i < includes.length; ++i) {
            this.createTableItem((QualifiedClassName)includes[i]);
        }
        if (includes.length > 0) {
            this.m_layout.m_table.setSelection(0);
        }
    }

    private void createTableItem(QualifiedClassName element) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        item.setText(element.getStringValue());
        item.setData((Object)element);
    }

    private void internalAddBootClass(String typeName) {
        AdditionalBootJarClasses bootClasses = this.ensureAdditionalBootClasses();
        bootClasses.addInclude(typeName);
        this.createTableItem(bootClasses.xgetIncludeArray(bootClasses.sizeOfIncludeArray() - 1));
        int row = this.m_layout.m_table.getItemCount() - 1;
        this.m_layout.m_table.setSelection(row);
    }

    public boolean isBootClass(String typeName) {
        AdditionalBootJarClasses bootClasses = this.ensureAdditionalBootClasses();
        for (int i = 0; i < bootClasses.sizeOfIncludeArray(); ++i) {
            if (!typeName.equals(bootClasses.getIncludeArray(i))) continue;
            return true;
        }
        return false;
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            QualifiedClassName qcn = (QualifiedClassName)item.getData();
            qcn.setStringValue(item.getText(e.index));
            BootClassesPanel.this.fireBootClassesChanged();
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            BootClassesPanel.this.m_layout.m_removeButton.setEnabled(true);
        }
    }

    class RemoveHandler
    extends SelectionAdapter {
        RemoveHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            BootClassesPanel.this.m_layout.m_table.forceFocus();
            int[] selection = BootClassesPanel.this.m_layout.m_table.getSelectionIndices();
            for (int i = selection.length - 1; i >= 0; --i) {
                BootClassesPanel.this.ensureAdditionalBootClasses().removeInclude(selection[i]);
            }
            BootClassesPanel.this.m_layout.m_table.remove(selection);
            BootClassesPanel.this.testRemoveBootClasses();
        }
    }

    class AddHandler
    extends SelectionAdapter {
        AddHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectionDialog dialog;
            BootClassesPanel.this.m_layout.m_table.forceFocus();
            IJavaProject javaProject = JavaCore.create((IProject)BootClassesPanel.this.m_project);
            int filter = 4;
            IJavaElement[] elements = new IJavaElement[]{javaProject};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)filter);
            int style = 256;
            try {
                dialog = JavaUI.createTypeDialog((Shell)BootClassesPanel.this.getShell(), null, (IJavaSearchScope)scope, (int)style, (boolean)true);
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
                return;
            }
            dialog.setTitle(BootClassesPanel.CLASS_SELECT_TITLE);
            dialog.setMessage(BootClassesPanel.CLASS_SELECT_MESSAGE);
            dialog.open();
            Object[] items = dialog.getResult();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    BootClassesPanel.this.internalAddBootClass(PatternHelper.getFullyQualifiedName((IType)items[i]));
                }
                BootClassesPanel.this.fireBootClassesChanged();
            }
        }
    }

    private static class Layout {
        private static final String BOOT_CLASSES = "Boot Classes";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private final Button m_addButton;
        private final Button m_removeButton;
        private final Table m_table;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(BOOT_CLASSES);
            label.setLayoutData((Object)new GridData(2));
            this.m_table = new Table(sidePanel, 68098);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_table, new int[]{3, 1});
            SWTUtil.makeTableColumnsEditable(this.m_table, new int[]{0});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_table, 3);
            this.m_table.setLayoutData((Object)gridData);
            TableColumn column = new TableColumn(this.m_table, 0);
            column.setText(BOOT_CLASSES);
            column.pack();
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addButton = new Button(buttonPanel, 8);
            this.m_addButton.setText(ADD);
            this.m_addButton.setLayoutData((Object)new GridData(8));
            SWTUtil.applyDefaultButtonSize(this.m_addButton);
            this.m_removeButton = new Button(buttonPanel, 8);
            this.m_removeButton.setText(REMOVE);
            this.m_removeButton.setEnabled(false);
            this.m_removeButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeButton);
        }
    }
}

