/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.terracotta.ui.util.SWTUtil;

public class RepoLocationDialog
extends MessageDialog {
    private Text m_repoLocation;
    private Button m_browseButton;
    private ValueListener m_valueListener;

    public RepoLocationDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, null, message, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.m_repoLocation = new Text(comp, 2052);
        this.m_repoLocation.setLayoutData((Object)new GridData(768));
        this.m_browseButton = new Button(comp, 8);
        this.m_browseButton.setText("Browse...");
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(RepoLocationDialog.this.getShell());
                directoryDialog.setText("Terracotta Module Repository Chooser");
                directoryDialog.setMessage("Select a module repository directory");
                String path = directoryDialog.open();
                if (path != null) {
                    File dir = new File(path);
                    RepoLocationDialog.this.m_repoLocation.setText(dir.toString());
                }
            }
        });
        SWTUtil.applyDefaultButtonSize(this.m_browseButton);
        return this.m_repoLocation;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.m_valueListener != null) {
            this.m_valueListener.setValues(this.m_repoLocation.getText());
        }
        super.buttonPressed(buttonId);
    }

    public void addValueListener(ValueListener listener) {
        this.m_valueListener = listener;
    }

    public static interface ValueListener {
        public void setValues(String var1);
    }
}

