/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import com.tc.admin.common.AbstractResolutionAction;
import com.tc.admin.common.AbstractWorkState;
import com.tc.admin.common.NonPortableMessages;
import com.tc.admin.common.NonPortableResolutionAction;
import com.tc.admin.common.NonPortableWorkState;
import com.tc.object.appevent.AbstractApplicationEvent;
import com.tc.object.appevent.ApplicationEventContext;
import com.tc.object.appevent.NonPortableEventContext;
import com.tc.object.appevent.NonPortableObjectEvent;
import com.terracottatech.config.Include;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.dialogs.AbstractApplicationEventDialog;
import org.terracotta.ui.util.SWTUtil;

public class NonPortableObjectDialog
extends AbstractApplicationEventDialog {
    private Text fIssueDescription;
    private IncludeTypesPanel fIncludeTypesView;
    private Button fPreviousIssueButton;
    private Button fNextIssueButton;
    private Button fApplyButton;

    public NonPortableObjectDialog(Shell parentShell, NonPortableObjectEvent event) {
        super(parentShell, NonPortableMessages.getString((String)"PROBLEM_SHARING_DATA"), (AbstractApplicationEvent)event, new String[]{IDialogConstants.CANCEL_LABEL, NonPortableMessages.getString((String)"PREVIOUS_ISSUE"), NonPortableMessages.getString((String)"NEXT_ISSUE"), NonPortableMessages.getString((String)"APPLY")}, 1);
    }

    private NonPortableObjectEvent getNonPortableObjectEvent() {
        return (NonPortableObjectEvent)this.getApplicationEvent();
    }

    private NonPortableEventContext getNonPortableEventContext() {
        return this.getNonPortableObjectEvent().getNonPortableEventContext();
    }

    protected String getDialogSettingsSectionName() {
        return "org.terracotta.dso.NON_PORTABLE_DIALOG_SECTION";
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.fPreviousIssueButton = this.getButton(1);
        this.fNextIssueButton = this.getButton(2);
        this.fApplyButton = this.getButton(3);
        this.fPreviousIssueButton.setEnabled(this.getPreviousIssue() != null);
        this.fNextIssueButton.setEnabled(this.getNextIssue() != null);
        this.fApplyButton.setEnabled(false);
    }

    protected void createIssueDescriptionArea(Composite parent) {
        this.fIssueDescription = new Text(parent, 2634);
        GridData gridData = new GridData(1808);
        gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.fIssueDescription, 80);
        gridData.heightHint = SWTUtil.textRowsToPixels((Control)this.fIssueDescription, 8);
        this.fIssueDescription.setLayoutData((Object)gridData);
    }

    protected Control createCustomArea(Composite parent) {
        Control customArea = super.createCustomArea(parent);
        this.fIncludeTypesView = new IncludeTypesPanel(this.fActionPanel);
        return customArea;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.cancelPressed();
                break;
            }
            case 1: {
                this.gotoPreviousIssue();
                break;
            }
            case 2: {
                this.gotoNextIssue();
                break;
            }
            case 3: {
                this.apply();
                this.okPressed();
            }
        }
    }

    protected boolean anySelectedActions() {
        for (int i = 0; i < this.fIssueTable.getItemCount(); ++i) {
            AbstractWorkState workState;
            Object userObject;
            TableItem tableItem = this.fIssueTable.getItem(i);
            TreeItem treeItem = (TreeItem)tableItem.getData();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeItem.getData();
            if (node == null || !((userObject = node.getUserObject()) instanceof AbstractWorkState) || !(workState = (AbstractWorkState)userObject).hasSelectedActions()) continue;
            return true;
        }
        return false;
    }

    private void gotoPreviousIssue() {
        TreeItem item = this.getPreviousIssue();
        if (item != null) {
            this.fObjectTree.setSelection(item);
            this.handleTreeSelectionChange();
        }
    }

    private TreeItem getPreviousIssue(TreeItem item) {
        while ((item = this.getPreviousItem(item)) != null) {
            NonPortableWorkState workState;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)item.getData();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NonPortableWorkState) || !this.testIsIssue(workState = (NonPortableWorkState)userObject)) continue;
            return item;
        }
        return null;
    }

    private TreeItem getPreviousIssue() {
        TreeItem[] selection = this.fObjectTree.getSelection();
        if (selection != null && selection.length > 0) {
            return this.getPreviousIssue(selection[0]);
        }
        return null;
    }

    private void gotoNextIssue() {
        TreeItem item = this.getNextIssue();
        if (item != null) {
            this.fObjectTree.setSelection(item);
            this.handleTreeSelectionChange();
        }
    }

    private TreeItem getNextItem(TreeItem item, boolean includeChildren) {
        TreeItem[] children;
        if (item == null) {
            return null;
        }
        if (includeChildren && (children = item.getItems()) != null && children.length > 0) {
            return children[0];
        }
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return null;
        }
        TreeItem[] siblings = parent.getItems();
        if (siblings != null) {
            if (siblings.length <= 1) {
                return this.getNextItem(parent, false);
            }
            for (int i = 0; i < siblings.length; ++i) {
                if (siblings[i] != item || i >= siblings.length - 1) continue;
                return siblings[i + 1];
            }
        }
        return this.getNextItem(parent, false);
    }

    private TreeItem getPreviousItem(TreeItem item) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return null;
        }
        TreeItem[] siblings = parent.getItems();
        if (siblings.length == 0 || siblings[0] == item) {
            return parent;
        }
        TreeItem previous = siblings[0];
        for (int i = 1; i < siblings.length; ++i) {
            if (siblings[i] == item) {
                return this.rightMostDescendent(previous);
            }
            previous = siblings[i];
        }
        return null;
    }

    private TreeItem rightMostDescendent(TreeItem item) {
        TreeItem[] children = item.getItems();
        if (children != null && children.length > 0) {
            return this.rightMostDescendent(children[children.length - 1]);
        }
        return item;
    }

    private TreeItem getNextIssue(TreeItem item) {
        while ((item = this.getNextItem(item, true)) != null) {
            NonPortableWorkState workState;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)item.getData();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NonPortableWorkState) || !this.testIsIssue(workState = (NonPortableWorkState)userObject)) continue;
            return item;
        }
        return null;
    }

    private TreeItem getNextIssue() {
        TreeItem[] selection = this.fObjectTree.getSelection();
        if (selection != null && selection.length > 0) {
            return this.getNextIssue(selection[0]);
        }
        return null;
    }

    boolean testIsIssue(NonPortableWorkState workState) {
        Iterator iter;
        List types;
        boolean isTransientField;
        String fieldName = workState.getFieldName();
        boolean bl = isTransientField = fieldName != null && (this.fConfigHelper.isTransient(fieldName) || workState.isTransient());
        if (workState.isNull() || workState.isRepeated() || isTransientField) {
            return false;
        }
        if (workState.isNeverPortable() || workState.extendsLogicallyManagedType()) {
            return true;
        }
        if (workState.hasRequiredBootTypes()) {
            types = workState.getRequiredBootTypes();
            iter = types.iterator();
            while (iter.hasNext()) {
                if (this.fConfigHelper.isBootJarClass((String)iter.next())) continue;
                return true;
            }
        }
        if (workState.hasRequiredIncludeTypes()) {
            types = workState.getRequiredIncludeTypes();
            iter = types.iterator();
            while (iter.hasNext()) {
                if (this.fConfigHelper.isAdaptable((String)iter.next())) continue;
                return true;
            }
        }
        if (!workState.isPortable() && workState.isSystemType() && !this.fConfigHelper.isBootJarClass(workState.getTypeName())) {
            return true;
        }
        if (workState.getExplaination() != null) {
            return true;
        }
        return !workState.isPortable() && !this.fConfigHelper.isAdaptable(workState.getTypeName());
    }

    boolean checkAddToIssueList(NonPortableWorkState workState) {
        if (workState.hasSelectedActions()) {
            return true;
        }
        return this.testIsIssue(workState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initIssueList() {
        TreeItem treeItem = this.fObjectTree.getItem(0);
        this.fIssueTable.setRedraw(false);
        try {
            this.fIssueTable.setItemCount(0);
            while (treeItem != null) {
                NonPortableWorkState workState;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeItem.getData();
                Object userObject = node.getUserObject();
                if (userObject instanceof NonPortableWorkState && this.checkAddToIssueList(workState = (NonPortableWorkState)userObject)) {
                    TableItem tableItem = new TableItem(this.fIssueTable, 0);
                    tableItem.setData((Object)treeItem);
                    tableItem.setImage(workState.hasSelectedActions() ? RESOLVED_ICON : BLANK_ICON);
                    tableItem.setText(workState.shortSummary());
                }
                treeItem = this.getNextItem(treeItem, true);
            }
        }
        finally {
            this.fIssueTable.setRedraw(true);
        }
    }

    void syncTableAndTree() {
        TreeItem[] selection = this.fObjectTree.getSelection();
        TreeItem treeItem = selection[0];
        int tableCount = this.fIssueTable.getItemCount();
        for (int i = 0; i < tableCount; ++i) {
            TableItem tableItem = this.fIssueTable.getItem(i);
            if (tableItem.getData() != treeItem) continue;
            this.fIssueTable.setSelection(i);
            return;
        }
        this.fIssueTable.deselectAll();
    }

    protected void handleTreeSelectionChange() {
        TreeItem[] selection = this.fObjectTree.getSelection();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection[0].getData();
        Object userObject = node.getUserObject();
        this.syncTableAndTree();
        if (userObject instanceof NonPortableWorkState) {
            this.setWorkState((AbstractWorkState)((NonPortableWorkState)userObject));
        } else {
            this.hideResolutionsPanel();
        }
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWorkState(AbstractWorkState workState) {
        this.fActionTreeViewer.getTree().setRedraw(false);
        try {
            this.showResolutionsPanel();
            this.hideActionPanel();
            this.fSummaryLabel.setText(workState.summary());
            this.fSummaryLabel.setImage(NonPortableObjectDialog.imageFor(workState));
            this.fIssueDescription.setText(workState.descriptionFor((ApplicationEventContext)this.getNonPortableEventContext()));
            this.fActionTreeViewer.setInput((Object)workState);
            AbstractResolutionAction[] actions = this.getActions(workState);
            if (actions != null && actions.length > 0) {
                boolean showComponent = true;
                for (int i = 0; i < actions.length; ++i) {
                    AbstractResolutionAction action = actions[i];
                    if (!action.isEnabled()) continue;
                    boolean isSelected = action.isSelected();
                    this.fActionTreeViewer.setChecked((Object)action, isSelected);
                    if (!isSelected || !showComponent) continue;
                    this.fActionTreeViewer.setSelection((ISelection)new StructuredSelection((Object)action));
                    action.showControl((Object)this);
                    showComponent = false;
                }
                this.fActionTreeViewer.expandAll();
            }
            this.setNoAction(!workState.hasSelectedActions());
            if (!this.haveAnyActions()) {
                this.hideResolutionsPanel();
            }
        }
        finally {
            this.fActionTreeViewer.getTree().setRedraw(true);
        }
    }

    private boolean requiresPortabilityAction(NonPortableWorkState workState) {
        Iterator iter;
        List types;
        if (workState.isTransient() || workState.extendsLogicallyManagedType()) {
            return false;
        }
        if (workState.hasRequiredBootTypes()) {
            types = workState.getRequiredBootTypes();
            iter = types.iterator();
            while (iter.hasNext()) {
                if (this.fConfigHelper.isBootJarClass((String)iter.next())) continue;
                return true;
            }
        }
        if (workState.hasNonPortableBaseTypes()) {
            types = workState.getNonPortableBaseTypes();
            iter = types.iterator();
            while (iter.hasNext()) {
                if (this.fConfigHelper.isAdaptable((String)iter.next())) continue;
                return true;
            }
        }
        return !this.fConfigHelper.isAdaptable(workState.getTypeName());
    }

    protected AbstractResolutionAction[] createActions(AbstractWorkState workState) {
        ArrayList<NonPortableResolutionAction> list = new ArrayList<NonPortableResolutionAction>();
        if (workState instanceof NonPortableWorkState) {
            NonPortableWorkState nonPortableWorkState = (NonPortableWorkState)workState;
            String fieldName = nonPortableWorkState.getFieldName();
            if (nonPortableWorkState.isNeverPortable() || nonPortableWorkState.isPortable()) {
                if (fieldName != null && !nonPortableWorkState.isTransient() && !this.fConfigHelper.isTransient(fieldName)) {
                    list.add(new MakeTransientAction(nonPortableWorkState));
                }
            } else if (!nonPortableWorkState.isPortable()) {
                if (this.requiresPortabilityAction(nonPortableWorkState)) {
                    list.add(new MakePortableAction(nonPortableWorkState));
                }
                if (fieldName != null && !nonPortableWorkState.isTransient() && !this.fConfigHelper.isTransient(fieldName)) {
                    list.add(new MakeTransientAction(nonPortableWorkState));
                }
            }
        }
        return list.toArray(new AbstractResolutionAction[0]);
    }

    protected void updateButtons() {
        if (this.fApplyButton == null) {
            return;
        }
        this.fApplyButton.setEnabled(this.anySelectedActions());
        if (this.fPreviousIssueButton != null) {
            this.fPreviousIssueButton.setEnabled(this.getPreviousIssue() != null);
            this.fNextIssueButton.setEnabled(this.getNextIssue() != null);
        }
    }

    class IncludeTypesPanel
    extends Composite {
        org.eclipse.swt.widgets.List fIncludeTypesList;
        org.eclipse.swt.widgets.List fBootTypesList;

        IncludeTypesPanel(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)this, 0);
            label.setText(NonPortableMessages.getString((String)"TYPES_TO_INCLUDE"));
            label.setLayoutData((Object)new GridData(768));
            this.fIncludeTypesList = new org.eclipse.swt.widgets.List((Composite)this, 2560);
            this.fIncludeTypesList.setLayoutData((Object)new GridData(1808));
            label = new Label((Composite)this, 0);
            label.setText(NonPortableMessages.getString((String)"TYPES_TO_ADD_TO_BOOTJAR"));
            label.setLayoutData((Object)new GridData(768));
            this.fBootTypesList = new org.eclipse.swt.widgets.List((Composite)this, 2560);
            this.fBootTypesList.setLayoutData((Object)new GridData(1808));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setIncludeTypes(List types) {
            this.fIncludeTypesList.setRedraw(false);
            try {
                this.fIncludeTypesList.setItems(new String[0]);
                if (types != null) {
                    ConfigurationHelper configHelper = TcPlugin.getDefault().getConfigurationHelper(NonPortableObjectDialog.this.fJavaProject.getProject());
                    for (String type : types) {
                        if (configHelper.isAdaptable(type)) continue;
                        this.fIncludeTypesList.add(type);
                    }
                }
            }
            finally {
                this.fIncludeTypesList.setRedraw(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setBootTypes(List types) {
            this.fBootTypesList.setRedraw(false);
            try {
                this.fBootTypesList.setItems(new String[0]);
                if (types != null) {
                    ConfigurationHelper configHelper = TcPlugin.getDefault().getConfigurationHelper(NonPortableObjectDialog.this.fJavaProject.getProject());
                    for (String type : types) {
                        if (configHelper.isBootJarClass(type)) continue;
                        this.fBootTypesList.add(type);
                    }
                }
            }
            finally {
                this.fBootTypesList.setRedraw(true);
            }
        }
    }

    class MakePortableAction
    extends NonPortableResolutionAction {
        MakePortableAction(NonPortableWorkState workState) {
            super(workState);
        }

        public void showControl(Object parentControl) {
            NonPortableObjectDialog.this.fActionStackLayout.topControl = NonPortableObjectDialog.this.fIncludeTypesView;
            NonPortableObjectDialog.this.fIncludeTypesView.setIncludeTypes(this.fWorkState.getRequiredIncludeTypes());
            NonPortableObjectDialog.this.fIncludeTypesView.setBootTypes(this.fWorkState.getRequiredBootTypes());
            NonPortableObjectDialog.this.fActionPanel.layout();
            NonPortableObjectDialog.this.fActionPanel.redraw();
        }

        public String getText() {
            return NonPortableMessages.getString((String)"MAKE_PORTABLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean selected) {
            Iterator iter;
            List types;
            super.setSelected(selected);
            if (this.fWorkState.hasRequiredBootTypes()) {
                types = this.fWorkState.getRequiredBootTypes();
                if (selected) {
                    iter = types.iterator();
                    while (iter.hasNext()) {
                        NonPortableObjectDialog.this.fConfigHelper.ensureBootJarClass((String)iter.next(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    }
                } else {
                    iter = types.iterator();
                    while (iter.hasNext()) {
                        NonPortableObjectDialog.this.fConfigHelper.ensureNotBootJarClass((String)iter.next(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    }
                }
            }
            if (this.fWorkState.hasRequiredIncludeTypes()) {
                types = this.fWorkState.getRequiredIncludeTypes();
                if (selected) {
                    iter = types.iterator();
                    while (iter.hasNext()) {
                        NonPortableObjectDialog.this.fConfigHelper.ensureAdaptable((String)iter.next(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    }
                } else {
                    iter = types.iterator();
                    while (iter.hasNext()) {
                        NonPortableObjectDialog.this.fConfigHelper.ensureNotAdaptable((String)iter.next(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    }
                }
            }
            int index = NonPortableObjectDialog.this.fIssueTable.getSelectionIndex();
            NonPortableObjectDialog.this.fIssueTable.setRedraw(false);
            try {
                NonPortableObjectDialog.this.initIssueList();
                NonPortableObjectDialog.this.fIssueTable.setSelection(index);
            }
            finally {
                NonPortableObjectDialog.this.fIssueTable.setRedraw(true);
            }
        }
    }

    class MakeTransientAction
    extends NonPortableResolutionAction {
        MakeTransientAction(NonPortableWorkState workState) {
            super(workState);
        }

        public void showControl(Object parentControl) {
            String fieldName = this.fWorkState.getFieldName();
            String declaringType = fieldName.substring(0, fieldName.lastIndexOf(46));
            Include include = NonPortableObjectDialog.this.fConfigHelper.includeRuleFor(declaringType);
            if (include != null) {
                NonPortableObjectDialog.this.fActionStackLayout.topControl = NonPortableObjectDialog.this.fIncludeRuleView;
                NonPortableObjectDialog.this.fIncludeRuleView.setInclude(include);
                NonPortableObjectDialog.this.fActionPanel.layout();
                NonPortableObjectDialog.this.fActionPanel.redraw();
            }
        }

        public String getText() {
            return NonPortableMessages.getString((String)"DO_NOT_SHARE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean selected) {
            super.setSelected(selected);
            int index = NonPortableObjectDialog.this.fIssueTable.getSelectionIndex();
            TreeItem treeItem = NonPortableObjectDialog.this.fObjectTree.getSelection()[0];
            NonPortableObjectDialog.this.fIssueTable.setRedraw(false);
            NonPortableObjectDialog.this.fObjectTree.setRedraw(false);
            try {
                if (selected) {
                    NonPortableObjectDialog.this.fConfigHelper.ensureTransient(this.fWorkState.getFieldName(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    treeItem.removeAll();
                } else {
                    NonPortableObjectDialog.this.fConfigHelper.ensureNotTransient(this.fWorkState.getFieldName(), AbstractApplicationEventDialog.NULL_SIGNALLER);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeItem.getData();
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        TreeItem childItem = new TreeItem(treeItem, 0);
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        NonPortableObjectDialog.this.initTreeItem(childItem, childNode);
                    }
                }
                NonPortableObjectDialog.this.initIssueList();
                NonPortableObjectDialog.this.fObjectTree.setSelection(treeItem);
                NonPortableObjectDialog.this.fIssueTable.setSelection(index);
            }
            finally {
                NonPortableObjectDialog.this.fIssueTable.setRedraw(true);
                NonPortableObjectDialog.this.fObjectTree.setRedraw(true);
            }
        }
    }
}

