/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import com.tc.util.event.EventMulticaster;
import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.LockLevel;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NamedLockDialog
extends MessageDialog {
    private static final String TITLE = "Specify Named-Lock Attributes";
    private final EventMulticaster m_valueListener = new EventMulticaster();
    private Layout m_layout;

    public NamedLockDialog(Shell shell, String message) {
        super(shell, TITLE, null, message, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
    }

    public void addValueListener(UpdateEventListener listener) {
        this.m_valueListener.addListener(listener);
    }

    protected Control createCustomArea(Composite parent) {
        this.m_layout = new Layout(parent);
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String lockName = this.m_layout.m_name.getText();
            if (lockName == null || (lockName = lockName.trim()) == null || lockName.length() == 0) {
                Display.getCurrent().beep();
                this.m_layout.m_name.forceFocus();
                return;
            }
            LockLevel.Enum lockLevel = this.m_layout.m_read.getSelection() ? LockLevel.READ : (this.m_layout.m_write.getSelection() ? LockLevel.WRITE : (this.m_layout.m_synchronousWrite.getSelection() ? LockLevel.SYNCHRONOUS_WRITE : LockLevel.CONCURRENT));
            this.m_valueListener.fireUpdateEvent(new UpdateEvent((Object)new Object[]{lockName, lockLevel}));
        }
        super.buttonPressed(buttonId);
    }

    private static class Layout {
        private static final String NAME = "Name";
        private static final String TYPE = "Type";
        private static final String READ = "Read";
        private static final String WRITE = "Write";
        private static final String CONCURRENT = "Concurrent";
        private static final String SYNCHRONOUS_WRITE = "Synchronous-write";
        private final Text m_name;
        private final Button m_read;
        private final Button m_write;
        private final Button m_synchronousWrite;
        private final Button m_concurrent;

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            comp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            Group typeGroup = new Group(comp, 0);
            typeGroup.setText(TYPE);
            typeGroup.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout(4, false));
            this.m_read = new Button((Composite)typeGroup, 16);
            this.m_read.setText(READ);
            this.m_write = new Button((Composite)typeGroup, 16);
            this.m_write.setText(WRITE);
            this.m_write.setSelection(true);
            this.m_synchronousWrite = new Button((Composite)typeGroup, 16);
            this.m_synchronousWrite.setText(SYNCHRONOUS_WRITE);
            this.m_concurrent = new Button((Composite)typeGroup, 16);
            this.m_concurrent.setText(CONCURRENT);
            Group nameGroup = new Group(comp, 0);
            nameGroup.setText(NAME);
            nameGroup.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            nameGroup.setLayoutData((Object)new GridData(768));
            Label requiredLabel = new Label((Composite)nameGroup, 16384);
            requiredLabel.setText("* - required field");
            requiredLabel.setForeground(requiredLabel.getDisplay().getSystemColor(3));
            this.m_name = new Text((Composite)nameGroup, 2048);
            this.m_name.setLayoutData((Object)new GridData(768));
        }
    }
}

