/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.terracotta.ui.util.SWTUtil;

public class ExceptionDialog
extends MessageDialog {
    private final Shell m_parentShell;
    private final String m_stackTrace;

    private static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    public ExceptionDialog(Shell shell, String title, String message, Throwable throwable) {
        this(shell, title, message, ExceptionDialog.throwable2StackTrace(throwable));
    }

    public ExceptionDialog(Shell shell, String title, String message, String stackTrace) {
        super(shell, title, null, "  " + message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_parentShell = shell;
        this.m_stackTrace = stackTrace;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_parentShell != null) {
            SWTUtil.placeDialogInCenter(this.m_parentShell, shell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
        return super.createDialogArea(parent);
    }

    protected Control createCustomArea(Composite parent) {
        new Layout(parent, this.m_stackTrace);
        return parent;
    }

    private static class Layout {
        final Text m_area;

        private Layout(Composite parent, String stackTrace) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(1808));
            this.m_area = new Text(comp, 2634);
            this.m_area.setText(stackTrace);
            GridData gridData = new GridData(1808);
            gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.m_area, 120);
            gridData.heightHint = SWTUtil.textRowsToPixels((Control)this.m_area, 24);
            this.m_area.setLayoutData((Object)gridData);
        }
    }
}

