/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import com.tc.admin.common.AbstractResolutionAction;
import com.tc.admin.common.AbstractWorkState;
import com.tc.admin.common.NonPortableMessages;
import com.tc.admin.common.NonPortableWorkState;
import com.tc.object.appevent.AbstractApplicationEvent;
import com.tc.object.appevent.NonPortableObjectState;
import com.terracottatech.config.Include;
import com.terracottatech.config.OnLoad;
import com.terracottatech.config.TcConfigDocument;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.MultiChangeSignaller;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditor;
import org.terracotta.ui.util.EmptyIterator;
import org.terracotta.ui.util.SWTUtil;

public abstract class AbstractApplicationEventDialog
extends MessageDialog {
    protected IJavaProject fJavaProject;
    private final AbstractApplicationEvent fEvent;
    private final FormToolkit fFormToolkit;
    private SashForm fTopSashForm;
    private SashForm fBottomSashForm;
    protected Table fIssueTable;
    protected Tree fObjectTree;
    protected CLabel fSummaryLabel;
    private Group fDetailsPanel;
    private Group fResolutionsPanel;
    protected CheckboxTreeViewer fActionTreeViewer;
    protected Composite fActionPanel;
    protected StackLayout fActionStackLayout;
    protected IncludeRulePanel fIncludeRuleView;
    private Label fNoActionView;
    protected TcConfigDocument.TcConfig fNewConfig;
    protected ConfigurationHelper fConfigHelper;
    private static final int[] DEFAULT_TOP_SASH_WEIGHTS = new int[]{100, 100};
    private static final int[] DEFAULT_BOTTOM_SASH_WEIGHTS = new int[]{100, 100};
    private static final String DIALOG_TOP_SASH_WEIGHTS_1 = "org.terracotta.dso.DIALOG_TOP_SASH_WEIGHTS_1";
    private static final String DIALOG_TOP_SASH_WEIGHTS_2 = "org.terracotta.dso.DIALOG_TOP_SASH_WEIGHTS_2";
    private static final String DIALOG_BOTTOM_SASH_WEIGHTS_1 = "org.terracotta.dso.DIALOG_BOTTOM_SASH_WEIGHTS_1";
    private static final String DIALOG_BOTTOM_SASH_WEIGHTS_2 = "org.terracotta.dso.DIALOG_BOTTOM_SASH_WEIGHTS_2";
    protected static final Image NOT_PORTABLE_ICON = TcPlugin.createImage(AbstractApplicationEventDialog.class.getResource("/com/tc/admin/icons/field_private_obj.gif"));
    protected static final Image NEVER_PORTABLE_ICON = TcPlugin.createImage(AbstractApplicationEventDialog.class.getResource("/com/tc/admin/icons/field_private_obj.gif"));
    protected static final Image TRANSIENT_ICON = TcPlugin.createImage(AbstractApplicationEventDialog.class.getResource("/com/tc/admin/icons/field_public_obj.gif"));
    protected static final Image PORTABLE_ICON = TcPlugin.createImage(AbstractApplicationEventDialog.class.getResource("/com/tc/admin/icons/field_default_obj.gif"));
    protected static final Image PRE_INSTRUMENTED_ICON = TcPlugin.createImage(AbstractApplicationEventDialog.class.getResource("/com/tc/admin/icons/field_protected_obj.gif"));
    protected static final Image OBJ_CYCLE_ICON = TcPlugin.createImage("/images/eclipse/obj_cycle.gif");
    protected static final Image RESOLVED_ICON = TcPlugin.createImage("/images/eclipse/nature.gif");
    protected static final Image HELP_ICON = TcPlugin.createImage("/images/eclipse/help.gif");
    protected static final String EMPTY_STRING = "";
    protected static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    protected static final MultiChangeSignaller NULL_SIGNALLER = new MultiChangeSignaller(){

        public void signal(IProject project) {
        }
    };
    protected static final Image BLANK_ICON;
    protected static final Object NO_ACTION_ITEM;

    public AbstractApplicationEventDialog(Shell parentShell, String dialogTitle, AbstractApplicationEvent event, String[] buttonLabels, int defaultButtonIndex) {
        super(parentShell, dialogTitle, null, event.getMessage(), 1, buttonLabels, defaultButtonIndex);
        this.setShellStyle(0x860 | AbstractApplicationEventDialog.getDefaultOrientation() | 0x10);
        this.fEvent = event;
        this.fJavaProject = this.getJavaProject(this.fEvent);
        this.fNewConfig = (TcConfigDocument.TcConfig)TcPlugin.getDefault().getConfiguration(this.fJavaProject.getProject()).copy();
        this.fConfigHelper = new ConfigHelper();
        this.fFormToolkit = new FormToolkit(parentShell.getDisplay());
        this.fFormToolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
    }

    public AbstractApplicationEvent getApplicationEvent() {
        return this.fEvent;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected FormToolkit getFormToolkit() {
        return this.fFormToolkit;
    }

    protected void initializeBounds() {
        int w2;
        int w1;
        IDialogSettings settings = this.getDialogSettings();
        if (this.fTopSashForm != null) {
            try {
                w1 = settings.getInt(DIALOG_TOP_SASH_WEIGHTS_1);
                w2 = settings.getInt(DIALOG_TOP_SASH_WEIGHTS_2);
            }
            catch (NumberFormatException nfe) {
                w1 = DEFAULT_TOP_SASH_WEIGHTS[0];
                w2 = DEFAULT_TOP_SASH_WEIGHTS[1];
            }
            this.fTopSashForm.setWeights(new int[]{w1, w2});
        }
        if (this.fBottomSashForm != null) {
            try {
                w1 = settings.getInt(DIALOG_BOTTOM_SASH_WEIGHTS_1);
                w2 = settings.getInt(DIALOG_BOTTOM_SASH_WEIGHTS_2);
            }
            catch (NumberFormatException nfe) {
                w1 = DEFAULT_BOTTOM_SASH_WEIGHTS[0];
                w2 = DEFAULT_BOTTOM_SASH_WEIGHTS[1];
            }
            this.fBottomSashForm.setWeights(new int[]{w1, w2});
        }
        super.initializeBounds();
    }

    protected void persistSashWeights() {
        int[] sashWeights;
        IDialogSettings settings = this.getDialogSettings();
        if (this.fTopSashForm != null) {
            sashWeights = this.fTopSashForm.getWeights();
            settings.put(DIALOG_TOP_SASH_WEIGHTS_1, sashWeights[0]);
            settings.put(DIALOG_TOP_SASH_WEIGHTS_2, sashWeights[1]);
        }
        if (this.fBottomSashForm != null) {
            sashWeights = this.fTopSashForm.getWeights();
            settings.put(DIALOG_BOTTOM_SASH_WEIGHTS_1, sashWeights[0]);
            settings.put(DIALOG_BOTTOM_SASH_WEIGHTS_2, sashWeights[1]);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = TcPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    public boolean close() {
        this.persistSashWeights();
        return super.close();
    }

    private IJavaProject getJavaProject(AbstractApplicationEvent event) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String name = event.getApplicationEventContext().getProjectName();
        return JavaCore.create((IProject)workspaceRoot.getProject(name));
    }

    protected Control createCustomArea(Composite parent) {
        this.fFormToolkit.setBackground(parent.getBackground());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm(composite, 65536);
        sash.setOrientation(256);
        sash.setLayoutData((Object)new GridData(1808));
        sash.setFont(parent.getFont());
        sash.setVisible(true);
        this.fTopSashForm = sash;
        Group listGroup = new Group((Composite)sash, 32);
        listGroup.setText(NonPortableMessages.getString((String)"ISSUES"));
        listGroup.setLayout((Layout)new GridLayout());
        listGroup.setLayoutData((Object)new GridData(1808));
        this.fIssueTable = new Table((Composite)listGroup, 2564);
        this.fIssueTable.addSelectionListener((SelectionListener)new IssueTableSelectionListener());
        GridData gridData = new GridData(1808);
        gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.fIssueTable, 60);
        gridData.heightHint = SWTUtil.tableRowsToPixels(this.fIssueTable, 10);
        this.fIssueTable.setLayoutData((Object)gridData);
        Group treePanel = new Group((Composite)sash, 32);
        treePanel.setText(NonPortableMessages.getString((String)"OBJECT_BROWSER"));
        treePanel.setLayout((Layout)new GridLayout());
        treePanel.setLayoutData((Object)new GridData(1808));
        this.fObjectTree = new Tree((Composite)treePanel, 2820);
        this.fObjectTree.setLayoutData((Object)new GridData(1808));
        this.fObjectTree.addSelectionListener((SelectionListener)new IssueTreeSelectionListener());
        this.fDetailsPanel = new Group(composite, 32);
        this.fDetailsPanel.setText(NonPortableMessages.getString((String)"ISSUE_DETAILS"));
        this.fDetailsPanel.setLayout((Layout)new GridLayout());
        this.fDetailsPanel.setLayoutData((Object)new GridData(1808));
        this.fSummaryLabel = new CLabel((Composite)this.fDetailsPanel, 0);
        this.fSummaryLabel.setLayoutData((Object)new GridData(768));
        this.createIssueDescriptionArea((Composite)this.fDetailsPanel);
        this.fResolutionsPanel = new Group(composite, 32);
        this.fResolutionsPanel.setText(NonPortableMessages.getString((String)"RESOLUTIONS"));
        this.fResolutionsPanel.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fResolutionsPanel.setLayoutData((Object)gridData);
        sash = new SashForm((Composite)this.fResolutionsPanel, 65536);
        sash.setOrientation(256);
        sash.setLayoutData((Object)new GridData(1808));
        sash.setFont(parent.getFont());
        sash.setVisible(true);
        this.fBottomSashForm = sash;
        Group actionGroup = new Group((Composite)sash, 0);
        actionGroup.setText(NonPortableMessages.getString((String)"ACTIONS"));
        actionGroup.setLayout((Layout)new GridLayout());
        actionGroup.setLayoutData((Object)new GridData(1808));
        this.fActionTreeViewer = new CheckboxTreeViewer((Composite)actionGroup, 2820);
        this.fActionTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.fActionTreeViewer.addCheckStateListener((ICheckStateListener)new ActionCheckStateHandler());
        this.fActionTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ActionSelectionChangedHandler());
        this.fActionTreeViewer.setContentProvider((IContentProvider)new ActionTreeContentProvider());
        this.fActionTreeViewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        Group actionPanelGroup = new Group((Composite)sash, 32);
        actionPanelGroup.setText(NonPortableMessages.getString((String)"SELECTED_ACTION"));
        actionPanelGroup.setLayout((Layout)new GridLayout());
        actionPanelGroup.setLayoutData((Object)new GridData(1808));
        this.fActionPanel = new Composite((Composite)actionPanelGroup, 0);
        this.fActionPanel.setLayoutData((Object)new GridData(1808));
        this.fActionStackLayout = new StackLayout();
        this.fActionPanel.setLayout((Layout)this.fActionStackLayout);
        this.fIncludeRuleView = new IncludeRulePanel(this.fActionPanel);
        this.fNoActionView = new Label(this.fActionPanel, 0);
        this.fActionStackLayout.topControl = this.fNoActionView;
        this.populateTree();
        this.initIssueList();
        if (this.fIssueTable.getItemCount() > 0) {
            this.fIssueTable.setSelection(0);
            this.handleTableSelectionChange();
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.cancelPressed();
                break;
            }
            case 1: {
                this.apply();
                this.okPressed();
            }
        }
    }

    protected void apply() {
        TcPlugin plugin = TcPlugin.getDefault();
        TcConfigDocument configDoc = TcConfigDocument.Factory.newInstance();
        configDoc.setTcConfig(this.fNewConfig);
        try {
            IProject project = this.fJavaProject.getProject();
            plugin.setConfigurationFromString(project, plugin.configDocumentAsString(configDoc));
            ConfigurationEditor configEditor = plugin.getConfigurationEditor(project);
            if (configEditor == null) {
                plugin.saveConfiguration(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Image imageFor(AbstractWorkState workState) {
        if (workState instanceof NonPortableWorkState) {
            NonPortableWorkState nonPortableWorkState = (NonPortableWorkState)workState;
            if (nonPortableWorkState.isRepeated()) {
                return OBJ_CYCLE_ICON;
            }
            if (nonPortableWorkState.isPreInstrumented()) {
                return PRE_INSTRUMENTED_ICON;
            }
            if (nonPortableWorkState.isNeverPortable()) {
                return NEVER_PORTABLE_ICON;
            }
            if (!nonPortableWorkState.isPortable()) {
                return NOT_PORTABLE_ICON;
            }
            if (nonPortableWorkState.isTransient()) {
                return TRANSIENT_ICON;
            }
            return PORTABLE_ICON;
        }
        return null;
    }

    protected void initTreeItem(TreeItem item, DefaultMutableTreeNode node) {
        item.setData((Object)node);
        String text = null;
        Image image = PORTABLE_ICON;
        Object userObject = node.getUserObject();
        if (userObject instanceof NonPortableObjectState) {
            userObject = new NonPortableWorkState((NonPortableObjectState)userObject);
            node.setUserObject(userObject);
        }
        if (userObject instanceof NonPortableWorkState) {
            NonPortableWorkState workState = (NonPortableWorkState)userObject;
            text = workState.getLabel();
            image = AbstractApplicationEventDialog.imageFor((AbstractWorkState)workState);
        }
        item.setText(text != null ? text : userObject.toString());
        item.setImage(image);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeItem childItem = new TreeItem(item, 0);
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            this.initTreeItem(childItem, childNode);
        }
    }

    void populateTree() {
        DefaultTreeModel treeModel = this.fEvent.getApplicationEventContext().getTreeModel();
        if (treeModel != null) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeItem item = new TreeItem(this.fObjectTree, 0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                this.initTreeItem(item, node);
            }
        }
    }

    private void handleTableSelectionChange() {
        TableItem[] selection = this.fIssueTable.getSelection();
        if (selection.length > 0) {
            TreeItem treeItem = (TreeItem)selection[0].getData();
            this.fObjectTree.setSelection(treeItem);
            this.handleTreeSelectionChange();
        }
    }

    protected void hideResolutionsPanel() {
        this.fResolutionsPanel.setVisible(false);
    }

    protected void showResolutionsPanel() {
        this.fResolutionsPanel.setVisible(true);
    }

    protected AbstractResolutionAction[] getActions(AbstractWorkState state) {
        AbstractResolutionAction[] actions = state.getActions();
        if (actions == null) {
            actions = this.createActions(state);
            state.setActions(actions);
        }
        return actions;
    }

    private void handleActionSelectionChanged(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj == NO_ACTION_ITEM) {
            this.hideActionPanel();
        } else {
            AbstractResolutionAction action = (AbstractResolutionAction)obj;
            if (action != null) {
                if (action.isSelected()) {
                    action.showControl((Object)this);
                } else {
                    this.hideActionPanel();
                }
            }
        }
    }

    protected boolean haveAnyActions() {
        ActionTreeContentProvider contentProvider = (ActionTreeContentProvider)this.fActionTreeViewer.getContentProvider();
        AbstractResolutionAction[] actions = contentProvider.getEnabledActions();
        return actions != null && actions.length > 0;
    }

    protected boolean anyActionSelected() {
        ActionTreeContentProvider contentProvider = (ActionTreeContentProvider)this.fActionTreeViewer.getContentProvider();
        AbstractResolutionAction[] actions = contentProvider.getEnabledActions();
        if (actions != null) {
            for (AbstractResolutionAction action : actions) {
                if (!action.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    protected void setNoAction(boolean checked) {
        this.fActionTreeViewer.setChecked(NO_ACTION_ITEM, checked);
        this.fIssueTable.getSelection()[0].setImage(checked ? BLANK_ICON : RESOLVED_ICON);
    }

    private boolean isSetNoAction() {
        return this.fActionTreeViewer.getChecked(NO_ACTION_ITEM);
    }

    protected void updateButtons() {
    }

    protected void hideActionPanel() {
        this.fActionStackLayout.topControl = this.fNoActionView;
        this.fActionPanel.layout();
        this.fActionPanel.redraw();
    }

    private void handleNoActionItemSelected() {
        if (this.isSetNoAction()) {
            AbstractResolutionAction[] actions;
            this.hideActionPanel();
            ActionTreeContentProvider contentProvider = (ActionTreeContentProvider)this.fActionTreeViewer.getContentProvider();
            for (AbstractResolutionAction action : actions = contentProvider.getEnabledActions()) {
                action.setSelected(false);
                this.fActionTreeViewer.setChecked((Object)action, false);
            }
            TableItem[] selection = this.fIssueTable.getSelection();
            if (selection.length > 0) {
                selection[0].setImage(BLANK_ICON);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Include ensureIncludeRuleFor(String classExpr) {
        Include include = this.fConfigHelper.includeRuleFor(classExpr);
        if (include == null) {
            include = this.fConfigHelper.addIncludeRule(classExpr);
        }
        return include;
    }

    protected abstract String getDialogSettingsSectionName();

    protected abstract void initIssueList();

    protected abstract AbstractResolutionAction[] createActions(AbstractWorkState var1);

    protected abstract boolean anySelectedActions();

    protected abstract void handleTreeSelectionChange();

    protected abstract void createIssueDescriptionArea(Composite var1);

    static {
        ImageData blankImageData = new ImageData(16, 16, 1, new PaletteData(new RGB[]{new RGB(255, 0, 0)}));
        blankImageData.transparentPixel = 0;
        BLANK_ICON = ImageDescriptor.createFromImageData((ImageData)blankImageData).createImage();
        NO_ACTION_ITEM = new Object();
    }

    protected class IncludeRulePanel
    extends Composite
    implements SelectionListener {
        Button honorTransientButton;
        Button doNothingButton;
        Button callMethodButton;
        Button executeCodeButton;
        Text includePatternText;
        Text executeCodeText;
        Combo callMethodCombo;
        Include include;

        IncludeRulePanel(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            CLabel label = new CLabel((Composite)this, 0);
            label.setText(NonPortableMessages.getString((String)"INCLUDE_PATTERN"));
            this.includePatternText = new Text((Composite)this, 2056);
            this.includePatternText.setLayoutData((Object)new GridData(768));
            this.honorTransientButton = new Button((Composite)this, 32);
            this.honorTransientButton.setText(NonPortableMessages.getString((String)"HONOR_TRANSIENT"));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.honorTransientButton.setLayoutData((Object)gridData);
            this.honorTransientButton.addSelectionListener((SelectionListener)this);
            Group onLoadGroup = new Group((Composite)this, 0x400020);
            onLoadGroup.setText(NonPortableMessages.getString((String)"ON_LOAD"));
            onLoadGroup.setLayout((Layout)new GridLayout(2, false));
            this.doNothingButton = new Button((Composite)onLoadGroup, 16);
            this.doNothingButton.setText(NonPortableMessages.getString((String)"DO_NOTHING"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.doNothingButton.setLayoutData((Object)gridData);
            this.doNothingButton.addSelectionListener((SelectionListener)this);
            this.callMethodButton = new Button((Composite)onLoadGroup, 16);
            this.callMethodButton.setText(NonPortableMessages.getString((String)"CALL_METHOD"));
            this.callMethodButton.setLayoutData((Object)new GridData(1, 1, false, false));
            this.callMethodButton.addSelectionListener((SelectionListener)this);
            this.callMethodCombo = new Combo((Composite)onLoadGroup, 2048);
            this.callMethodCombo.setLayoutData((Object)new GridData(768));
            this.callMethodCombo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    OnLoad onLoad = IncludeRulePanel.this.include.getOnLoad();
                    onLoad.setMethod(IncludeRulePanel.this.callMethodCombo.getText());
                }
            });
            this.executeCodeButton = new Button((Composite)onLoadGroup, 16);
            this.executeCodeButton.setText(NonPortableMessages.getString((String)"EXECUTE_CODE"));
            this.executeCodeButton.setLayoutData((Object)new GridData(1, 1, false, false));
            this.executeCodeButton.addSelectionListener((SelectionListener)this);
            this.executeCodeText = new Text((Composite)onLoadGroup, 2626);
            gridData = new GridData(1808);
            gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.executeCodeText, 60);
            gridData.heightHint = SWTUtil.textRowsToPixels((Control)this.executeCodeText, 3);
            this.executeCodeText.setLayoutData((Object)gridData);
            this.executeCodeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (IncludeRulePanel.this.include == null) {
                        return;
                    }
                    OnLoad onLoad = IncludeRulePanel.this.include.getOnLoad();
                    if (onLoad == null) {
                        return;
                    }
                    String executeText = IncludeRulePanel.this.executeCodeText.getText();
                    onLoad.setExecute(executeText);
                }
            });
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            onLoadGroup.setLayoutData((Object)gridData);
        }

        void setInclude(Include include) {
            this.include = include;
            this.includePatternText.setText(include.getClassExpression());
            this.honorTransientButton.setSelection(include.getHonorTransient());
            OnLoad onLoad = include.getOnLoad();
            if (onLoad != null) {
                if (onLoad.isSetExecute()) {
                    this.setExecuteCode();
                } else if (onLoad.isSetMethod()) {
                    this.setCallMethod();
                }
            } else {
                this.setDoNothing();
            }
        }

        private void setExecuteCode() {
            OnLoad onLoad = this.include.getOnLoad();
            this.executeCodeButton.setSelection(true);
            this.executeCodeText.setEnabled(true);
            this.executeCodeText.setText(onLoad != null && onLoad.isSetExecute() ? onLoad.getExecute() : AbstractApplicationEventDialog.EMPTY_STRING);
            this.doNothingButton.setSelection(false);
            this.callMethodButton.setSelection(false);
            this.callMethodCombo.setEnabled(false);
            this.callMethodCombo.setText(AbstractApplicationEventDialog.EMPTY_STRING);
        }

        private void setCallMethod() {
            OnLoad onLoad = this.include.getOnLoad();
            this.executeCodeButton.setSelection(false);
            this.executeCodeText.setEnabled(false);
            this.executeCodeText.setText(AbstractApplicationEventDialog.EMPTY_STRING);
            this.doNothingButton.setSelection(false);
            this.callMethodButton.setSelection(true);
            this.callMethodCombo.setEnabled(true);
            this.initMethodCombo();
            this.callMethodCombo.setText(onLoad != null && onLoad.isSetMethod() ? onLoad.getMethod() : AbstractApplicationEventDialog.EMPTY_STRING);
        }

        private void setDoNothing() {
            this.executeCodeButton.setSelection(false);
            this.executeCodeText.setEnabled(false);
            this.executeCodeText.setText(AbstractApplicationEventDialog.EMPTY_STRING);
            this.doNothingButton.setSelection(true);
            this.callMethodButton.setSelection(false);
            this.callMethodCombo.setEnabled(false);
            this.callMethodCombo.setText(AbstractApplicationEventDialog.EMPTY_STRING);
        }

        private void initMethodCombo() {
            this.callMethodCombo.removeAll();
            try {
                IType type = AbstractApplicationEventDialog.this.fJavaProject.findType(this.include.getClassExpression());
                if (type != null) {
                    IMethod[] methods;
                    for (IMethod method : methods = type.getMethods()) {
                        if (method.getParameterNames().length != 0) continue;
                        this.callMethodCombo.add(method.getElementName());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            OnLoad onLoad = this.include.getOnLoad();
            if (e.widget == this.doNothingButton && this.doNothingButton.getSelection()) {
                this.setDoNothing();
                this.include.unsetOnLoad();
            } else if (e.widget == this.executeCodeButton && this.executeCodeButton.getSelection()) {
                this.setExecuteCode();
                if (onLoad != null) {
                    onLoad.unsetMethod();
                } else {
                    this.include.addNewOnLoad();
                }
            } else if (e.widget == this.callMethodButton && this.callMethodButton.getSelection()) {
                this.setCallMethod();
                if (onLoad != null) {
                    onLoad.unsetExecute();
                } else {
                    this.include.addNewOnLoad();
                }
            } else if (e.widget == this.honorTransientButton) {
                this.include.setHonorTransient(this.honorTransientButton.getSelection());
            }
        }
    }

    private static class ActionLabelProvider
    implements ILabelProvider {
        private ActionLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NO_ACTION_ITEM) {
                return NonPortableMessages.getString((String)"TAKE_NO_ACTION");
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ActionTreeContentProvider
    implements ITreeContentProvider {
        AbstractWorkState fWorkState;
        AbstractResolutionAction[] fEnabledActions;

        ActionTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fWorkState = (AbstractWorkState)newInput;
            this.fEnabledActions = null;
            if (this.fWorkState != null) {
                ArrayList<AbstractResolutionAction> list = new ArrayList<AbstractResolutionAction>();
                AbstractResolutionAction[] actions = AbstractApplicationEventDialog.this.getActions(this.fWorkState);
                if (actions != null && actions.length > 0) {
                    for (AbstractResolutionAction action : actions) {
                        if (!action.isEnabled()) continue;
                        list.add(action);
                    }
                }
                this.fEnabledActions = list.toArray(new AbstractResolutionAction[0]);
            }
        }

        public AbstractResolutionAction[] getEnabledActions() {
            return this.fEnabledActions;
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement == NO_ACTION_ITEM ? this.fEnabledActions : null;
        }

        public Object getParent(Object element) {
            return element != NO_ACTION_ITEM ? NO_ACTION_ITEM : null;
        }

        public boolean hasChildren(Object element) {
            return element == NO_ACTION_ITEM;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{NO_ACTION_ITEM};
        }

        public void dispose() {
        }
    }

    class ActionCheckStateHandler
    implements ICheckStateListener {
        ActionCheckStateHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object obj = event.getElement();
            if (obj == NO_ACTION_ITEM) {
                AbstractApplicationEventDialog.this.handleNoActionItemSelected();
            } else {
                AbstractResolutionAction action = (AbstractResolutionAction)obj;
                if (action != null) {
                    boolean isChecked = AbstractApplicationEventDialog.this.fActionTreeViewer.getChecked((Object)action);
                    action.setSelected(isChecked);
                    if (isChecked) {
                        AbstractApplicationEventDialog.this.setNoAction(false);
                    } else if (!AbstractApplicationEventDialog.this.anyActionSelected()) {
                        AbstractApplicationEventDialog.this.setNoAction(true);
                    }
                }
            }
            StructuredSelection newSelection = new StructuredSelection(obj);
            AbstractApplicationEventDialog.this.fActionTreeViewer.setSelection((ISelection)newSelection);
            AbstractApplicationEventDialog.this.handleActionSelectionChanged((IStructuredSelection)newSelection);
            AbstractApplicationEventDialog.this.updateButtons();
        }
    }

    class ActionSelectionChangedHandler
    implements ISelectionChangedListener {
        ActionSelectionChangedHandler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            AbstractApplicationEventDialog.this.handleActionSelectionChanged(selection);
        }
    }

    class IssueTreeSelectionListener
    extends SelectionAdapter {
        IssueTreeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractApplicationEventDialog.this.handleTreeSelectionChange();
        }
    }

    class IssueTableSelectionListener
    extends SelectionAdapter {
        IssueTableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractApplicationEventDialog.this.handleTableSelectionChange();
        }
    }

    class ConfigHelper
    extends ConfigurationHelper {
        ConfigHelper() {
            super(AbstractApplicationEventDialog.this.fJavaProject.getProject());
        }

        public TcConfigDocument.TcConfig getConfig() {
            return AbstractApplicationEventDialog.this.fNewConfig;
        }
    }
}

