/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.correction;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.correction.BaseMarkerResolution;
import org.terracotta.dso.correction.EnsureNotLockedResolution;
import org.terracotta.dso.correction.EnsureNotRootResolution;
import org.terracotta.dso.correction.EnsureNotTransientResolution;
import org.terracotta.dso.correction.InstrumentDeclaringTypeResolution;

public class NotInstrumentedResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static TcPlugin m_plugin = TcPlugin.getDefault();
    private IJavaElement m_element;
    private static final String MARKER_ID = "org.terracotta.dso.DeclaringTypeNotInstrumentedMarker";

    public boolean hasResolutions(IMarker marker) {
        try {
            return marker.getType().equals(MARKER_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IJavaElement getSelectedElement() {
        try {
            ITextEditor editor = ActionUtil.findSelectedTextEditor();
            if (editor != null) {
                return JdtUtils.getElementAtOffset(editor);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<BaseMarkerResolution> list = new ArrayList<BaseMarkerResolution>();
        this.m_element = this.getSelectedElement();
        if (this.m_element != null) {
            IJavaProject javaProject = this.m_element.getJavaProject();
            IProject project = javaProject.getProject();
            list.add(new InstrumentDeclaringTypeResolution(this.m_element));
            if (this.m_element.getElementType() == 8) {
                IField field = (IField)this.m_element;
                if (m_plugin.getConfigurationHelper(project).isRoot(field)) {
                    list.add(new EnsureNotRootResolution((IField)this.m_element));
                } else if (m_plugin.getConfigurationHelper(project).isTransient(field)) {
                    list.add(new EnsureNotTransientResolution((IField)this.m_element));
                }
            } else if (this.m_element.getElementType() == 9) {
                list.add(new EnsureNotLockedResolution((IMethod)this.m_element));
            }
        }
        return list.toArray(new IMarkerResolution[0]);
    }
}

