/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.IProjectAction;

public class WorkbenchNatureAction
implements IActionDelegate,
IWorkbenchWindowActionDelegate,
IProjectAction {
    private IJavaProject m_javaProject;
    private boolean m_addNature;
    private IAction m_action;

    public WorkbenchNatureAction() {
        TcPlugin.getDefault().registerProjectAction(this);
    }

    public void run(IAction action) {
        TcPlugin plugin = TcPlugin.getDefault();
        if (this.m_addNature) {
            plugin.addTerracottaNature(this.m_javaProject);
        } else {
            plugin.removeTerracottaNature(this.m_javaProject);
        }
        this.update(this.m_javaProject);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_action = action;
        if (this.m_javaProject == null || selection instanceof IStructuredSelection) {
            this.update(ActionUtil.locateSelectedJavaProject(selection));
        } else {
            action.setEnabled(true);
        }
    }

    private void update(IJavaProject javaProject) {
        this.m_javaProject = javaProject;
        if (this.m_javaProject != null) {
            String text;
            try {
                IProject project = javaProject.getProject();
                if (!project.isOpen()) {
                    this.m_action.setText("Add Terracotta Nature...");
                    this.m_action.setEnabled(false);
                    return;
                }
                if (project.hasNature(ProjectNature.NATURE_ID)) {
                    this.m_addNature = false;
                    text = "Remove Terracotta Nature";
                } else {
                    this.m_addNature = true;
                    text = "Add Terracotta Nature...";
                }
            }
            catch (Exception ce) {
                ce.printStackTrace();
                this.m_action.setEnabled(false);
                return;
            }
            this.m_action.setText(text);
            this.m_action.setEnabled(true);
        } else {
            this.m_action.setEnabled(false);
        }
    }

    public void update(IProject project) {
        this.update(ActionUtil.findJavaProject(project));
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

