/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.IProjectAction;

public class ShowConfigEditorAction
extends Action
implements IActionDelegate,
IWorkbenchWindowActionDelegate,
IJavaLaunchConfigurationConstants,
IProjectAction {
    private IJavaProject m_javaProject;
    private IAction m_action;

    public ShowConfigEditorAction() {
        super("Open config editor");
        TcPlugin.getDefault().registerProjectAction(this);
    }

    public ShowConfigEditorAction(IJavaProject javaProject) {
        super("Open config editor");
        this.m_javaProject = javaProject;
    }

    public void run(IAction action) {
        TcPlugin plugin = TcPlugin.getDefault();
        try {
            plugin.openConfigurationEditor(this.m_javaProject.getProject());
        }
        catch (PartInitException pie) {
            plugin.openError("Unable to open config editor", pie);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_action = action;
        if (this.m_javaProject == null || selection instanceof IStructuredSelection) {
            this.update(ActionUtil.locateSelectedJavaProject(selection));
        } else {
            action.setEnabled(true);
        }
    }

    private void update(IJavaProject javaProject) {
        block5: {
            if (javaProject != null) {
                try {
                    if (javaProject.getProject().hasNature(ProjectNature.NATURE_ID)) {
                        this.m_javaProject = javaProject;
                        break block5;
                    }
                    this.m_javaProject = null;
                }
                catch (CoreException coreException) {}
            } else {
                this.m_javaProject = null;
            }
        }
        this.m_action.setEnabled(this.m_javaProject != null);
    }

    public void update(IProject project) {
        this.update(ActionUtil.findJavaProject(project));
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

