/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import com.tc.admin.common.InputStreamDrainer;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.terracotta.dso.ClasspathProvider;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.IProjectAction;

public class ShowAdminConsoleAction
extends Action
implements IActionDelegate,
IWorkbenchWindowActionDelegate,
IJavaLaunchConfigurationConstants,
IProjectAction {
    private IJavaProject m_javaProject;
    private IAction m_action;

    public ShowAdminConsoleAction() {
        super("Show Developer Console...");
        TcPlugin.getDefault().registerProjectAction(this);
    }

    public ShowAdminConsoleAction(IJavaProject javaProject) {
        super("Show Developer Console...");
        this.m_javaProject = javaProject;
    }

    public void run(IAction action) {
        String[] cmdarray = new String[]{this.getJavaCmd().getAbsolutePath(), "-Dtc.install-root=" + TcPlugin.getDefault().getLocation().toOSString(), "-cp", this.getClasspath(), "com.tc.admin.AdminClient"};
        Process p = this.exec(cmdarray, null, new File(System.getProperty("user.dir")));
        new InputStreamDrainer(p.getErrorStream()).start();
        new InputStreamDrainer(p.getInputStream()).start();
        IOUtils.closeQuietly((OutputStream)p.getOutputStream());
    }

    private String locateSvtJar() {
        File tcLibDir = null;
        IPath tcLibPath = TcPlugin.getDefault().getLibDirPath();
        IPath tcJarPath = tcLibPath.append("tc.jar");
        if (tcJarPath.toFile().exists()) {
            tcLibDir = tcLibPath.toFile();
        } else {
            String installRoot = System.getProperty("tc.install-root");
            if (installRoot != null) {
                tcLibDir = new File(installRoot, "lib");
            }
        }
        if (tcLibDir == null) {
            return null;
        }
        String[] files = tcLibDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("svt");
            }
        });
        if (files != null && files.length > 0) {
            File svtJar = new File(tcLibDir, files[files.length - 1]);
            return svtJar.getAbsolutePath();
        }
        return null;
    }

    private String getClasspath() {
        String result = null;
        TcPlugin plugin = TcPlugin.getDefault();
        IPath tcJarPath = plugin.getLibDirPath().append("tc.jar");
        result = tcJarPath.toFile().exists() ? tcJarPath.toOSString() : ClasspathProvider.makeDevClasspath();
        String svtJar = this.locateSvtJar();
        if (svtJar != null) {
            result = result + System.getProperty("path.separator") + svtJar;
        }
        return result;
    }

    private File getJavaCmd() {
        File javaBin = new File(System.getProperty("java.home"), "bin");
        return new File(javaBin, "java" + (Os.isWindows() ? ".exe" : ""));
    }

    protected Process exec(String[] cmdarray, String[] envp, File dir) {
        try {
            return Runtime.getRuntime().exec(cmdarray, envp, dir);
        }
        catch (IOException ioe) {
            TcPlugin.getDefault().openError("Unable to show Developer Console", ioe);
            return null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_action = action;
        if (this.m_javaProject == null || selection instanceof IStructuredSelection) {
            this.update(ActionUtil.locateSelectedJavaProject(selection));
        } else {
            action.setEnabled(true);
        }
    }

    private void update(IJavaProject javaProject) {
        block5: {
            if (javaProject != null) {
                try {
                    if (javaProject.getProject().hasNature(ProjectNature.NATURE_ID)) {
                        this.m_javaProject = javaProject;
                        break block5;
                    }
                    this.m_javaProject = null;
                }
                catch (CoreException coreException) {}
            } else {
                this.m_javaProject = null;
            }
        }
        this.m_action.setEnabled(this.m_javaProject != null);
    }

    public void update(IProject project) {
        this.update(ActionUtil.findJavaProject(project));
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

