/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class RootFieldAction
extends BaseAction {
    private IField m_field;

    public RootFieldAction() {
        super("Shared root", 2);
    }

    public void setField(IField field) {
        this.m_field = field;
        this.setJavaElement((IJavaElement)this.m_field);
        this.setChecked(this.getConfigHelper().isRoot(this.m_field));
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        RootOperation operation = new RootOperation(this.m_field, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing RootOperation", ee);
        }
    }

    class RootOperation
    extends AbstractOperation {
        private final IField fField;
        private final boolean fMakeRoot;

        public RootOperation(IField field, boolean makeRoot) {
            super("");
            this.fField = field;
            this.fMakeRoot = makeRoot;
            if (this.fMakeRoot) {
                this.setLabel("Add Shared Root");
            } else {
                this.setLabel("Remove Shared Root");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = RootFieldAction.this.getConfigHelper();
            if (this.fMakeRoot) {
                helper.ensureRoot(this.fField);
            } else {
                helper.ensureNotRoot(this.fField);
            }
            RootFieldAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = RootFieldAction.this.getConfigHelper();
            if (this.fMakeRoot) {
                helper.ensureNotRoot(this.fField);
            } else {
                helper.ensureRoot(this.fField);
            }
            RootFieldAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

