/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.BaseMenuCreator;
import org.terracotta.dso.actions.IProjectAction;
import org.terracotta.dso.actions.ManageServerAction;

public class ManageServerHandler
extends BaseMenuCreator
implements IProjectAction {
    private IJavaProject m_javaProject;

    public ManageServerHandler() {
        TcPlugin.getDefault().registerProjectAction(this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.m_element = this.getElement(selection);
        action.setEnabled(this.m_element != null);
    }

    protected IJavaElement getJavaElement(ISelection selection) {
        this.update(ActionUtil.locateSelectedJavaProject(selection));
        return this.m_javaProject;
    }

    private void update(IJavaProject javaProject) {
        block5: {
            if (javaProject != null) {
                try {
                    if (javaProject.getProject().hasNature(ProjectNature.NATURE_ID)) {
                        this.m_javaProject = javaProject;
                        break block5;
                    }
                    this.m_javaProject = null;
                }
                catch (CoreException coreException) {}
            } else {
                this.m_javaProject = null;
            }
        }
    }

    public void update(IProject project) {
        this.update(ActionUtil.findJavaProject(project));
        if (this.m_delegateAction != null) {
            this.m_delegateAction.setEnabled(this.m_javaProject != null);
        }
    }

    public Menu getMenu(Control parent) {
        Menu menu = null;
        menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = null;
        menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    protected void fillMenu(Menu menu) {
        if (this.m_javaProject != null) {
            IProject project;
            TcPlugin plugin = TcPlugin.getDefault();
            ConfigurationHelper configHelper = plugin.getConfigurationHelper(project = this.m_javaProject.getProject());
            Servers servers = configHelper.getServers();
            if (servers == null) {
                this.m_delegateAction.setEnabled(true);
                this.addMenuAction(menu, (IAction)new ManageServerAction(this.m_javaProject));
            } else {
                Server[] serverArray = servers.getServerArray();
                this.m_delegateAction.setEnabled(true);
                if (serverArray != null) {
                    for (int i = 0; i < serverArray.length; ++i) {
                        this.addMenuAction(menu, (IAction)new ManageServerAction(this.m_javaProject, serverArray[i]));
                    }
                } else {
                    this.m_delegateAction.setEnabled(false);
                }
            }
        }
    }
}

