/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import com.terracottatech.config.Server;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.terracotta.dso.ServerInfo;
import org.terracotta.dso.ServerTracker;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.BaseAction;

public class ManageServerAction
extends BaseAction
implements IRunnableWithProgress {
    private Server m_server;
    private String m_name;
    private static ImageDescriptor m_startImage;
    private static ImageDescriptor m_stopImage;

    private static String buildNameForServer(Server server) {
        String name;
        if (server == null) {
            server = TcPlugin.DEFAULT_SERVER_INSTANCE;
        }
        if (server.isSetName()) {
            name = server.getName();
        } else {
            int dsoPort = server.isSetDsoPort() ? server.getDsoPort().getIntValue() : 9510;
            name = server.getHost() + ":" + dsoPort;
        }
        return name;
    }

    public ManageServerAction(IJavaProject javaProject) {
        this(javaProject, TcPlugin.DEFAULT_SERVER_INSTANCE);
    }

    public ManageServerAction(IJavaProject javaProject, Server server) {
        super(null);
        this.setJavaElement((IJavaElement)javaProject);
        this.m_server = (Server)server.copy();
        TcPlugin.getDefault().replacePatterns(this.m_server);
        this.m_name = ManageServerAction.buildNameForServer(this.m_server);
        this.setText(this.m_name);
        ServerTracker serverTracker = ServerTracker.getDefault();
        ServerInfo serverInfo = serverTracker.getServerInfo(javaProject, this.m_name);
        ImageDescriptor imageDesc = serverInfo != null ? m_stopImage : m_startImage;
        this.setImageDescriptor(imageDesc);
        this.setEnabled(serverInfo == null || serverInfo.isStarted());
        if (serverInfo != null && serverInfo.isStarting()) {
            this.setText(this.m_name + " (Starting...)");
        }
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!workbench.saveAllEditors(true)) {
            return;
        }
        TcPlugin plugin = TcPlugin.getDefault();
        IJavaProject javaProject = (IJavaProject)this.getJavaElement();
        ServerTracker tracker = ServerTracker.getDefault();
        boolean isRunning = tracker.isRunning(javaProject, this.m_name);
        IProject project = javaProject.getProject();
        try {
            if (!plugin.continueWithConfigProblems(project)) {
                return;
            }
        }
        catch (CoreException ce) {
            ManageServerAction.reportError(isRunning, (Exception)((Object)ce));
        }
        try {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            window.run(true, true, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            ManageServerAction.reportError(isRunning, e);
        }
    }

    private static void reportError(boolean isRunning, Exception e) {
        Shell shell = new Shell();
        String msg = MessageFormat.format("Error {0} Terracotta Server instance:\n\n", isRunning ? "stopping" : "starting");
        MessageDialog.openInformation((Shell)shell, (String)"Terracotta", (String)(msg + ActionUtil.getStatusMessages(e)));
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException("Cancelled server '" + this.m_name + "'");
        }
        IJavaProject javaProject = (IJavaProject)this.getJavaElement();
        ServerTracker tracker = ServerTracker.getDefault();
        if (tracker.isRunning(javaProject, this.m_name)) {
            tracker.stopServer(javaProject, this.m_name, this.m_server, monitor);
        } else {
            tracker.startServer(javaProject, this.m_name, this.m_server, monitor);
        }
    }

    static {
        String pluginId = TcPlugin.getPluginId();
        String startPath = "/images/eclipse/start.gif";
        String stopPath = "/images/eclipse/stop.gif";
        m_startImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)startPath);
        m_stopImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)stopPath);
    }
}

