/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class ExcludedTypeAction
extends BaseAction {
    public ExcludedTypeAction() {
        super("Excluded", 2);
    }

    public void setJavaElement(IJavaElement element) {
        super.setJavaElement(element);
        if (element instanceof IType) {
            IType type = (IType)element;
            boolean isBootClass = TcPlugin.getDefault().isBootClass(type.getJavaProject().getProject(), type);
            this.setEnabled(!isBootClass);
            this.setChecked(!isBootClass && this.getConfigHelper().isExcluded(type));
        } else {
            this.setChecked(this.getConfigHelper().isExcluded(element));
        }
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        ExcludeOperation operation = new ExcludeOperation(this.m_element, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing ExcludeOperation", ee);
        }
    }

    class ExcludeOperation
    extends AbstractOperation {
        private final IJavaElement fJavaElement;
        private final boolean fAddExclude;

        public ExcludeOperation(IJavaElement javaElement, boolean addExclude) {
            super("");
            this.fJavaElement = javaElement;
            this.fAddExclude = addExclude;
            if (this.fAddExclude) {
                this.setLabel("Add Excluded Type");
            } else {
                this.setLabel("Remove Excluded Type");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = ExcludedTypeAction.this.getConfigHelper();
            if (this.fAddExclude) {
                helper.ensureExcluded(this.fJavaElement);
            } else {
                helper.ensureNotExcluded(this.fJavaElement);
            }
            ExcludedTypeAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = ExcludedTypeAction.this.getConfigHelper();
            if (this.fAddExclude) {
                helper.ensureNotExcluded(this.fJavaElement);
            } else {
                helper.ensureExcluded(this.fJavaElement);
            }
            ExcludedTypeAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

