/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;

public abstract class BaseMenuCreator
implements IObjectActionDelegate,
IEditorActionDelegate,
IViewActionDelegate,
IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    protected IJavaElement m_element;
    protected IAction m_delegateAction;
    protected ISelection m_selection;
    protected IEditorPart m_editorPart;

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.m_editorPart = targetEditor;
    }

    protected IJavaElement getElement(ISelection selection) {
        IJavaElement element = this.getJavaElement(selection);
        if (element != null && this.hasTerracottaNature(element)) {
            return element;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.m_delegateAction == null) {
            this.m_delegateAction = action;
            this.m_delegateAction.setMenuCreator((IMenuCreator)this);
        }
        this.m_selection = selection;
    }

    public void setJavaElement(IJavaElement javaElement) {
        this.m_element = javaElement;
    }

    protected abstract IJavaElement getJavaElement(ISelection var1);

    protected void buildMenu(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                BaseMenuCreator.this.fillMenu(m);
            }
        });
    }

    protected ISelection getSelection() {
        if (this.m_editorPart != null && this.m_editorPart instanceof ITextEditor) {
            return ((ITextEditor)this.m_editorPart).getSelectionProvider().getSelection();
        }
        return this.m_selection;
    }

    public Menu getMenu(Control parent) {
        Menu menu = null;
        this.m_selection = this.getSelection();
        this.m_element = this.getElement(this.m_selection);
        if (this.m_element != null) {
            menu = new Menu(parent);
            this.buildMenu(menu);
        }
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = null;
        this.m_selection = this.getSelection();
        this.m_element = this.getElement(this.m_selection);
        if (this.m_element != null) {
            menu = new Menu(parent);
            this.buildMenu(menu);
        }
        return menu;
    }

    protected abstract void fillMenu(Menu var1);

    protected ConfigurationHelper getConfigHelper() {
        ConfigurationHelper helper = null;
        IProject project = this.getProject();
        if (project != null) {
            helper = TcPlugin.getDefault().getConfigurationHelper(project);
        }
        return helper;
    }

    protected IProject getProject() {
        return this.m_element != null ? this.m_element.getJavaProject().getProject() : null;
    }

    protected void addMenuAction(Menu menu, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    protected boolean hasTerracottaNature(IJavaElement element) {
        return TcPlugin.getDefault().hasTerracottaNature(element);
    }
}

