/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;

public class BaseAction
extends Action {
    protected IJavaElement m_element;

    public BaseAction(String label) {
        super(label);
    }

    public BaseAction(String label, int type) {
        super(label, type);
    }

    public void setJavaElement(IJavaElement element) {
        this.m_element = element;
    }

    public IJavaElement getJavaElement() {
        return this.m_element;
    }

    public ICompilationUnit getCompilationUnit() {
        if (this.m_element != null) {
            return (ICompilationUnit)this.m_element.getAncestor(5);
        }
        return null;
    }

    public void performAction() {
    }

    public void performAction(Event event) {
        this.performAction();
    }

    protected void inspectCompilationUnit() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu != null) {
            TcPlugin.getDefault().inspect(cu);
        }
    }

    public void runWithEvent(final Event event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (BaseAction.this.getJavaElement() != null) {
                    IProject project;
                    TcPlugin plugin = TcPlugin.getDefault();
                    if (!plugin.validateConfigurationFile(project = BaseAction.this.getProject())) {
                        return;
                    }
                    if (plugin.getConfiguration(project) == TcPlugin.BAD_CONFIG) {
                        Shell shell = Display.getDefault().getActiveShell();
                        String title = "Terracotta Plugin";
                        String msg = "The configuration source is not parsable and cannot be\n used until these errors are resolved.";
                        MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                        try {
                            plugin.openConfigurationEditor(project);
                        }
                        catch (Exception e) {}
                    } else {
                        BaseAction.this.performAction(event);
                    }
                }
            }
        });
    }

    protected ConfigurationHelper getConfigHelper() {
        ConfigurationHelper helper = null;
        IProject project = this.getProject();
        if (project != null) {
            helper = TcPlugin.getDefault().getConfigurationHelper(project);
        }
        return helper;
    }

    protected IProject getProject() {
        return this.m_element != null ? this.m_element.getJavaProject().getProject() : null;
    }
}

