/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.TcPlugin;

public class ActionUtil {
    public static IJavaProject locateSelectedJavaProject(ISelection selection) {
        IEditorPart part;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object obj : ss) {
                IAdaptable adaptable;
                IResource res;
                if (obj instanceof IJavaElement) {
                    return ((IJavaElement)obj).getJavaProject();
                }
                if (obj instanceof IProject) {
                    return ActionUtil.findJavaProject((IProject)obj);
                }
                if (obj instanceof IResource) {
                    return ActionUtil.findJavaProject(((IResource)obj).getProject());
                }
                if (!(obj instanceof IAdaptable) || (res = (IResource)(adaptable = (IAdaptable)obj).getAdapter(IResource.class)) == null) continue;
                return ActionUtil.findJavaProject(res.getProject());
            }
        }
        if ((part = ActionUtil.findSelectedEditorPart()) != null) {
            IEditorInput input = part.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IProject project = ((IFileEditorInput)input).getFile().getProject();
                if (project != null) {
                    return ActionUtil.findJavaProject(project);
                }
            } else {
                IClassFile classFile = (IClassFile)input.getAdapter(IClassFile.class);
                if (classFile != null) {
                    return classFile.getJavaProject();
                }
            }
        }
        return null;
    }

    public static IJavaProject findJavaProject(IProject project) {
        return project.isOpen() ? JavaCore.create((IProject)project) : null;
    }

    public static IJavaProject findSelectedJavaProject(ISelection selection) {
        IJavaElement elem;
        if (selection != null && selection instanceof IStructuredSelection && (elem = ActionUtil.findSelectedJavaElement((IStructuredSelection)selection)) instanceof IJavaProject) {
            return (IJavaProject)elem;
        }
        return null;
    }

    public static IPackageFragment findSelectedPackageFragment(ISelection selection) {
        if (selection != null) {
            IJavaElement elem = ActionUtil.findSelectedJavaElement(selection);
            if (elem instanceof IPackageFragment) {
                return (IPackageFragment)elem;
            }
            if (elem instanceof IPackageDeclaration) {
                IPackageDeclaration packageDecl = (IPackageDeclaration)elem;
                String name = packageDecl.getElementName();
                IPackageFragmentRoot root = JdtUtils.getPackageFragmentRoot(elem);
                if (root != null) {
                    return root.getPackageFragment(name);
                }
            }
        }
        return null;
    }

    public static IField findSelectedField(ISelection selection) {
        IJavaElement elem;
        if (selection != null && (elem = ActionUtil.findSelectedJavaElement(selection)) instanceof IField) {
            return (IField)elem;
        }
        return null;
    }

    public static ICompilationUnit findSelectedCompilationUnit() {
        ITextEditor editor = ActionUtil.findSelectedTextEditor();
        if (editor != null) {
            return JdtUtils.getInputAsCompilationUnit(editor);
        }
        return null;
    }

    public static IEditorPart findSelectedEditorPart() {
        IWorkbenchPage page;
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (win != null && (page = win.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static ITextEditor findSelectedTextEditor() {
        IEditorPart part = ActionUtil.findSelectedEditorPart();
        if (part != null && part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return null;
    }

    public static IMethod findSelectedMethod(ISelection selection) {
        IJavaElement elem;
        if (selection != null && (elem = ActionUtil.findSelectedJavaElement(selection)) instanceof IMethod) {
            return (IMethod)elem;
        }
        return null;
    }

    public static IFile findSelectedFile(ISelection selection) {
        IStructuredSelection ss;
        Object obj;
        if (selection != null && selection instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            return (IFile)obj;
        }
        return null;
    }

    public static ICompilationUnit findSelectedCompilationUnit(ISelection selection) {
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                IJavaElement elem = ActionUtil.findSelectedJavaElement((IStructuredSelection)selection);
                if (elem instanceof ICompilationUnit) {
                    return (ICompilationUnit)elem;
                }
            } else if (selection instanceof ITextSelection) {
                return ActionUtil.findSelectedCompilationUnit();
            }
        }
        return null;
    }

    public static IType findSelectedType(ISelection selection) {
        if (selection != null) {
            IJavaElement elem = ActionUtil.findSelectedJavaElement(selection);
            if (elem instanceof IType) {
                return (IType)elem;
            }
            if (elem instanceof IMethod) {
                return ((IMethod)elem).getDeclaringType();
            }
            if (elem instanceof IField) {
                IJavaProject javaProject = elem.getJavaProject();
                IField field = (IField)elem;
                IType declaringType = field.getDeclaringType();
                try {
                    String sig = field.getTypeSignature();
                    String typeName = JdtUtils.getResolvedTypeName(sig, declaringType);
                    return JdtUtils.findType(javaProject, typeName);
                }
                catch (JavaModelException jme) {}
            } else if (elem instanceof ILocalVariable) {
                IJavaProject javaProject = elem.getJavaProject();
                ILocalVariable var = (ILocalVariable)elem;
                IType enclosingType = (IType)elem.getAncestor(7);
                if (enclosingType != null) {
                    try {
                        String sig = var.getTypeSignature();
                        String typeName = JdtUtils.getResolvedTypeName(sig, enclosingType);
                        return JdtUtils.findType(javaProject, typeName);
                    }
                    catch (JavaModelException jme) {}
                }
            } else if (elem instanceof IImportDeclaration) {
                IImportDeclaration importDecl = (IImportDeclaration)elem;
                String typeName = importDecl.getElementName();
                if (!importDecl.isOnDemand()) {
                    try {
                        return JdtUtils.findType(elem.getJavaProject(), typeName);
                    }
                    catch (JavaModelException jme) {}
                }
            } else if (elem instanceof IClassFile) {
                try {
                    return ((IClassFile)elem).getType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static IJavaElement findSelectedJavaElement(ISelection selection) {
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                return ActionUtil.findSelectedJavaElement((IStructuredSelection)selection);
            }
            if (selection instanceof ITextSelection) {
                return ActionUtil.findSelectedJavaElement((ITextSelection)selection);
            }
        }
        return null;
    }

    public static IJavaElement findSelectedJavaElement(IStructuredSelection selection) {
        Object obj;
        if (selection != null && (obj = selection.getFirstElement()) instanceof IJavaElement) {
            return (IJavaElement)obj;
        }
        return null;
    }

    public static IJavaElement findSelectedJavaElement(ITextSelection selection) {
        ITextEditor editor;
        if (selection != null && (editor = ActionUtil.findSelectedTextEditor()) != null) {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (TcPlugin.getDefault().hasTerracottaNature(file.getProject())) {
                    try {
                        IJavaElement[] elems = JdtUtils.codeResolve(editor);
                        return elems.length == 1 ? elems[0] : null;
                    }
                    catch (JavaModelException jme) {}
                }
            } else {
                IClassFile classFile = (IClassFile)input.getAdapter(IClassFile.class);
                if (classFile != null) {
                    IJavaProject javaProj = classFile.getJavaProject();
                    if (TcPlugin.getDefault().hasTerracottaNature(javaProj.getProject())) {
                        try {
                            IJavaElement[] elems = JdtUtils.codeResolve(editor);
                            return elems.length == 1 ? elems[0] : null;
                        }
                        catch (JavaModelException jme) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    public static String getStatusMessages(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getCause();
        }
        if (throwable instanceof CoreException) {
            CoreException ce = (CoreException)throwable;
            IStatus status = ce.getStatus();
            IStatus[] children = status.getChildren();
            if (children.length > 0) {
                StringBuilder message = new StringBuilder(throwable.getMessage()).append("\n");
                for (IStatus child : children) {
                    message.append("\n").append(child.getMessage());
                }
                return message.toString();
            }
            return throwable.getMessage();
        }
        return throwable.getMessage();
    }
}

