/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.util.Assert;
import com.terracottatech.config.Server;
import org.eclipse.jdt.core.IJavaProject;

public class ServerInfo {
    private IJavaProject m_javaProject;
    private String m_name;
    private Server m_server;
    private int m_status;
    public static final int STARTING = 0;
    public static final int STARTED = 1;
    public static final int TERMINATED = 2;

    public ServerInfo(IJavaProject javaProject, String name, Server server) {
        this.m_javaProject = javaProject;
        this.m_name = name;
        this.m_server = server;
        this.m_status = 0;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public String getName() {
        return this.m_name;
    }

    public Server getServer() {
        return this.m_server;
    }

    public String getHost() {
        return this.m_server.getHost();
    }

    public int getJmxPort() {
        return this.m_server.getJmxPort().getIntValue();
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int status) {
        Assert.assertTrue((Object)"Invalid status", (status == 0 || status == 1 || status == 2 ? 1 : 0) != 0);
        this.m_status = status;
    }

    public boolean isStarting() {
        return this.getStatus() == 0;
    }

    public boolean isStarted() {
        return this.getStatus() == 1;
    }

    public boolean isTerminated() {
        return this.getStatus() == 2;
    }

    public String toString() {
        return this.getName() + ":" + this.getJmxPort();
    }
}

