/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.server.ServerConstants;
import com.terracottatech.config.Server;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.terracotta.dso.BootClassHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BuildBootJarAction;
import org.terracotta.dso.actions.ManageServerAction;
import org.terracotta.dso.dialogs.RelaunchDialog;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static final boolean debug = Boolean.getBoolean("ResourceDeltaVisitor.debug");
    boolean fIgnoreNextConfigChange;

    public boolean visit(IResourceDelta delta) {
        final TcPlugin plugin = TcPlugin.getDefault();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IResource res = delta.getResource();
        final IProject project = res.getProject();
        if (debug) {
            this.dump(delta);
        }
        if (plugin == null || !plugin.hasTerracottaNature(project)) {
            return true;
        }
        switch (kind) {
            case 4: {
                if ((flags & 0x20000) != 0) {
                    return false;
                }
                if ((flags & 0x100) == 0 || !(res instanceof IFile)) break;
                IFile file = (IFile)res;
                IPath path = file.getLocation();
                String ext = path.getFileExtension();
                int segmentCount = path.segmentCount();
                if (segmentCount == 2 && path.segment(segmentCount - 1).equals(".classpath")) {
                    final IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (BootClassHelper.canGetBootTypes(javaProject)) {
                        plugin.setBootClassHelper(project, new BootClassHelper(javaProject));
                    } else {
                        Job job = new Job("Building bootjar"){

                            public IStatus run(IProgressMonitor monitor) {
                                try {
                                    new BuildBootJarAction(javaProject).run(monitor);
                                }
                                catch (Exception e) {
                                    plugin.openError("Building bootjar", e);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    return false;
                }
                if (!ext.equals("xml") || !plugin.getConfigurationFile(project).equals(res)) break;
                final boolean queryRestart = plugin.getQueryRestartOption(project);
                boolean wasIgnoringChange = this.fIgnoreNextConfigChange;
                if (this.fIgnoreNextConfigChange) {
                    this.fIgnoreNextConfigChange = false;
                }
                try {
                    if (!wasIgnoringChange) {
                        Job job = new Job("Reloading DSO Configuration"){

                            public IStatus run(IProgressMonitor monitor) {
                                plugin.reloadConfiguration(project);
                                if (queryRestart) {
                                    ResourceDeltaVisitor.this.queryRelaunchAll(project);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    } else if (queryRestart) {
                        Job job = new Job("Restart?"){

                            public IStatus run(IProgressMonitor monitor) {
                                ResourceDeltaVisitor.this.queryRelaunchAll(project);
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            case 1: {
                if ((flags & 0x1000) != 0) {
                    if (!(res instanceof IFile)) break;
                    plugin.fileMoved((IFile)res, delta.getMovedFromPath());
                    break;
                }
                if (!(res instanceof IProject)) break;
                plugin.validateConfigurationFile(project);
                break;
            }
            case 2: {
                if ((flags & 0x2000) != 0 || !(res instanceof IFile)) break;
                plugin.fileRemoved((IFile)res);
            }
        }
        return true;
    }

    private void queryRelaunchAll(final IProject project) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        final ArrayList<ILaunch> launches = new ArrayList<ILaunch>();
        final ArrayList<ILaunch> serverLaunches = new ArrayList<ILaunch>();
        for (ILaunch launch : launchManager.getLaunches()) {
            IProcess[] processes = launch.getProcesses();
            if (launch.isTerminated() || processes == null || processes.length == 0) continue;
            ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
            try {
                String projName;
                String mainClass = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
                if (mainClass != null && mainClass.equals(ServerConstants.SERVER_MAIN_CLASS_NAME)) {
                    String projName2 = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                    if (!projName2.equals(project.getName())) continue;
                    serverLaunches.add(launch);
                    continue;
                }
                ILaunchConfigurationType launchConfigType = launchConfig.getType();
                String id = launchConfigType.getIdentifier();
                if (!id.equals("launch.configurationDelegate") || (projName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null)) == null || !projName.equals(project.getName())) continue;
                launches.add(launch);
            }
            catch (CoreException ce) {
                // empty catch block
            }
        }
        if (launches.size() > 0 || serverLaunches.size() > 0) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    final Shell shell = TcPlugin.getActiveWorkbenchShell();
                    RelaunchDialog relaunchDialog = new RelaunchDialog(shell, project, serverLaunches, launches);
                    final int returnCode = relaunchDialog.open();
                    if (returnCode == 0) {
                        return;
                    }
                    new Job("Restarting Terracotta"){

                        public IStatus run(IProgressMonitor monitor) {
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            ArrayList allLaunches = new ArrayList(launches);
                            allLaunches.addAll(serverLaunches);
                            for (ILaunch launch : allLaunches) {
                                ResourceDeltaVisitor.safeTerminateLaunch(launch);
                            }
                            if (returnCode == 1) {
                                return Status.OK_STATUS;
                            }
                            Iterator iter = serverLaunches.iterator();
                            while (iter.hasNext()) {
                                try {
                                    ILaunch launch;
                                    launch = (ILaunch)iter.next();
                                    Server server = TcPlugin.getDefault().getLaunchedServer(project, launch);
                                    if (server != null) {
                                        ManageServerAction msa = new ManageServerAction(JavaCore.create((IProject)project), server);
                                        msa.run(monitor);
                                        continue;
                                    }
                                    final String launchName = launch.getLaunchConfiguration().getName();
                                    display.syncExec(new Runnable(){

                                        public void run() {
                                            String msg = "Unable to locate config element for server '" + launchName + ".'  Cancelling client restart.";
                                            MessageDialog.openInformation((Shell)shell, (String)"Terracotta", (String)msg);
                                        }
                                    });
                                    return Status.OK_STATUS;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            for (ILaunch launch : launches) {
                                DebugUITools.launch((ILaunchConfiguration)launch.getLaunchConfiguration(), (String)launch.getLaunchMode());
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            });
        }
    }

    private static void safeTerminateLaunch(ILaunch launch) {
        try {
            launch.terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    private void dump(IResourceDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        StringBuffer sb = new StringBuffer();
        sb.append(delta.getResource().getFullPath());
        switch (kind) {
            case 0: {
                sb.append(" NO_CHANGE");
                break;
            }
            case 1: {
                sb.append(" ADDED");
                break;
            }
            case 2: {
                sb.append(" REMOVED");
                break;
            }
            case 4: {
                sb.append(" CHANGED");
                break;
            }
            case 8: {
                sb.append(" ADDED_PHANTOM");
                break;
            }
            case 16: {
                sb.append(" REMOVED_PHANTOM");
            }
        }
        if ((flags & 0x100) != 0) {
            sb.append(" CONTENT");
        }
        if ((flags & 0x1000) != 0) {
            sb.append(" MOVED_FROM");
        }
        if ((flags & 0x2000) != 0) {
            sb.append(" MOVED_TO");
        }
        if ((flags & 0x4000) != 0) {
            sb.append(" OPEN");
        }
        if ((flags & 0x8000) != 0) {
            sb.append(" TYPE");
        }
        if ((flags & 0x10000) != 0) {
            sb.append(" SYNC");
        }
        if ((flags & 0x20000) != 0) {
            sb.append(" MARKERS");
        }
        if ((flags & 0x40000) != 0) {
            sb.append(" REPLACED");
        }
        if ((flags & 0x80000) != 0) {
            sb.append(" DESCRIPTION");
        }
        if ((flags & 0x100000) != 0) {
            sb.append(" ENCODING");
        }
        System.out.println(sb.toString());
    }
}

