/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.expression.ExpressionContext;
import com.tc.aspectwerkz.expression.ExpressionVisitor;
import com.tc.aspectwerkz.expression.PointcutType;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MemberInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.aspectwerkz.reflect.ReflectionInfo;
import com.tc.object.bytecode.aspectwerkz.ExpressionHelper;
import com.terracottatech.config.Root;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.terracotta.dso.ClassInformationFactory;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.JavaModelClassInfo;
import org.terracotta.dso.JdtUtils;

public class PatternHelper {
    private static PatternHelper m_helper = new PatternHelper();
    private final ExpressionHelper m_expressionHelper = new ExpressionHelper();
    private final ClassInformationFactory m_classInfoFactory = new ClassInformationFactory();
    private final HashMap m_expressionContextCache = new HashMap();
    private final HashMap m_executionExpressionContextCache = new HashMap();

    public static final PatternHelper getHelper() {
        return m_helper;
    }

    private PatternHelper() {
    }

    public boolean matchesField(Root root, IField field) {
        if (root.isSetFieldName()) {
            return root.getFieldName().equals(ConfigurationHelper.getFullName(field));
        }
        FieldInfo fi = this.getFieldInfo(field);
        try {
            String fieldExpr = root.getFieldExpression();
            ExpressionVisitor visitor = this.m_expressionHelper.createExpressionVisitor("get(" + fieldExpr + ")");
            return visitor.match(new ExpressionContext(PointcutType.GET, (ReflectionInfo)fi, (ReflectionInfo)fi));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean matchesMethod(String expression, IMethod method) {
        MethodInfo methodInfo = method != null ? this.getMethodInfo(method) : null;
        int parentIndex = expression.indexOf(40);
        if (parentIndex > 0) {
            String tmp = expression.substring(parentIndex);
            tmp = StringUtils.replaceChars((String)tmp, (char)'$', (char)'.');
            expression = expression.substring(0, parentIndex) + tmp;
        }
        return methodInfo != null && this.matchesMember(expression, (MemberInfo)methodInfo);
    }

    public boolean matchesMethod(String expression, MethodDeclaration methodDecl) {
        return this.matchesMember(expression, (MemberInfo)this.getMethodInfo(methodDecl));
    }

    public ExpressionContext createExecutionExpressionContext(IMethod method) {
        return this.createExecutionExpressionContext((MemberInfo)this.getMethodInfo(method));
    }

    public ExpressionContext createExecutionExpressionContext(MemberInfo methodInfo) {
        ExpressionContext exprCntx = (ExpressionContext)this.m_executionExpressionContextCache.get(methodInfo);
        if (exprCntx == null) {
            exprCntx = this.m_expressionHelper.createExecutionExpressionContext(methodInfo);
            this.m_executionExpressionContextCache.put(methodInfo, exprCntx);
        }
        return exprCntx;
    }

    public void testValidateMethodExpression(String expr) throws Exception {
        String execExpr = ExpressionHelper.expressionPattern2ExecutionExpression((String)expr);
        this.m_expressionHelper.createExpressionVisitor(execExpr);
    }

    public boolean matchesMethod(String expr, ExpressionContext exprCntx) {
        try {
            String execExpr = ExpressionHelper.expressionPattern2ExecutionExpression((String)expr);
            ExpressionVisitor visitor = this.m_expressionHelper.createExpressionVisitor(execExpr);
            return visitor.match(exprCntx);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matchesMember(String expr, MemberInfo methodInfo) {
        int parentIndex = expr.indexOf(40);
        if (parentIndex > 0) {
            String tmp = expr.substring(parentIndex);
            tmp = StringUtils.replaceChars((String)tmp, (char)'$', (char)'.');
            expr = expr.substring(0, parentIndex) + tmp;
        }
        return this.matchesMethod(expr, this.createExecutionExpressionContext(methodInfo));
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('$');
    }

    public ExpressionContext createWithinExpressionContext(IType type) {
        return this.createWithinExpressionContext(this.m_classInfoFactory.getClassInfo(type));
    }

    public ExpressionContext createWithinExpressionContext(IPackageDeclaration packageDecl) {
        return this.createWithinExpressionContext(packageDecl.getElementName());
    }

    public ExpressionContext createWithinExpressionContext(IPackageFragment fragment) {
        return this.createWithinExpressionContext(fragment.getElementName());
    }

    public ExpressionContext createWithinExpressionContext(String className) {
        return this.createWithinExpressionContext(this.m_classInfoFactory.getClassInfo(className));
    }

    public ExpressionContext createWithinExpressionContext(ClassInfo classInfo) {
        ExpressionContext exprCntx = (ExpressionContext)this.m_expressionContextCache.get(classInfo);
        if (exprCntx == null) {
            exprCntx = this.m_expressionHelper.createWithinExpressionContext(classInfo);
            this.m_expressionContextCache.put(classInfo, exprCntx);
        }
        return exprCntx;
    }

    public boolean matchesClass(String expr, ExpressionContext exprCntx) {
        try {
            String withinExpr = ExpressionHelper.expressionPattern2WithinExpression((String)expr);
            ExpressionVisitor visitor = this.m_expressionHelper.createExpressionVisitor(withinExpr);
            return visitor.match(exprCntx);
        }
        catch (Exception e) {
            return false;
        }
    }

    public JavaModelClassInfo getClassInfo(IType type) {
        return (JavaModelClassInfo)this.m_classInfoFactory.getClassInfo(type);
    }

    public boolean matchesClass(String expression, String className) {
        if (expression != null && expression.equals(className)) {
            return true;
        }
        return this.matchesClass(expression, this.m_classInfoFactory.getClassInfo(className));
    }

    public boolean matchesClass(String expr, ClassInfo classInfo) {
        return this.matchesClass(expr, this.createWithinExpressionContext(classInfo));
    }

    public boolean matchesType(String expr, IType type) {
        return this.matchesClass(expr, this.createWithinExpressionContext(type));
    }

    public boolean matchesPackageFragment(String expr, IPackageFragment fragment) {
        return expr.equals(fragment.getElementName() + "..*") || expr.equals(fragment.getElementName() + ".*");
    }

    public boolean matchesPackageDeclaration(String expr, IPackageDeclaration packageDecl) {
        return expr.equals(packageDecl.getElementName() + "..*") || expr.equals(packageDecl.getElementName() + ".*");
    }

    public static String getSignature(IMethod method) throws JavaModelException {
        IType dType = method.getDeclaringType();
        String[] pTypes = (String[])method.getParameterTypes().clone();
        String rType = method.getReturnType();
        StringBuffer sb = new StringBuffer("(");
        rType = Signature.getTypeErasure((String)rType);
        for (int i = 0; i < pTypes.length; ++i) {
            String erasedSig = Signature.getTypeErasure((String)pTypes[i]);
            if (erasedSig.charAt(0) == 'T') {
                erasedSig = "Ljava.lang.Object;";
            } else if (erasedSig.charAt(0) == '[' && erasedSig.charAt(1) == 'T') {
                erasedSig = "[Ljava.lang.Object;";
            }
            JdtUtils.resolveTypeName(erasedSig, dType, sb);
        }
        sb.append(')');
        if (rType.charAt(0) == 'T') {
            rType = "Ljava.lang.Object;";
        } else if (rType.charAt(0) == '[' && rType.charAt(1) == 'T') {
            rType = "[Ljava.lang.Object;";
        }
        JdtUtils.resolveTypeName(rType, dType, sb);
        String result = sb.toString().replace('.', '/');
        return result;
    }

    public static String getFullName(IMethod method) {
        IType declaringType = method.getDeclaringType();
        return PatternHelper.getFullyQualifiedName(declaringType) + "." + method.getElementName();
    }

    public static boolean isVarargs(IMethod method) {
        try {
            return Flags.isVarargs((int)method.getFlags());
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    public static String getJavadocSignature(IMethod method) throws JavaModelException {
        int dim;
        StringBuffer sb = new StringBuffer();
        IType declaringType = method.getDeclaringType();
        boolean isVararg = PatternHelper.isVarargs(method);
        String[] params = (String[])method.getParameterTypes().clone();
        int lastParam = params.length - 1;
        try {
            String returnType = method.getReturnType();
            dim = Signature.getArrayCount((String)returnType);
            returnType = Signature.getTypeErasure((String)returnType);
            sb.append(JdtUtils.getResolvedTypeFileName(returnType, declaringType));
            while (dim > 0) {
                sb.append("[]");
                --dim;
            }
        }
        catch (JavaModelException jme) {
            sb.append("*");
        }
        sb.append(" ");
        sb.append(PatternHelper.getFullyQualifiedName(declaringType));
        sb.append(".");
        sb.append(method.isConstructor() ? "__INIT__" : method.getElementName());
        sb.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            String erasedSig = Signature.getTypeErasure((String)params[i]);
            sb.append(JdtUtils.getResolvedTypeFileName(erasedSig, declaringType));
            dim = Signature.getArrayCount((String)erasedSig);
            if (i == lastParam && isVararg) {
                --dim;
            }
            while (dim > 0) {
                sb.append("[]");
                --dim;
            }
            if (i != lastParam || !isVararg) continue;
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public MethodInfo getMethodInfo(IMethod method) {
        MethodInfo info = null;
        if (method != null) {
            try {
                info = this.m_classInfoFactory.getMethodInfo(method);
            }
            catch (JavaModelException jme) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return info;
    }

    public FieldInfo getFieldInfo(IField field) {
        return field != null ? this.m_classInfoFactory.getFieldInfo(field) : null;
    }

    public MethodInfo getMethodInfo(MethodDeclaration methodDecl) {
        return this.getMethodInfo(PatternHelper.methodDecl2IMethod(methodDecl));
    }

    public static IMethod methodDecl2IMethod(MethodDeclaration methodDecl) {
        IJavaElement elem;
        IMethodBinding binding = methodDecl.resolveBinding();
        IJavaElement iJavaElement = elem = binding != null ? binding.getJavaElement() : null;
        if (elem instanceof IMethod) {
            return (IMethod)elem;
        }
        return null;
    }

    public static String getExecutionPattern(IJavaElement element) {
        if (element instanceof IMethod) {
            return PatternHelper.getExecutionPattern((IMethod)element);
        }
        if (element instanceof IType) {
            return PatternHelper.getExecutionPattern((IType)element);
        }
        if (element instanceof IPackageFragment) {
            return PatternHelper.getExecutionPattern((IPackageFragment)element);
        }
        if (element instanceof ICompilationUnit) {
            return PatternHelper.getExecutionPattern(((ICompilationUnit)element).findPrimaryType());
        }
        if (element instanceof IPackageDeclaration) {
            return PatternHelper.getExecutionPattern((IPackageDeclaration)element);
        }
        return null;
    }

    public static String getExecutionPattern(IMethod method) {
        try {
            if (!method.getOpenable().isOpen()) {
                method.getOpenable().open(null);
            }
            return PatternHelper.getJavadocSignature(method);
        }
        catch (JavaModelException jme) {
            IType type = method.getDeclaringType();
            String typeName = PatternHelper.getFullyQualifiedName(type);
            return "* " + typeName + "." + method.getElementName() + "(..)";
        }
    }

    public static String getExecutionPattern(IType type) {
        return "* " + PatternHelper.getWithinPattern(type) + "(..)";
    }

    public static String getWithinPattern(IType type) {
        return PatternHelper.getFullyQualifiedName(type) + ".*";
    }

    public static String getExecutionPattern(IPackageFragment fragment) {
        return "* " + PatternHelper.getWithinPattern(fragment) + "(..)";
    }

    public static String getExecutionPattern(IPackageDeclaration packageDecl) {
        return "* " + PatternHelper.getWithinPattern(packageDecl) + "(..)";
    }

    public static String getWithinPattern(IPackageFragment fragment) {
        return fragment.getElementName() + "..*";
    }

    public static String getWithinPattern(IPackageDeclaration packageDecl) {
        return packageDecl.getElementName() + "..*";
    }
}

