/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class LineLengths
implements Serializable {
    private int[] m_lines;

    public LineLengths() {
    }

    public LineLengths(IFile file) throws ConcurrentModificationException, IOException, CoreException {
        this();
        this.setFile(file);
    }

    public LineLengths(Reader reader) throws ConcurrentModificationException, IOException {
        this();
        this.setReader(reader);
    }

    public void setFile(IFile file) throws ConcurrentModificationException, IOException, CoreException {
        this.initLines(new InputStreamReader(file.getContents()));
    }

    public void setReader(Reader reader) throws ConcurrentModificationException, IOException {
        this.initLines(reader);
    }

    private void initLines(Reader reader) throws ConcurrentModificationException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String s;
            BufferedReader br = new BufferedReader(reader);
            while ((s = this.readLine(br)) != null) {
                list.add(s);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ConcurrentModificationException e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        int size = list.size();
        this.m_lines = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_lines[i] = ((String)list.get(i)).length();
        }
    }

    private String readLine(BufferedReader br) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        boolean haveCR = false;
        boolean done = false;
        while ((i = br.read()) != -1) {
            char c = (char)i;
            if (haveCR) {
                switch (c) {
                    case '\n': {
                        sb.append(c);
                        done = true;
                        break;
                    }
                    default: {
                        br.reset();
                        done = true;
                        break;
                    }
                }
            } else {
                sb.append(c);
                switch (c) {
                    case '\n': {
                        done = true;
                        break;
                    }
                    case '\r': {
                        br.mark(1);
                        haveCR = true;
                    }
                }
            }
            if (!done) continue;
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public int lineSize(int line) {
        if (line < 0 || line > this.m_lines.length) {
            return 0;
        }
        return this.m_lines[line];
    }

    public int offset(int line) {
        int result = 0;
        if (line == 0) {
            return 0;
        }
        for (int i = 0; i < line; ++i) {
            result += this.m_lines[i];
        }
        return result;
    }

    public int offset(int line, int col) {
        if (line < 0 || line > this.m_lines.length) {
            return 0;
        }
        int result = this.offset(line);
        if (col > 0) {
            result += col;
        }
        return result;
    }
}

