/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JdtUtils {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName = fullyQualifiedName.replace('$', '.'), (IProgressMonitor)null);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            type = JdtUtils.findType(root, fullyQualifiedName);
            if (type == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() != 4 || !fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) || (type = JdtUtils.findType(pack, fullyQualifiedName)) == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        for (int i = 0; i < cus.length; ++i) {
            ICompilationUnit unit = cus[i];
            IType type = JdtUtils.findType(unit, fullyQualifiedName);
            if (type == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    public static IMethod[] findMethods(IType type, String name) throws JavaModelException {
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getElementName().equals(name)) continue;
            list.add(methods[i]);
        }
        return list.toArray(new IMethod[0]);
    }

    private static IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        for (int i = 0; i < types.length; ++i) {
            IType type = types[i];
            if (!JdtUtils.getFullyQualifiedName(type).equals(fullyQualifiedName)) continue;
            return type;
        }
        return null;
    }

    public static String getFullyQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return JdtUtils.getFullyQualifiedName(declaringType) + '.' + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return type.getFullyQualifiedName('.');
    }

    public static void reconcile(ICompilationUnit unit) throws JavaModelException {
        unit.reconcile(0, false, null, null);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JdtUtils.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static String getResolvedTypeFileName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JdtUtils.concatenateName(resolvedNames[0][0], resolvedNames[0][1].replace('.', '$'));
            }
            return "*";
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isTypeNameUnresolved(String refTypeSig) {
        return refTypeSig.charAt(Signature.getArrayCount((String)refTypeSig)) == 'Q';
    }

    public static String resolveTypeName(String refTypeSig, IType declaringType) {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            try {
                String[][] resolvedNames = declaringType.resolveType(name);
                if (resolvedNames != null && resolvedNames.length > 0) {
                    return JdtUtils.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
                }
                return "java.lang.Object";
            }
            catch (JavaModelException jme) {
                return name;
            }
        }
        return refTypeSig;
    }

    public static void resolveTypeName(String refTypeSig, IType declaringType, StringBuffer sb) {
        if (JdtUtils.isTypeNameUnresolved(refTypeSig)) {
            sb.append(refTypeSig.substring(0, refTypeSig.indexOf(81)));
            sb.append('L');
            sb.append(JdtUtils.resolveTypeName(refTypeSig, declaringType));
            sb.append(';');
        } else {
            sb.append(refTypeSig);
        }
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static IJavaElement[] codeResolve(ITextEditor editor) throws JavaModelException {
        return JdtUtils.codeResolve(editor, true);
    }

    public static IJavaElement[] codeResolve(ITextEditor editor, boolean primaryOnly) throws JavaModelException {
        return JdtUtils.codeResolve(JdtUtils.getInput((IEditorPart)editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement getInput(IEditorPart editor) {
        return JdtUtils.getInput(editor, true);
    }

    private static IJavaElement getInput(IEditorPart editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return JdtUtils.getEditorInputJavaElement(editor, primaryOnly);
    }

    public static ICompilationUnit getInputAsCompilationUnit(ITextEditor editor) {
        IJavaElement editorInput = JdtUtils.getInput((IEditorPart)editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    public static IJavaElement getEditorInputJavaElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IJavaElement je = JdtUtils.getEditorInputJavaElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return JavaUI.getWorkingCopyManager().getWorkingCopy(editorInput);
    }

    public static IJavaElement getEditorInputJavaElement(IEditorInput editorInput) {
        ICompilationUnit je = JavaUI.getWorkingCopyManager().getWorkingCopy(editorInput);
        if (je != null) {
            return je;
        }
        return (IJavaElement)editorInput.getAdapter(IJavaElement.class);
    }

    public static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                JdtUtils.reconcile((ICompilationUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(ITextEditor editor) throws JavaModelException {
        return JdtUtils.getElementAtOffset(editor, true);
    }

    private static IJavaElement getElementAtOffset(ITextEditor editor, boolean primaryOnly) throws JavaModelException {
        return JdtUtils.getElementAtOffset(JdtUtils.getInput((IEditorPart)editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JdtUtils.reconcile(cunit);
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

