/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.exception.ImplementMe;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.terracotta.dso.ClassInformationFactory;
import org.terracotta.dso.JavaModelAnnotationInfo;
import org.terracotta.dso.JdtUtils;

public class JavaModelFieldInfo
implements FieldInfo {
    private ClassInformationFactory fClassInfoFactory;
    private IField fField;
    private JavaModelAnnotationInfo fAnnotationInfo;
    private String fTypeName;
    private IType fType;
    private ClassInfo fClassInfo;

    public JavaModelFieldInfo(ClassInformationFactory classInfoFactory, IField field) {
        this.fClassInfoFactory = classInfoFactory;
        this.fField = field;
        this.fAnnotationInfo = new JavaModelAnnotationInfo((IMember)field);
    }

    public ClassInfo getType() {
        if (this.fClassInfo == null) {
            IType type = this.getFieldType();
            this.fClassInfo = type != null ? this.fClassInfoFactory.getClassInfo(type) : this.fClassInfoFactory.getClassInfo(this.getTypeName());
        }
        return this.fClassInfo;
    }

    private String getTypeName() {
        if (this.fTypeName == null) {
            this.fTypeName = this.resolveTypeName();
        }
        return this.fTypeName;
    }

    private String resolveTypeName() {
        try {
            String sig = this.fField.getTypeSignature();
            IType declaringType = this.fField.getDeclaringType();
            return JdtUtils.getResolvedTypeName(sig, declaringType);
        }
        catch (JavaModelException jme) {
            return "java.lang.Object";
        }
    }

    private IType getFieldType() {
        if (this.fType == null) {
            this.fType = this.determineFieldType();
        }
        return this.fType;
    }

    public IType determineFieldType() {
        try {
            String typeName = this.getTypeName();
            IJavaProject javaProject = this.fField.getJavaProject();
            if (typeName != null) {
                return JdtUtils.findType(javaProject, typeName);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public ClassInfo getDeclaringType() {
        return this.fClassInfoFactory.getClassInfo(this.fField.getDeclaringType());
    }

    public void clearAnnotations() {
        this.fAnnotationInfo.clear();
    }

    public void addAnnotation(Annotation annotation) {
        this.fAnnotationInfo.addAnnotation(annotation);
    }

    public void addAnnotation(String fqcn) {
        this.fAnnotationInfo.addAnnotation(fqcn);
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.fAnnotationInfo.getAnnotations();
    }

    public String getGenericsSignature() {
        throw new ImplementMe();
    }

    public int getModifiers() {
        throw new ImplementMe();
    }

    public String getName() {
        return this.fField.getElementName();
    }

    public String getSignature() {
        throw new ImplementMe();
    }
}

