/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.backport175.bytecode.AnnotationElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IAnnotationBinding;

public class JavaModelAnnotationInfo {
    private List<AnnotationElement.Annotation> fAnnotations = new ArrayList<AnnotationElement.Annotation>();
    private static final Class fAnnotatableClass;

    public JavaModelAnnotationInfo() {
    }

    public JavaModelAnnotationInfo(IMember member) {
        this();
        if (JavaModelAnnotationInfo.isAnnotatable(member)) {
            String[] annoTypes;
            for (String annoType : annoTypes = JavaModelAnnotationInfo.getAnnotationTypes(member)) {
                this.addAnnotation(annoType);
            }
        }
    }

    private static String[] getAnnotationTypes(IMember member) {
        IType declaringType = member instanceof IType ? (IType)member : member.getDeclaringType();
        ArrayList<String> result = new ArrayList<String>();
        try {
            Method getter = member.getClass().getMethod("getAnnotations", new Class[0]);
            if (getter != null) {
                Object[] annos;
                for (Object anno : annos = (Object[])getter.invoke((Object)member, new Object[0])) {
                    Method getName = anno.getClass().getMethod("getElementName", new Class[0]);
                    String name = (String)getName.invoke(anno, new Object[0]);
                    String[][] annoFullNames = declaringType.resolveType(name);
                    if (annoFullNames == null) continue;
                    String[] elems = annoFullNames[0];
                    String fqcn = elems[0] + "." + elems[1];
                    result.add(fqcn);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toArray(new String[result.size()]);
    }

    public void clearAnnotations() {
        this.fAnnotations.clear();
    }

    public void addAnnotation(Annotation annotation) {
        IAnnotationBinding binding = annotation.resolveAnnotationBinding();
        String name = binding.getAnnotationType().getQualifiedName();
        this.addAnnotation(name);
    }

    public void addAnnotation(String fqcn) {
        this.fAnnotations.add(new AnnotationElement.Annotation(fqcn));
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.fAnnotations.toArray(new AnnotationElement.Annotation[0]);
    }

    public void clear() {
        this.fAnnotations.clear();
    }

    public static boolean isAnnotatable(Object target) {
        return fAnnotatableClass != null && fAnnotatableClass.isAssignableFrom(target.getClass());
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("org.eclipse.jdt.core.IAnnotatable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        fAnnotatableClass = c;
    }
}

