/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.JavaModelClassInfo;
import org.terracotta.dso.JavaModelFieldInfo;
import org.terracotta.dso.JavaModelMethodInfo;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;

public class CompilationUnitVisitor
extends ASTVisitor {
    private IProject m_project;
    private IResource m_res;
    private CompilationUnit m_ast;
    private ConfigurationHelper m_configHelper;
    private InspectionAction m_inspector = new InspectionAction();
    private static final TcPlugin m_plugin = TcPlugin.getDefault();

    protected void setup(ICompilationUnit cu) throws JavaModelException, CoreException {
        this.m_res = cu.getBuffer().getUnderlyingResource();
        this.m_project = cu.getJavaProject().getProject();
        this.m_configHelper = m_plugin.getConfigurationHelper(this.m_project);
        this.m_inspector = new InspectionAction();
    }

    public void inspect(ICompilationUnit cu) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (!workspace.isTreeLocked()) {
                IResourceRuleFactory ruleFactory = workspace.getRuleFactory();
                ISchedulingRule rule = ruleFactory.markerRule(cu.getResource());
                this.m_inspector.setTarget(cu);
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this.m_inspector, rule, 1, null);
            }
        }
        catch (CoreException ce) {
            m_plugin.openError("Problem inspecting '" + cu.getElementName() + "'", ce);
        }
    }

    public boolean visit(CompilationUnit node) {
        return true;
    }

    private static IType typeFromTypeBinding(ITypeBinding typeBinding) {
        IJavaElement o;
        if (typeBinding != null && (o = typeBinding.getJavaElement()) instanceof IType) {
            return (IType)o;
        }
        return null;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding != null) {
            Type superType;
            List superInterfaces;
            IType type = CompilationUnitVisitor.typeFromTypeBinding(binding);
            if (type != null) {
                String fullName;
                JavaModelClassInfo classInfo = PatternHelper.getHelper().getClassInfo(type);
                if (classInfo instanceof JavaModelClassInfo) {
                    JavaModelClassInfo jmci = classInfo;
                    jmci.clearAnnotations();
                    for (Object o : node.modifiers()) {
                        if (!(o instanceof Annotation)) continue;
                        jmci.addAnnotation((Annotation)o);
                    }
                }
                if (this.m_configHelper.isAdaptable(fullName = PatternHelper.getFullyQualifiedName(type))) {
                    this.addMarker("adaptedTypeMarker", "DSO Adapted Type", (ASTNode)node.getName());
                } else if (this.m_configHelper.isExcluded(fullName)) {
                    this.addMarker("excludedTypeMarker", "DSO Excluded Type", (ASTNode)node.getName());
                }
            }
            if ((superInterfaces = node.superInterfaceTypes()) != null) {
                for (Type t : superInterfaces) {
                    binding = t.resolveBinding();
                    if (binding == null || binding.isPrimitive() || binding.isTypeVariable()) continue;
                    type = CompilationUnitVisitor.typeFromTypeBinding(binding);
                    String fullName = PatternHelper.getFullyQualifiedName(type);
                    if (m_plugin.isBootClass(this.m_project, fullName) || this.m_configHelper.isBootJarClass(fullName)) {
                        this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)t);
                        continue;
                    }
                    if (this.m_configHelper.isAdaptable(fullName)) {
                        this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)t);
                        continue;
                    }
                    if (!this.m_configHelper.isExcluded(fullName)) continue;
                    this.addMarker("excludedTypeMarker", "DSO Excluded Type", (ASTNode)t);
                }
            }
            if ((superType = node.getSuperclassType()) != null && (binding = superType.resolveBinding()) != null && !binding.isPrimitive() && !binding.isTypeVariable() && (type = CompilationUnitVisitor.typeFromTypeBinding(binding)) != null) {
                String fullName = PatternHelper.getFullyQualifiedName(type);
                if (m_plugin.isBootClass(this.m_project, fullName) || this.m_configHelper.isBootJarClass(fullName)) {
                    this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)superType);
                } else if (this.m_configHelper.isAdaptable(fullName)) {
                    this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)superType);
                } else if (this.m_configHelper.isExcluded(fullName)) {
                    this.addMarker("excludedTypeMarker", "DSO Excluded Type", (ASTNode)superType);
                }
            }
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        Type typeNode = node.getType();
        ITypeBinding binding = typeNode.resolveBinding();
        if (binding != null && (binding.isPrimitive() || binding.isClass() || binding.isInterface())) {
            IType type = CompilationUnitVisitor.typeFromTypeBinding(binding);
            List fragments = node.fragments();
            for (VariableDeclarationFragment vdf : fragments) {
                IField field = (IField)vdf.resolveBinding().getJavaElement();
                FieldInfo fieldInfo = PatternHelper.getHelper().getFieldInfo(field);
                if (!(fieldInfo instanceof JavaModelFieldInfo)) continue;
                JavaModelFieldInfo jmfi = (JavaModelFieldInfo)fieldInfo;
                jmfi.clearAnnotations();
                for (Object o : node.modifiers()) {
                    if (!(o instanceof Annotation)) continue;
                    jmfi.addAnnotation((Annotation)o);
                }
            }
            if (type != null) {
                String fullName = PatternHelper.getFullyQualifiedName(type);
                if (m_plugin.isBootClass(this.m_project, fullName) || this.m_configHelper.isBootJarClass(fullName)) {
                    this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)typeNode);
                } else if (this.m_configHelper.isAdaptable(fullName)) {
                    this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)typeNode);
                } else if (this.m_configHelper.isExcluded(fullName)) {
                    this.addMarker("excludedTypeMarker", "DSO Excluded Type", (ASTNode)typeNode);
                }
            }
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        IMethodBinding methodBinding = node.resolveBinding();
        if (methodBinding != null) {
            IMethod method = (IMethod)methodBinding.getJavaElement();
            MethodInfo methodInfo = PatternHelper.getHelper().getMethodInfo(method);
            if (methodInfo instanceof JavaModelMethodInfo) {
                JavaModelMethodInfo jmmi = (JavaModelMethodInfo)methodInfo;
                jmmi.clearAnnotations();
                for (Object o : node.modifiers()) {
                    if (!(o instanceof Annotation)) continue;
                    jmmi.addAnnotation((Annotation)o);
                }
            }
        }
        if (this.isDeclaringTypeAdaptable(node)) {
            if (this.m_configHelper.isAutolocked(node) && CompilationUnitVisitor.hasSynchronization(node)) {
                this.addMarker("autolockedMarker", "DSO Auto-locked Method", (ASTNode)node.getName());
            } else if (this.m_configHelper.isNameLocked(node)) {
                this.addMarker("nameLockedMarker", "DSO Name-locked Method", (ASTNode)node.getName());
            }
        }
        if (this.m_configHelper.isDistributedMethod(node)) {
            this.addMarker("distributedMethodMarker", "DSO Distributed Method", (ASTNode)node.getName());
            if (!this.isDeclaringTypeAdaptable(node)) {
                this.addProblemMarker("DeclaringTypeNotInstrumentedMarker", "Declaring type not instrumented", (ASTNode)node.getName());
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null && binding.isConstructor()) {
            ITypeBinding declaringType = binding.getDeclaringClass();
            String fullName = declaringType.getQualifiedName();
            if (m_plugin.isBootClass(this.m_project, fullName) || this.m_configHelper.isBootJarClass(fullName)) {
                this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)node.getName());
            } else if (this.m_configHelper.isAdaptable(fullName)) {
                this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)node.getName());
            }
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        Type type = node.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding != null) {
            String fullName = binding.getQualifiedName();
            if (m_plugin.isBootClass(this.m_project, fullName) || this.m_configHelper.isBootJarClass(fullName)) {
                this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)type);
            } else if (this.m_configHelper.isAdaptable(fullName)) {
                this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)type);
            }
        }
        return true;
    }

    public boolean visit(Block node) {
        return true;
    }

    public boolean visit(SynchronizedStatement node) {
        return true;
    }

    public boolean visit(WhileStatement node) {
        return true;
    }

    public boolean visit(TryStatement node) {
        return true;
    }

    public boolean visit(ForStatement node) {
        return true;
    }

    public boolean visit(IfStatement node) {
        return true;
    }

    public boolean visit(SwitchStatement node) {
        return true;
    }

    public boolean visit(LabeledStatement node) {
        return true;
    }

    public boolean visit(InstanceofExpression node) {
        return true;
    }

    public boolean visit(Initializer node) {
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        String fullName;
        IVariableBinding binding = node.resolveBinding();
        if (binding != null && (m_plugin.isBootClass(this.m_project, fullName = binding.getType().getQualifiedName()) || this.m_configHelper.isBootJarClass(fullName))) {
            this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)node.getType());
        }
        return true;
    }

    private static String getQualifiedName(ITypeBinding binding) {
        String qname = binding.getQualifiedName();
        if (binding.isMember()) {
            int lastDot = qname.lastIndexOf(46);
            qname = qname.substring(0, lastDot) + '$' + qname.substring(lastDot + 1);
        }
        return qname;
    }

    public boolean visit(VariableDeclarationFragment node) {
        IVariableBinding binding = node.resolveBinding();
        if (binding != null) {
            String typeName;
            if (binding.isField()) {
                String parentClass = CompilationUnitVisitor.getQualifiedName(binding.getDeclaringClass());
                String fieldName = parentClass + "." + binding.getName();
                IField field = (IField)binding.getJavaElement();
                FieldInfo fieldInfo = PatternHelper.getHelper().getFieldInfo(field);
                if (fieldInfo instanceof JavaModelFieldInfo) {
                    JavaModelFieldInfo jmfi = (JavaModelFieldInfo)fieldInfo;
                    ASTNode parent = node.getParent();
                    if (parent instanceof BodyDeclaration) {
                        BodyDeclaration body = (BodyDeclaration)parent;
                        jmfi.clearAnnotations();
                        for (Object o : body.modifiers()) {
                            if (!(o instanceof Annotation)) continue;
                            jmfi.addAnnotation((Annotation)o);
                        }
                    }
                }
                if (this.m_configHelper.isRoot(field)) {
                    this.addMarker("rootMarker", "DSO Root Field", (ASTNode)node.getName());
                } else if (this.m_configHelper.isTransient(fieldName)) {
                    this.addMarker("transientFieldMarker", "DSO Transient Field", (ASTNode)node.getName());
                    if (!this.m_configHelper.isAdaptable(parentClass) && !this.m_configHelper.declaresRoot(parentClass)) {
                        this.addProblemMarker("DeclaringTypeNotInstrumentedMarker", "Declaring type not instrumented", (ASTNode)node);
                    }
                }
            }
            if (m_plugin.isBootClass(this.m_project, typeName = binding.getType().getQualifiedName()) || this.m_configHelper.isBootJarClass(typeName)) {
                this.addMarker("bootJarTypeMarker", "BootJar Type", (ASTNode)this.getType(node));
            } else if (this.m_configHelper.isAdaptable(typeName)) {
                this.addMarker("adaptedTypeReferenceMarker", "DSO Instrumented Type Reference", (ASTNode)this.getType(node));
            }
        }
        return true;
    }

    private Type getType(VariableDeclarationFragment node) {
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof FieldDeclaration) {
            return ((FieldDeclaration)node.getParent()).getType();
        }
        if (parentNode instanceof VariableDeclarationStatement) {
            return ((VariableDeclarationStatement)node.getParent()).getType();
        }
        if (parentNode instanceof VariableDeclarationExpression) {
            return ((VariableDeclarationExpression)node.getParent()).getType();
        }
        return null;
    }

    private static boolean hasSynchronization(MethodDeclaration node) {
        if (Modifier.isSynchronized((int)node.getModifiers())) {
            return true;
        }
        Block body = node.getBody();
        if (body != null) {
            return CompilationUnitVisitor.hasSynchronization(body);
        }
        return false;
    }

    private static boolean hasSynchronization(Block block) {
        List statements = block.statements();
        if (statements != null) {
            Iterator iter = statements.iterator();
            while (iter.hasNext()) {
                if (!CompilationUnitVisitor.hasSynchronization((Statement)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasSynchronization(Statement statement) {
        if (statement instanceof SynchronizedStatement) {
            return true;
        }
        if (statement instanceof Block) {
            return CompilationUnitVisitor.hasSynchronization((Block)statement);
        }
        if (statement instanceof ForStatement) {
            return CompilationUnitVisitor.hasSynchronization(((ForStatement)statement).getBody());
        }
        if (statement instanceof EnhancedForStatement) {
            return CompilationUnitVisitor.hasSynchronization(((EnhancedForStatement)statement).getBody());
        }
        if (statement instanceof IfStatement) {
            return CompilationUnitVisitor.hasSynchronization((IfStatement)statement);
        }
        if (statement instanceof WhileStatement) {
            return CompilationUnitVisitor.hasSynchronization((WhileStatement)statement);
        }
        if (statement instanceof DoStatement) {
            return CompilationUnitVisitor.hasSynchronization((DoStatement)statement);
        }
        if (statement instanceof TryStatement) {
            return CompilationUnitVisitor.hasSynchronization((TryStatement)statement);
        }
        if (statement instanceof SwitchStatement) {
            return CompilationUnitVisitor.hasSynchronization((SwitchStatement)statement);
        }
        return false;
    }

    private static boolean hasSynchronization(IfStatement statement) {
        Statement thenStatement = statement.getThenStatement();
        Statement elseStatement = statement.getElseStatement();
        return CompilationUnitVisitor.hasSynchronization(thenStatement) || elseStatement != null && CompilationUnitVisitor.hasSynchronization(elseStatement);
    }

    private static boolean hasSynchronization(WhileStatement statement) {
        return CompilationUnitVisitor.hasSynchronization(statement.getBody());
    }

    private static boolean hasSynchronization(DoStatement statement) {
        return CompilationUnitVisitor.hasSynchronization(statement.getBody());
    }

    private static boolean hasSynchronization(TryStatement statement) {
        return CompilationUnitVisitor.hasSynchronization(statement.getBody());
    }

    private static boolean hasSynchronization(SwitchStatement statement) {
        List statements = statement.statements();
        if (statements != null) {
            Iterator iter = statements.iterator();
            while (iter.hasNext()) {
                if (!CompilationUnitVisitor.hasSynchronization((Statement)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDeclaringTypeAdaptable(MethodDeclaration node) {
        IMethod method;
        IMethodBinding binding = node.resolveBinding();
        if (binding != null && (method = (IMethod)binding.getJavaElement()) != null) {
            IType type = method.getDeclaringType();
            return this.m_configHelper.isAdaptable(type) || this.m_configHelper.declaresRoot(type);
        }
        return false;
    }

    private void addMarker(String markerID, String msg, ASTNode node) {
        if (node == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int startPos = node.getStartPosition();
        int endPos = startPos + node.getLength();
        int line = this.m_ast.lineNumber(startPos);
        MarkerUtilities.setMessage(map, (String)msg);
        MarkerUtilities.setCharStart(map, (int)startPos);
        MarkerUtilities.setCharEnd(map, (int)endPos);
        MarkerUtilities.setLineNumber(map, (int)line);
        map.put("severity", 0);
        this.createMarker(this.m_res, map, markerID);
    }

    private void addProblemMarker(String markerID, String msg, ASTNode node) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int startPos = node.getStartPosition();
        int endPos = startPos + node.getLength();
        int line = this.m_ast.lineNumber(startPos);
        MarkerUtilities.setMessage(map, (String)msg);
        MarkerUtilities.setCharStart(map, (int)startPos);
        MarkerUtilities.setCharEnd(map, (int)endPos);
        MarkerUtilities.setLineNumber(map, (int)line);
        map.put("severity", 1);
        this.createMarker(this.m_res, map, markerID);
    }

    private void createMarker(IResource resource, Map attributes, String markerType) {
        try {
            IMarker marker = resource.createMarker("org.terracotta.dso." + markerType);
            marker.setAttributes(attributes);
        }
        catch (CoreException ce) {
            m_plugin.openError("Creating marker", ce);
        }
    }

    protected void clearTerracottaMarkers() {
        if (this.m_res.exists() && this.m_res.getProject().isOpen()) {
            try {
                this.m_res.deleteMarkers("org.terracotta.dso.baseMarker", true, 0);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.m_res.deleteMarkers("org.terracotta.dso.ConfigProblemMarker", true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(ArrayAccess node) {
        return false;
    }

    public boolean visit(ArrayCreation node) {
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        return false;
    }

    public boolean visit(ArrayType node) {
        return false;
    }

    public boolean visit(AssertStatement node) {
        return false;
    }

    public boolean visit(Assignment node) {
        return true;
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return false;
    }

    public boolean visit(BreakStatement node) {
        return false;
    }

    public boolean visit(CastExpression node) {
        return true;
    }

    public boolean visit(CatchClause node) {
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        return true;
    }

    public boolean visit(ContinueStatement node) {
        return false;
    }

    public boolean visit(DoStatement node) {
        return true;
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        return true;
    }

    public boolean visit(FieldAccess node) {
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InfixExpression node) {
        return false;
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public boolean visit(MemberValuePair node) {
        return false;
    }

    public boolean visit(MethodRef node) {
        return false;
    }

    public boolean visit(MethodRefParameter node) {
        return false;
    }

    public boolean visit(Modifier node) {
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public boolean visit(NullLiteral node) {
        return false;
    }

    public boolean visit(NumberLiteral node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParameterizedType node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return false;
    }

    public boolean visit(PostfixExpression node) {
        return false;
    }

    public boolean visit(PrefixExpression node) {
        return false;
    }

    public boolean visit(PrimitiveType node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        return false;
    }

    public boolean visit(QualifiedType node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        return false;
    }

    public boolean visit(SimpleName node) {
        return false;
    }

    public boolean visit(SimpleType node) {
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public boolean visit(StringLiteral node) {
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        return false;
    }

    public boolean visit(SwitchCase node) {
        return false;
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public boolean visit(TextElement node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        return false;
    }

    public boolean visit(ThrowStatement node) {
        return false;
    }

    public boolean visit(TypeLiteral node) {
        return false;
    }

    public boolean visit(WildcardType node) {
        return false;
    }

    class InspectionAction
    implements IWorkspaceRunnable {
        private ICompilationUnit m_target;

        InspectionAction() {
        }

        void setTarget(ICompilationUnit target) {
            this.m_target = target;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            CompilationUnitVisitor.this.setup(this.m_target);
            CompilationUnitVisitor.this.clearTerracottaMarkers();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(this.m_target);
            parser.setResolveBindings(true);
            CompilationUnitVisitor.this.m_ast = (CompilationUnit)parser.createAST(monitor);
            CompilationUnitVisitor.this.m_ast.accept((ASTVisitor)CompilationUnitVisitor.this);
            CompilationUnitVisitor.this.m_configHelper.validateAll();
        }
    }
}

